/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.CompositeService;
import org.apache.hive.service.auth.AuthenticationProviderFactory;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.auth.PasswdAuthenticationProvider;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.HandleIdentifier;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.session.SessionManager;
import org.apache.hive.service.cli.thrift.TSessionHandle;
import org.apache.lens.api.LensConf;
import org.apache.lens.api.LensException;
import org.apache.lens.api.LensSessionHandle;
import org.apache.lens.server.session.LensSessionImpl;
import org.apache.lens.server.user.UserConfigLoaderFactory;
import org.apache.lens.server.util.UtilityMethods;

public abstract class LensService
extends CompositeService
implements Externalizable {
    public static final Log LOG = LogFactory.getLog(LensService.class);
    private final CLIService cliService;
    protected boolean stopped = false;
    protected static ConcurrentHashMap<String, LensSessionHandle> sessionMap = new ConcurrentHashMap();

    protected LensService(String name, CLIService cliService) {
        super(name);
        this.cliService = cliService;
    }

    public CLIService getCliService() {
        return this.cliService;
    }

    public String getServerDomain() {
        return this.cliService.getHiveConf().get("lens.server.domain");
    }

    public LensSessionHandle openSession(String username, String password, Map<String, String> configuration) throws LensException {
        SessionHandle sessionHandle;
        block8: {
            if (StringUtils.isBlank((CharSequence)username)) {
                throw new BadRequestException("User name cannot be null or empty");
            }
            username = UtilityMethods.removeDomain(username);
            this.doPasswdAuth(username, password);
            try {
                HashMap<String, String> sessionConf = new HashMap<String, String>();
                sessionConf.putAll(LensSessionImpl.DEFAULT_HIVE_SESSION_CONF);
                if (configuration != null) {
                    sessionConf.putAll(configuration);
                }
                Map<String, String> userConfig = UserConfigLoaderFactory.getUserConfig(username);
                UtilityMethods.mergeMaps(sessionConf, userConfig, false);
                sessionConf.put("lens.session.loggedin.user", username);
                if (sessionConf.get("lens.session.cluster.user") == null) {
                    LOG.info((Object)("Didn't get cluster user from user config loader. Setting same as logged in user: " + username));
                    sessionConf.put("lens.session.cluster.user", username);
                }
                String clusterUser = (String)sessionConf.get("lens.session.cluster.user");
                password = "useless";
                if (this.cliService.getHiveConf().getVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION).equals(HiveAuthFactory.AuthTypes.KERBEROS.toString()) && this.cliService.getHiveConf().getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS)) {
                    String delegationTokenStr = null;
                    try {
                        delegationTokenStr = this.cliService.getDelegationTokenFromMetaStore(username);
                    }
                    catch (UnsupportedOperationException e) {
                        // empty catch block
                    }
                    sessionHandle = this.cliService.openSessionWithImpersonation(clusterUser, password, sessionConf, delegationTokenStr);
                    break block8;
                }
                sessionHandle = this.cliService.openSession(clusterUser, password, sessionConf);
            }
            catch (Exception e) {
                throw new LensException((Throwable)e);
            }
        }
        LensSessionHandle lensSession = new LensSessionHandle(sessionHandle.getHandleIdentifier().getPublicId(), sessionHandle.getHandleIdentifier().getSecretId());
        sessionMap.put(lensSession.getPublicId().toString(), lensSession);
        return lensSession;
    }

    public void restoreSession(LensSessionHandle sessionHandle, String userName, String password) throws LensException {
        HandleIdentifier handleIdentifier = new HandleIdentifier(sessionHandle.getPublicId(), sessionHandle.getSecretId());
        SessionHandle hiveSessionHandle = new SessionHandle(new TSessionHandle(handleIdentifier.toTHandleIdentifier()));
        try {
            SessionHandle restoredHandle = this.cliService.restoreSession(hiveSessionHandle, userName, password, new HashMap());
            LensSessionHandle restoredSession = new LensSessionHandle(restoredHandle.getHandleIdentifier().getPublicId(), restoredHandle.getHandleIdentifier().getSecretId());
            sessionMap.put(restoredSession.getPublicId().toString(), restoredSession);
        }
        catch (HiveSQLException e) {
            throw new LensException("Error restoring session " + sessionHandle, (Throwable)e);
        }
    }

    private void doPasswdAuth(String userName, String password) {
        for (HiveConf.ConfVars var : new HiveConf.ConfVars[]{HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_DOMAIN}) {
            if (this.cliService.getHiveConf().getVar(var) != null) continue;
            this.cliService.getHiveConf().setVar(var, this.cliService.getHiveConf().get("lens.server.domain"));
        }
        String authType = this.cliService.getHiveConf().getVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION);
        if (!authType.equalsIgnoreCase(HiveAuthFactory.AuthTypes.NOSASL.toString())) {
            try {
                AuthenticationProviderFactory.AuthMethods authMethod = AuthenticationProviderFactory.AuthMethods.getValidAuthMethod((String)authType);
                PasswdAuthenticationProvider provider = AuthenticationProviderFactory.getAuthenticationProvider((AuthenticationProviderFactory.AuthMethods)authMethod, (HiveConf)this.cliService.getHiveConf());
                provider.Authenticate(userName, password);
            }
            catch (Exception e) {
                LOG.error((Object)("Auth error: " + e));
                throw new NotAuthorizedException((Object)e, new Object[0]);
            }
        }
    }

    public void closeSession(LensSessionHandle sessionHandle) throws LensException {
        try {
            this.cliService.closeSession(LensService.getHiveSessionHandle(sessionHandle));
            sessionMap.remove(sessionHandle.getPublicId().toString());
        }
        catch (Exception e) {
            throw new LensException((Throwable)e);
        }
    }

    public SessionManager getSessionManager() {
        return this.cliService.getSessionManager();
    }

    public LensSessionImpl getSession(LensSessionHandle sessionHandle) {
        try {
            return (LensSessionImpl)this.getSessionManager().getSession(LensService.getHiveSessionHandle(sessionHandle));
        }
        catch (HiveSQLException exc) {
            LOG.warn((Object)("Session " + sessionHandle.getPublicId() + " not found"), (Throwable)exc);
            throw new NotFoundException("Session " + sessionHandle.getPublicId() + " not found " + sessionHandle);
        }
    }

    public void acquire(LensSessionHandle sessionHandle) {
        if (sessionHandle != null) {
            LOG.debug((Object)("Acquiring lens session:" + sessionHandle.getPublicId()));
            this.getSession(sessionHandle).acquire();
        }
    }

    public void acquire(String sessionHandle) {
        this.acquire(sessionMap.get(sessionHandle));
    }

    public void release(LensSessionHandle sessionHandle) {
        if (sessionHandle != null) {
            this.getSession(sessionHandle).release();
            LOG.debug((Object)("Released lens session:" + sessionHandle.getPublicId()));
        }
    }

    public void release(String sessionHandle) throws LensException {
        this.getSession(sessionMap.get(sessionHandle)).release();
    }

    protected LensSessionHandle getSessionHandle(String sessionid) {
        return sessionMap.get(sessionid);
    }

    public void addResource(LensSessionHandle sessionHandle, String type, String path) throws LensException {
    }

    public void deleteResource(LensSessionHandle sessionHandle, String type, String path) throws LensException {
    }

    public static SessionHandle getHiveSessionHandle(LensSessionHandle lensHandle) {
        return new SessionHandle(new HandleIdentifier(lensHandle.getPublicId(), lensHandle.getSecretId()), CLIService.SERVER_VERSION);
    }

    public Configuration getLensConf(LensSessionHandle sessionHandle, LensConf conf) throws LensException {
        Configuration qconf = new Configuration(false);
        for (Map.Entry entry : this.getSession(sessionHandle).getSessionConf()) {
            qconf.set((String)entry.getKey(), (String)entry.getValue());
        }
        if (conf != null && !conf.getProperties().isEmpty()) {
            for (Map.Entry entry : conf.getProperties().entrySet()) {
                qconf.set((String)entry.getKey(), (String)entry.getValue());
            }
        }
        qconf.setClassLoader(this.getSession(sessionHandle).getHiveConf().getClassLoader());
        return qconf;
    }

    public Configuration getLensConf(LensConf conf) throws LensException {
        Configuration qconf = LensSessionImpl.createDefaultConf();
        if (conf != null && !conf.getProperties().isEmpty()) {
            for (Map.Entry entry : conf.getProperties().entrySet()) {
                qconf.set((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return qconf;
    }

    public void prepareStopping() {
        this.stopped = true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }
}

