/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.CompositeService;
import org.apache.hive.service.Service;
import org.apache.hive.service.cli.CLIService;
import org.apache.lens.server.EventServiceImpl;
import org.apache.lens.server.LensService;
import org.apache.lens.server.MetricsServiceImpl;
import org.apache.lens.server.api.LensConfConstants;
import org.apache.lens.server.api.ServiceProvider;
import org.apache.lens.server.session.LensSessionImpl;
import org.apache.lens.server.stats.StatisticsService;
import org.apache.lens.server.user.UserConfigLoaderFactory;

public class LensServices
extends CompositeService
implements ServiceProvider {
    public static final Log LOG = LogFactory.getLog(LensServices.class);
    public static final String LENS_SERVICES_NAME = "lens_services";
    private static final String FS_AUTOMATIC_CLOSE = "fs.automatic.close";
    private static final String FS_IO_FILE_BUFFER_SIZE = "io.file.buffer.size";
    private static LensServices INSTANCE = new LensServices("lens_services");
    private HiveConf conf;
    private CLIService cliService;
    private final Map<String, Service> services = new LinkedHashMap<String, Service>();
    private final List<LensService> lensServices = new ArrayList<LensService>();
    private Path persistDir;
    private FileSystem persistenceFS;
    private boolean stopping = false;
    private long snapShotInterval;
    private SERVICE_MODE serviceMode;
    private Timer timer;
    private final Object statePersistenceLock = new Object();

    public LensServices(String name) {
        super(name);
    }

    static void setInstance(LensServices newInstance) {
        INSTANCE = newInstance;
    }

    public synchronized void init(HiveConf hiveConf) {
        if (this.getServiceState() == Service.STATE.NOTINITED) {
            String[] serviceNames;
            this.conf = hiveConf;
            this.conf.addResource("lensserver-default.xml");
            this.conf.addResource("lens-site.xml");
            this.conf.setVar(HiveConf.ConfVars.HIVE_SESSION_IMPL_CLASSNAME, LensSessionImpl.class.getCanonicalName());
            this.serviceMode = (SERVICE_MODE)this.conf.getEnum("lens.server.mode", (Enum)SERVICE_MODE.valueOf("OPEN"));
            this.cliService = new CLIService();
            this.addService((Service)this.cliService);
            this.addService((Service)new EventServiceImpl("event"));
            this.addService((Service)new MetricsServiceImpl("metrics"));
            this.addService((Service)new StatisticsService("stats"));
            for (String sName : serviceNames = this.conf.getStrings("lens.server.servicenames")) {
                try {
                    Class<?> serviceClass;
                    String serviceClassName = this.conf.get(LensConfConstants.getServiceImplConfKey((String)sName));
                    if (StringUtils.isBlank((CharSequence)serviceClassName)) {
                        LOG.warn((Object)("Invalid class for service " + sName + " class=" + serviceClassName));
                        continue;
                    }
                    Class<?> cls = Class.forName(serviceClassName);
                    if (LensService.class.isAssignableFrom(cls)) {
                        serviceClass = cls;
                        LOG.info((Object)("Adding " + sName + " service with " + serviceClass));
                        Constructor<?> constructor = serviceClass.getConstructor(CLIService.class);
                        LensService service = (LensService)constructor.newInstance(this.cliService);
                        this.addService((Service)service);
                        this.lensServices.add(service);
                        continue;
                    }
                    if (Service.class.isAssignableFrom(cls)) {
                        serviceClass = cls;
                        Service svc = (Service)serviceClass.newInstance();
                        this.addService(svc);
                        continue;
                    }
                    LOG.warn((Object)("Unsupported service class " + serviceClassName + " for service " + sName));
                }
                catch (Exception e) {
                    LOG.warn((Object)("Could not add service:" + sName), (Throwable)e);
                    throw new RuntimeException("Could not add service:" + sName, e);
                }
            }
            for (Service svc : this.getServices()) {
                this.services.put(svc.getName(), svc);
            }
            super.init(this.conf);
            String persistPathStr = this.conf.get("lens.server.persist.location", "file:///tmp/lensserver");
            this.persistDir = new Path(persistPathStr);
            try {
                Configuration configuration = new Configuration((Configuration)this.conf);
                configuration.setBoolean(FS_AUTOMATIC_CLOSE, false);
                int outStreamBufferSize = this.conf.getInt("lens.server.state.persist.out.stream.buffer.size", 0x100000);
                configuration.setInt(FS_IO_FILE_BUFFER_SIZE, outStreamBufferSize);
                LOG.info((Object)("STATE_PERSIST_OUT_STREAM_BUFF_SIZE IN BYTES:" + outStreamBufferSize));
                this.persistenceFS = FileSystem.newInstance((URI)this.persistDir.toUri(), (Configuration)configuration);
                this.setupPersistedState();
            }
            catch (Exception e) {
                LOG.error((Object)"Could not recover from persisted state", (Throwable)e);
                throw new RuntimeException("Could not recover from persisted state", e);
            }
            this.snapShotInterval = this.conf.getLong("lens.server.snapshot.interval", 300000L);
            LOG.info((Object)("Initialized services: " + this.services.keySet().toString()));
            UserConfigLoaderFactory.init(this.conf);
            this.timer = new Timer("lens-server-snapshotter", true);
        }
    }

    public synchronized void start() {
        if (this.getServiceState() != Service.STATE.STARTED) {
            super.start();
        }
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    LensServices.this.persistLensServiceState();
                    LOG.info((Object)"SnapShot of Lens Services created");
                }
                catch (IOException e) {
                    LOG.warn((Object)"Unable to persist lens server state", (Throwable)e);
                }
            }
        }, this.snapShotInterval, this.snapShotInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupPersistedState() throws IOException, ClassNotFoundException {
        if (this.conf.getBoolean("lens.server.recover.onrestart", true)) {
            for (LensService service : this.lensServices) {
                ObjectInputStream in = null;
                try {
                    in = new ObjectInputStream((InputStream)this.persistenceFS.open(this.getServicePersistPath(service)));
                }
                catch (FileNotFoundException fe) {
                    LOG.warn((Object)("No persist path available for service:" + service.getName()));
                    if (in == null) continue;
                    in.close();
                    continue;
                }
                try {
                    service.readExternal(in);
                    LOG.info((Object)("Recovered service " + service.getName() + " from persisted state"));
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistLensServiceState() throws IOException {
        Object object = this.statePersistenceLock;
        synchronized (object) {
            if (this.conf.getBoolean("lens.server.restart.enabled", true)) {
                if (this.persistDir != null) {
                    LOG.info((Object)("Persisting server state in " + this.persistDir));
                    long now = System.currentTimeMillis();
                    for (LensService service : this.lensServices) {
                        LOG.info((Object)("Persisting state of service:" + service.getName()));
                        Path serviceWritePath = new Path(this.persistDir, service.getName() + ".out" + "." + now);
                        ObjectOutputStream out = null;
                        try {
                            out = new ObjectOutputStream((OutputStream)this.persistenceFS.create(serviceWritePath));
                            service.writeExternal(out);
                        }
                        finally {
                            if (out != null) {
                                out.close();
                            }
                        }
                        Path servicePath = this.getServicePersistPath(service);
                        if (this.persistenceFS.exists(servicePath) && !this.persistenceFS.delete(servicePath, true)) {
                            LOG.error((Object)("Failed to delete [" + servicePath + "]"));
                        }
                        if (!this.persistenceFS.rename(serviceWritePath, servicePath)) {
                            LOG.error((Object)("Failed to persist " + service.getName() + " to [" + servicePath + "]"));
                            continue;
                        }
                        LOG.info((Object)("Persisted service " + service.getName() + " to [" + servicePath + "]"));
                    }
                } else {
                    LOG.info((Object)"Server restart is not enabled. Not persisting the server state");
                }
            }
        }
    }

    private Path getServicePersistPath(LensService service) {
        return new Path(this.persistDir, service.getName() + ".final");
    }

    public synchronized void stop() {
        if (this.getServiceState() != Service.STATE.STOPPED) {
            LOG.info((Object)"Stopping lens server");
            this.stopping = true;
            for (LensService service : this.lensServices) {
                service.prepareStopping();
            }
            if (this.timer != null) {
                this.timer.cancel();
            }
            try {
                this.persistLensServiceState();
                this.persistenceFS.close();
                LOG.info((Object)"Persistence File system object close complete");
            }
            catch (IOException e) {
                LOG.error((Object)"Could not persist server state", (Throwable)e);
                throw new IllegalStateException(e);
            }
            finally {
                super.stop();
            }
        }
    }

    public Service.STATE getServiceState() {
        return super.getServiceState();
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public static LensServices get() {
        return INSTANCE;
    }

    public <T extends Service> T getService(String sName) {
        return (T)this.services.get(sName);
    }

    public List<LensService> getLensServices() {
        return this.lensServices;
    }

    public SERVICE_MODE getServiceMode() {
        return this.serviceMode;
    }

    public void setServiceMode(SERVICE_MODE serviceMode) {
        this.serviceMode = serviceMode;
    }

    public static enum SERVICE_MODE {
        READ_ONLY,
        METASTORE_READONLY,
        METASTORE_NODROP,
        OPEN;

    }
}

