/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.CompositeService;
import org.apache.lens.server.LensServerConf;
import org.apache.lens.server.LensServices;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.PropertyConfigurator;

public class LensServletContextListener
implements ServletContextListener {
    public static final String LOG_PROPERTIES_FILE_KEY = "lens.server.log4j.properties";

    public void contextInitialized(ServletContextEvent sce) {
        try {
            String log4jPropertyFile = sce.getServletContext().getInitParameter(LOG_PROPERTIES_FILE_KEY);
            if (log4jPropertyFile != null && !log4jPropertyFile.isEmpty()) {
                String basePath = sce.getServletContext().getRealPath("/");
                System.out.println("Application BasePath:" + basePath);
                PropertyConfigurator.configure((String)(basePath + "/" + log4jPropertyFile));
            } else {
                System.err.println("WARN - Empty value for lens.server.log4j.properties, using BasicConfigurator");
                BasicConfigurator.configure();
            }
        }
        catch (Exception exc) {
            System.err.println("WARNING - log4j property configurator gave error, falling back to basic configurator");
            exc.printStackTrace();
            BasicConfigurator.configure();
        }
        HiveConf conf = LensServerConf.get();
        LensServices services = LensServices.get();
        services.init(conf);
        services.start();
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)new CompositeService.CompositeServiceShutdownHook((CompositeService)services)));
    }

    public void contextDestroyed(ServletContextEvent sce) {
        LensServices.get().stop();
    }
}

