/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.JvmAttributeGaugeSet;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.ganglia.GangliaReporter;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import info.ganglia.gmetric4j.gmetric.GMetric;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.AbstractService;
import org.apache.lens.api.query.QueryStatus;
import org.apache.lens.server.LensServices;
import org.apache.lens.server.api.events.AsyncEventListener;
import org.apache.lens.server.api.events.LensEventService;
import org.apache.lens.server.api.metrics.MetricsService;
import org.apache.lens.server.api.query.QueryExecutionService;
import org.apache.lens.server.api.query.StatusChange;
import org.apache.log4j.Logger;

public class MetricsServiceImpl
extends AbstractService
implements MetricsService {
    public static final String METRICS_SVC_NAME = "metrics";
    public static final Logger LOG = Logger.getLogger(MetricsService.class);
    private AsyncEventListener<StatusChange> queryStatusListener;
    private MetricRegistry metricRegistry;
    private List<ScheduledReporter> reporters;
    private HealthCheckRegistry healthCheck;
    private Counter totalAcceptedQueries;
    private Counter totalSuccessfulQueries;
    private Counter totalFinishedQueries;
    private Counter totalFailedQueries;
    private Counter totalCancelledQueries;
    private Gauge<Long> queuedQueries;
    private Gauge<Long> runningQueries;
    private Gauge<Long> finishedQueries;
    private static int timeBetweenPolls = 10;

    public MetricsServiceImpl(String name) {
        super(METRICS_SVC_NAME);
    }

    private QueryExecutionService getQuerySvc() {
        return (QueryExecutionService)LensServices.get().getService("query");
    }

    public synchronized void init(HiveConf hiveConf) {
        this.queryStatusListener = new AsyncQueryStatusListener();
        LensEventService eventService = (LensEventService)LensServices.get().getService("event");
        eventService.addListenerForType(this.queryStatusListener, StatusChange.class);
        this.metricRegistry = new MetricRegistry();
        this.healthCheck = new HealthCheckRegistry();
        this.initCounters();
        timeBetweenPolls = hiveConf.getInt("lens.server.metrics.reporting.period", 10);
        this.reporters = new ArrayList<ScheduledReporter>();
        if (hiveConf.getBoolean("lens.server.enable.console.metrics", false)) {
            ConsoleReporter reporter = ConsoleReporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
            this.reporters.add((ScheduledReporter)reporter);
        }
        if (hiveConf.getBoolean("lens.server.enable.ganglia.metrics", false)) {
            try {
                GMetric ganglia = new GMetric(hiveConf.get("lens.server.metrics.ganglia.host"), hiveConf.getInt("lens.server.metrics.ganglia.port", 8080), GMetric.UDPAddressingMode.MULTICAST, 1);
                GangliaReporter greporter = GangliaReporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(ganglia);
                this.reporters.add((ScheduledReporter)greporter);
            }
            catch (IOException e) {
                LOG.error((Object)"Could not start ganglia reporter", (Throwable)e);
            }
        }
        LOG.info((Object)"Started metrics service");
        super.init(hiveConf);
    }

    protected void initCounters() {
        this.queuedQueries = (Gauge)this.metricRegistry.register(MetricRegistry.name(QueryExecutionService.class, (String[])new String[]{"queued-queries"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return MetricsServiceImpl.this.getQuerySvc().getQueuedQueriesCount();
            }
        });
        this.runningQueries = (Gauge)this.metricRegistry.register(MetricRegistry.name(QueryExecutionService.class, (String[])new String[]{"running-queries"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return MetricsServiceImpl.this.getQuerySvc().getRunningQueriesCount();
            }
        });
        this.finishedQueries = (Gauge)this.metricRegistry.register(MetricRegistry.name(QueryExecutionService.class, (String[])new String[]{"finished-queries"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return MetricsServiceImpl.this.getQuerySvc().getFinishedQueriesCount();
            }
        });
        this.totalAcceptedQueries = this.metricRegistry.counter(MetricRegistry.name(QueryExecutionService.class, (String[])new String[]{"total-accepted-queries"}));
        this.totalSuccessfulQueries = this.metricRegistry.counter(MetricRegistry.name(QueryExecutionService.class, (String[])new String[]{"total-success-queries"}));
        this.totalFinishedQueries = this.metricRegistry.counter(MetricRegistry.name(QueryExecutionService.class, (String[])new String[]{"total-finished-queries"}));
        this.totalFailedQueries = this.metricRegistry.counter(MetricRegistry.name(QueryExecutionService.class, (String[])new String[]{"total-failed-queries"}));
        this.totalCancelledQueries = this.metricRegistry.counter(MetricRegistry.name(QueryExecutionService.class, (String[])new String[]{"total-cancelled-queries"}));
        this.metricRegistry.register("gc", (Metric)new GarbageCollectorMetricSet());
        this.metricRegistry.register("memory", (Metric)new MemoryUsageGaugeSet());
        this.metricRegistry.register("threads", (Metric)new ThreadStatesGaugeSet());
        this.metricRegistry.register("jvm", (Metric)new JvmAttributeGaugeSet());
    }

    public synchronized void start() {
        for (ScheduledReporter reporter : this.reporters) {
            reporter.start((long)timeBetweenPolls, TimeUnit.SECONDS);
        }
        super.start();
    }

    public synchronized void stop() {
        LensEventService eventService = (LensEventService)LensServices.get().getService("event");
        if (eventService != null) {
            eventService.removeListener(this.queryStatusListener);
        }
        if (this.queryStatusListener != null) {
            this.queryStatusListener.stop();
        }
        if (this.reporters != null) {
            for (ScheduledReporter reporter : this.reporters) {
                reporter.stop();
            }
        }
        LOG.info((Object)"Stopped metrics service");
        super.stop();
    }

    public void incrCounter(String counter) {
        this.incrCounter(MetricsService.class, counter);
    }

    public void decrCounter(String counter) {
        this.decrCounter(MetricsService.class, counter);
    }

    public void incrCounter(Class<?> cls, String counter) {
        this.metricRegistry.counter(MetricRegistry.name(cls, (String[])new String[]{counter})).inc();
    }

    public void decrCounter(Class<?> cls, String counter) {
        this.metricRegistry.counter(MetricRegistry.name(cls, (String[])new String[]{counter})).dec();
    }

    public long getCounter(String counter) {
        return this.metricRegistry.counter(MetricRegistry.name(MetricsService.class, (String[])new String[]{counter})).getCount();
    }

    public long getCounter(Class<?> cls, String counter) {
        return this.metricRegistry.counter(MetricRegistry.name(cls, (String[])new String[]{counter})).getCount();
    }

    public long getQueuedQueries() {
        return (Long)this.queuedQueries.getValue();
    }

    public long getRunningQueries() {
        return (Long)this.runningQueries.getValue();
    }

    public long getFinishedQueries() {
        return (Long)this.finishedQueries.getValue();
    }

    public long getTotalAcceptedQueries() {
        return this.totalAcceptedQueries.getCount();
    }

    public long getTotalFinishedQueries() {
        return this.totalFinishedQueries.getCount();
    }

    public long getTotalCancelledQueries() {
        return this.totalCancelledQueries.getCount();
    }

    public long getTotalFailedQueries() {
        return this.totalFailedQueries.getCount();
    }

    public void publishReport() {
        if (this.reporters != null) {
            for (ScheduledReporter reporter : this.reporters) {
                reporter.report();
            }
        }
    }

    public long getTotalSuccessfulQueries() {
        return this.totalSuccessfulQueries.getCount();
    }

    protected List<ScheduledReporter> getReporters() {
        return this.reporters;
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public HealthCheckRegistry getHealthCheck() {
        return this.healthCheck;
    }

    public class AsyncQueryStatusListener
    extends AsyncEventListener<StatusChange> {
        public void process(StatusChange event) {
            this.processCurrentStatus((QueryStatus.Status)event.getCurrentValue());
        }

        protected void processCurrentStatus(QueryStatus.Status currentValue) {
            switch (currentValue) {
                case QUEUED: {
                    MetricsServiceImpl.this.totalAcceptedQueries.inc();
                    break;
                }
                case CANCELED: {
                    MetricsServiceImpl.this.totalCancelledQueries.inc();
                    MetricsServiceImpl.this.totalFinishedQueries.inc();
                    break;
                }
                case FAILED: {
                    MetricsServiceImpl.this.totalFailedQueries.inc();
                    MetricsServiceImpl.this.totalFinishedQueries.inc();
                    break;
                }
                case SUCCESSFUL: {
                    MetricsServiceImpl.this.totalSuccessfulQueries.inc();
                    MetricsServiceImpl.this.totalFinishedQueries.inc();
                    break;
                }
            }
        }
    }
}

