/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server;

import java.io.IOException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import org.apache.lens.server.LensServices;

public class ServerModeFilter
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext requestContext) throws IOException {
        switch (LensServices.get().getServiceMode()) {
            case READ_ONLY: {
                if (requestContext.getUriInfo().getPath().startsWith("/session") || requestContext.getMethod().equals("GET")) break;
                throw new NotAllowedException("Server is in readonly mode", "GET", (String[])null);
            }
            case METASTORE_READONLY: {
                if (!requestContext.getUriInfo().getPath().startsWith("/metastore") || requestContext.getMethod().equals("GET")) break;
                throw new NotAllowedException("Metastore is in readonly mode", "GET", (String[])null);
            }
            case METASTORE_NODROP: {
                if (!requestContext.getUriInfo().getPath().startsWith("/metastore") || !requestContext.getMethod().equals("DELETE")) break;
                throw new NotAllowedException("Metastore is in nodrop mode", "GET", new String[]{"PUT", "POST"});
            }
        }
    }
}

