/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.metastore;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.ws.rs.WebApplicationException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.lens.api.metastore.ObjectFactory;
import org.apache.lens.api.metastore.XBaseCube;
import org.apache.lens.api.metastore.XChainColumn;
import org.apache.lens.api.metastore.XColumn;
import org.apache.lens.api.metastore.XColumns;
import org.apache.lens.api.metastore.XCube;
import org.apache.lens.api.metastore.XDerivedCube;
import org.apache.lens.api.metastore.XDimAttrNames;
import org.apache.lens.api.metastore.XDimAttribute;
import org.apache.lens.api.metastore.XDimAttributes;
import org.apache.lens.api.metastore.XDimension;
import org.apache.lens.api.metastore.XDimensionTable;
import org.apache.lens.api.metastore.XExprColumn;
import org.apache.lens.api.metastore.XExpressions;
import org.apache.lens.api.metastore.XFactTable;
import org.apache.lens.api.metastore.XJoinChain;
import org.apache.lens.api.metastore.XJoinChains;
import org.apache.lens.api.metastore.XJoinEdge;
import org.apache.lens.api.metastore.XJoinEdges;
import org.apache.lens.api.metastore.XJoinPath;
import org.apache.lens.api.metastore.XJoinPaths;
import org.apache.lens.api.metastore.XMeasure;
import org.apache.lens.api.metastore.XMeasureNames;
import org.apache.lens.api.metastore.XMeasureType;
import org.apache.lens.api.metastore.XMeasures;
import org.apache.lens.api.metastore.XNativeTable;
import org.apache.lens.api.metastore.XPartSpec;
import org.apache.lens.api.metastore.XPartSpecElement;
import org.apache.lens.api.metastore.XPartition;
import org.apache.lens.api.metastore.XProperties;
import org.apache.lens.api.metastore.XProperty;
import org.apache.lens.api.metastore.XSkewColList;
import org.apache.lens.api.metastore.XSkewedInfo;
import org.apache.lens.api.metastore.XSkewedValueLocation;
import org.apache.lens.api.metastore.XStorage;
import org.apache.lens.api.metastore.XStorageTableDesc;
import org.apache.lens.api.metastore.XStorageTableElement;
import org.apache.lens.api.metastore.XStorageTables;
import org.apache.lens.api.metastore.XTableReference;
import org.apache.lens.api.metastore.XTableReferences;
import org.apache.lens.api.metastore.XTimePartSpec;
import org.apache.lens.api.metastore.XTimePartSpecElement;
import org.apache.lens.api.metastore.XUpdatePeriod;
import org.apache.lens.api.metastore.XUpdatePeriods;
import org.apache.lens.cube.metadata.AbstractBaseTable;
import org.apache.lens.cube.metadata.AbstractCubeTable;
import org.apache.lens.cube.metadata.BaseDimAttribute;
import org.apache.lens.cube.metadata.ColumnMeasure;
import org.apache.lens.cube.metadata.Cube;
import org.apache.lens.cube.metadata.CubeDimAttribute;
import org.apache.lens.cube.metadata.CubeDimensionTable;
import org.apache.lens.cube.metadata.CubeFactTable;
import org.apache.lens.cube.metadata.CubeInterface;
import org.apache.lens.cube.metadata.CubeMeasure;
import org.apache.lens.cube.metadata.DerivedCube;
import org.apache.lens.cube.metadata.Dimension;
import org.apache.lens.cube.metadata.ExprColumn;
import org.apache.lens.cube.metadata.JoinChain;
import org.apache.lens.cube.metadata.ReferencedDimAtrribute;
import org.apache.lens.cube.metadata.Storage;
import org.apache.lens.cube.metadata.StoragePartitionDesc;
import org.apache.lens.cube.metadata.StorageTableDesc;
import org.apache.lens.cube.metadata.TableReference;
import org.apache.lens.cube.metadata.UpdatePeriod;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class JAXBUtils {
    public static final Logger LOG = LogManager.getLogger(JAXBUtils.class);
    private static final ObjectFactory XCF = new ObjectFactory();

    public static CubeInterface hiveCubeFromXCube(XCube cube, Cube parent) throws ParseException {
        if (cube instanceof XDerivedCube) {
            XDerivedCube dcube = (XDerivedCube)cube;
            LinkedHashSet dims = new LinkedHashSet();
            dims.addAll(dcube.getDimAttrNames().getAttrName());
            LinkedHashSet measures = new LinkedHashSet();
            measures.addAll(dcube.getMeasureNames().getMeasureName());
            Map<String, String> properties = JAXBUtils.mapFromXProperties(cube.getProperties());
            return new DerivedCube(cube.getName(), measures, dims, properties, 0.0, parent);
        }
        XBaseCube bcube = (XBaseCube)cube;
        LinkedHashSet<CubeDimAttribute> dims = new LinkedHashSet<CubeDimAttribute>();
        if (bcube.getDimAttributes() != null && !bcube.getDimAttributes().getDimAttribute().isEmpty()) {
            for (XDimAttribute xd : bcube.getDimAttributes().getDimAttribute()) {
                dims.add(JAXBUtils.hiveDimAttrFromXDimAttr(xd));
            }
        }
        LinkedHashSet<CubeMeasure> measures = new LinkedHashSet<CubeMeasure>();
        for (XMeasure xm : bcube.getMeasures().getMeasure()) {
            measures.add(JAXBUtils.hiveMeasureFromXMeasure(xm));
        }
        LinkedHashSet<ExprColumn> expressions = new LinkedHashSet<ExprColumn>();
        if (bcube.getExpressions() != null && !bcube.getExpressions().getExpression().isEmpty()) {
            for (XExprColumn xe : bcube.getExpressions().getExpression()) {
                expressions.add(JAXBUtils.hiveExprColumnFromXExprColumn(xe));
            }
        }
        LinkedHashSet<JoinChain> joinchains = new LinkedHashSet<JoinChain>();
        if (bcube.getJoinChains() != null && !bcube.getJoinChains().getJoinChain().isEmpty()) {
            for (XJoinChain xj : bcube.getJoinChains().getJoinChain()) {
                joinchains.add(JAXBUtils.joinChainFromXJoinChain(xj));
            }
        }
        Map<String, String> properties = JAXBUtils.mapFromXProperties(cube.getProperties());
        return new Cube(cube.getName(), measures, dims, expressions, joinchains, properties, 0.0);
    }

    public static XCube xCubeFromHiveCube(CubeInterface c) {
        XDerivedCube xc;
        if (c.isDerivedCube()) {
            XDerivedCube xdc = XCF.createXDerivedCube();
            xdc.setMeasureNames(new XMeasureNames());
            xdc.setDimAttrNames(new XDimAttrNames());
            xc = xdc;
            xdc.getMeasureNames().getMeasureName().addAll(c.getMeasureNames());
            xdc.getDimAttrNames().getAttrName().addAll(c.getDimAttributeNames());
            xdc.setParent(((DerivedCube)c).getParent().getName());
        } else {
            XBaseCube xbc = XCF.createXBaseCube();
            xbc.setMeasures(new XMeasures());
            xbc.setDimAttributes(new XDimAttributes());
            xbc.setExpressions(new XExpressions());
            xbc.setJoinChains(new XJoinChains());
            xc = xbc;
            for (CubeMeasure cm : c.getMeasures()) {
                xbc.getMeasures().getMeasure().add(JAXBUtils.xMeasureFromHiveMeasure(cm));
            }
            for (ExprColumn ec : c.getExpressions()) {
                xbc.getExpressions().getExpression().add(JAXBUtils.xExprColumnFromHiveExprColumn(ec));
            }
            for (CubeDimAttribute cd : c.getDimAttributes()) {
                xbc.getDimAttributes().getDimAttribute().add(JAXBUtils.xDimAttrFromHiveDimAttr(cd, (AbstractBaseTable)((Cube)c)));
            }
            for (JoinChain jc : c.getJoinChains()) {
                xbc.getJoinChains().getJoinChain().add(JAXBUtils.XJoinChainFromJoinChain(jc));
            }
        }
        xc.setName(c.getName());
        xc.setProperties(new XProperties());
        xc.getProperties().getProperty().addAll(JAXBUtils.xPropertiesFromMap(((AbstractCubeTable)c).getProperties()));
        return xc;
    }

    public static CubeDimAttribute hiveDimAttrFromXDimAttr(XDimAttribute xd) {
        Object hiveDim;
        Date startDate = JAXBUtils.getDateFromXML(xd.getStartTime());
        Date endDate = JAXBUtils.getDateFromXML(xd.getEndTime());
        if (xd.getRefSpec() != null && xd.getRefSpec().getTableReferences() != null && !xd.getRefSpec().getTableReferences().getTableReference().isEmpty()) {
            ArrayList<TableReference> dimRefs = new ArrayList<TableReference>(xd.getRefSpec().getTableReferences().getTableReference().size());
            for (XTableReference xRef : xd.getRefSpec().getTableReferences().getTableReference()) {
                dimRefs.add(new TableReference(xRef.getTable(), xRef.getColumn()));
            }
            hiveDim = new ReferencedDimAtrribute(new FieldSchema(xd.getName(), xd.getType().toLowerCase(), xd.getDescription()), xd.getDisplayString(), dimRefs, startDate, endDate, null);
        } else {
            hiveDim = xd.getRefSpec() != null && xd.getRefSpec().getChainRefColumn() != null ? new ReferencedDimAtrribute(new FieldSchema(xd.getName(), xd.getType().toLowerCase(), xd.getDescription()), xd.getDisplayString(), xd.getRefSpec().getChainRefColumn().getChainName(), xd.getRefSpec().getChainRefColumn().getRefCol(), startDate, endDate, null) : new BaseDimAttribute(new FieldSchema(xd.getName(), xd.getType().toLowerCase(), xd.getDescription()), xd.getDisplayString(), startDate, endDate, null);
        }
        return hiveDim;
    }

    public static XMLGregorianCalendar getXMLGregorianCalendar(Date d) {
        if (d == null) {
            return null;
        }
        GregorianCalendar c1 = new GregorianCalendar();
        c1.setTime(d);
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(c1);
        }
        catch (DatatypeConfigurationException e) {
            LOG.warn((Object)("Error converting date " + d), (Throwable)e);
            return null;
        }
    }

    public static Date getDateFromXML(XMLGregorianCalendar cal) {
        if (cal == null) {
            return null;
        }
        return cal.toGregorianCalendar().getTime();
    }

    public static XMeasure xMeasureFromHiveMeasure(CubeMeasure cm) {
        if (cm == null) {
            return null;
        }
        XMeasure xm = XCF.createXMeasure();
        xm.setName(cm.getName());
        xm.setDescription(cm.getDescription());
        xm.setDisplayString(cm.getDisplayString());
        xm.setDefaultAggr(cm.getAggregate());
        xm.setFormatString(cm.getFormatString());
        xm.setType(XMeasureType.valueOf((String)cm.getType().toUpperCase()));
        xm.setUnit(cm.getUnit());
        xm.setStartTime(JAXBUtils.getXMLGregorianCalendar(cm.getStartTime()));
        xm.setEndTime(JAXBUtils.getXMLGregorianCalendar(cm.getEndTime()));
        xm.setMin(cm.getMin());
        xm.setMax(cm.getMax());
        return xm;
    }

    public static XExprColumn xExprColumnFromHiveExprColumn(ExprColumn ec) {
        if (ec == null) {
            return null;
        }
        XExprColumn xe = XCF.createXExprColumn();
        xe.setName(ec.getName());
        xe.setType(ec.getType());
        xe.setDescription(ec.getDescription());
        xe.setDisplayString(ec.getDisplayString());
        xe.setExpr(ec.getExpr());
        return xe;
    }

    public static XDimAttribute xDimAttrFromHiveDimAttr(CubeDimAttribute cd, AbstractBaseTable baseTable) {
        XDimAttribute xd = XCF.createXDimAttribute();
        xd.setName(cd.getName());
        xd.setDescription(cd.getDescription());
        xd.setDisplayString(cd.getDisplayString());
        if (cd instanceof ReferencedDimAtrribute) {
            ReferencedDimAtrribute rd = (ReferencedDimAtrribute)cd;
            List dimRefs = rd.getReferences();
            XDimAttribute.RefSpec refspec = XCF.createXDimAttributeRefSpec();
            if (rd.getChainName() != null) {
                XChainColumn xcc = new XChainColumn();
                xcc.setChainName(rd.getChainName());
                xcc.setRefCol(rd.getRefColumn());
                xcc.setDestTable(baseTable.getChainByName(rd.getChainName()).getDestTable());
                refspec.setChainRefColumn(xcc);
            } else {
                refspec.setTableReferences(new XTableReferences());
                refspec.getTableReferences().getTableReference().addAll(JAXBUtils.xTabReferencesFromHiveTabReferences(dimRefs));
            }
            xd.setRefSpec(refspec);
            xd.setType(rd.getType());
        } else if (cd instanceof BaseDimAttribute) {
            BaseDimAttribute bd = (BaseDimAttribute)cd;
            xd.setType(bd.getType());
        }
        return xd;
    }

    public static XJoinChain XJoinChainFromJoinChain(JoinChain jc) {
        XJoinChain xjc = XCF.createXJoinChain();
        xjc.setName(jc.getName());
        xjc.setDescription(jc.getDescription());
        xjc.setDisplayString(jc.getDisplayString());
        xjc.setDestTable(jc.getDestTable());
        xjc.setPaths(new XJoinPaths());
        for (JoinChain.Path path : jc.getPaths()) {
            xjc.getPaths().getPath().add(JAXBUtils.xJoinPathFromJoinPath(path));
        }
        return xjc;
    }

    public static XJoinPath xJoinPathFromJoinPath(JoinChain.Path path) {
        XJoinPath xjp = XCF.createXJoinPath();
        xjp.setEdges(new XJoinEdges());
        for (JoinChain.Edge edge : path.getLinks()) {
            XJoinEdge xje = XCF.createXJoinEdge();
            xje.setFrom(JAXBUtils.xTabReferenceFromTabReference(edge.getFrom()));
            xje.setTo(JAXBUtils.xTabReferenceFromTabReference(edge.getTo()));
            xjp.getEdges().getEdge().add(xje);
        }
        return xjp;
    }

    public static List<XTableReference> xTabReferencesFromHiveTabReferences(List<TableReference> hiveRefs) {
        ArrayList<XTableReference> xrefList = new ArrayList<XTableReference>();
        for (TableReference hRef : hiveRefs) {
            xrefList.add(JAXBUtils.xTabReferenceFromTabReference(hRef));
        }
        return xrefList;
    }

    private static XTableReference xTabReferenceFromTabReference(TableReference ref) {
        XTableReference xref = XCF.createXTableReference();
        xref.setTable(ref.getDestTable());
        xref.setColumn(ref.getDestColumn());
        return xref;
    }

    public static CubeMeasure hiveMeasureFromXMeasure(XMeasure xm) {
        Date startDate = xm.getStartTime() == null ? null : xm.getStartTime().toGregorianCalendar().getTime();
        Date endDate = xm.getEndTime() == null ? null : xm.getEndTime().toGregorianCalendar().getTime();
        ColumnMeasure cm = new ColumnMeasure(new FieldSchema(xm.getName(), xm.getType().name().toLowerCase(), xm.getDescription()), xm.getDisplayString(), xm.getFormatString(), xm.getDefaultAggr(), xm.getUnit(), startDate, endDate, null, xm.getMin(), xm.getMax());
        return cm;
    }

    public static JoinChain joinChainFromXJoinChain(XJoinChain xj) {
        JoinChain jc = new JoinChain(xj.getName(), xj.getDisplayString(), xj.getDescription());
        for (int i = 0; i < xj.getPaths().getPath().size(); ++i) {
            XJoinPath xchain = (XJoinPath)xj.getPaths().getPath().get(i);
            ArrayList<TableReference> chain = new ArrayList<TableReference>(xchain.getEdges().getEdge().size() * 2);
            for (XJoinEdge xRef : xchain.getEdges().getEdge()) {
                chain.add(new TableReference(xRef.getFrom().getTable(), xRef.getFrom().getColumn()));
                chain.add(new TableReference(xRef.getTo().getTable(), xRef.getTo().getColumn()));
            }
            jc.addPath(chain);
        }
        return jc;
    }

    public static ExprColumn hiveExprColumnFromXExprColumn(XExprColumn xe) throws ParseException {
        ExprColumn ec = new ExprColumn(new FieldSchema(xe.getName(), xe.getType().toLowerCase(), xe.getDescription()), xe.getDisplayString(), new String[]{xe.getExpr()});
        return ec;
    }

    public static Map<String, String> mapFromXProperties(XProperties xProperties) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (xProperties != null && !xProperties.getProperty().isEmpty()) {
            for (XProperty xp : xProperties.getProperty()) {
                properties.put(xp.getName(), xp.getValue());
            }
        }
        return properties;
    }

    public static List<XProperty> xPropertiesFromMap(Map<String, String> map) {
        ArrayList<XProperty> xpList = new ArrayList<XProperty>();
        if (map != null && !map.isEmpty()) {
            for (Map.Entry<String, String> e : map.entrySet()) {
                XProperty property = XCF.createXProperty();
                property.setName(e.getKey());
                property.setValue(e.getValue());
                xpList.add(property);
            }
        }
        return xpList;
    }

    public static FieldSchema fieldSchemaFromColumn(XColumn c) {
        if (c == null) {
            return null;
        }
        return new FieldSchema(c.getName(), c.getType().toLowerCase(), c.getComment());
    }

    public static XColumn columnFromFieldSchema(FieldSchema fs) {
        if (fs == null) {
            return null;
        }
        XColumn c = XCF.createXColumn();
        c.setName(fs.getName());
        c.setType(fs.getType());
        c.setComment(fs.getComment());
        return c;
    }

    public static ArrayList<FieldSchema> fieldSchemaListFromColumns(XColumns columns) {
        if (columns != null && !columns.getColumn().isEmpty()) {
            ArrayList<FieldSchema> fsList = new ArrayList<FieldSchema>(columns.getColumn().size());
            for (XColumn c : columns.getColumn()) {
                fsList.add(JAXBUtils.fieldSchemaFromColumn(c));
            }
            return fsList;
        }
        return null;
    }

    public static List<XColumn> columnsFromFieldSchemaList(List<FieldSchema> fslist) {
        if (fslist == null || fslist.isEmpty()) {
            return null;
        }
        ArrayList<XColumn> cols = new ArrayList<XColumn>();
        for (FieldSchema fs : fslist) {
            cols.add(JAXBUtils.columnFromFieldSchema(fs));
        }
        return cols;
    }

    public static Map<String, Set<UpdatePeriod>> getFactUpdatePeriodsFromStorageTables(XStorageTables storageTables) {
        if (storageTables != null && !storageTables.getStorageTable().isEmpty()) {
            LinkedHashMap<String, Set<UpdatePeriod>> factUpdatePeriods = new LinkedHashMap<String, Set<UpdatePeriod>>();
            for (XStorageTableElement ste : storageTables.getStorageTable()) {
                TreeSet<UpdatePeriod> updatePeriods = new TreeSet<UpdatePeriod>();
                for (XUpdatePeriod upd : ste.getUpdatePeriods().getUpdatePeriod()) {
                    updatePeriods.add(UpdatePeriod.valueOf((String)upd.name()));
                }
                factUpdatePeriods.put(ste.getStorageName(), updatePeriods);
            }
            return factUpdatePeriods;
        }
        return null;
    }

    public static Map<String, UpdatePeriod> dumpPeriodsFromStorageTables(XStorageTables storageTables) {
        if (storageTables != null && !storageTables.getStorageTable().isEmpty()) {
            LinkedHashMap<String, UpdatePeriod> dumpPeriods = new LinkedHashMap<String, UpdatePeriod>();
            for (XStorageTableElement ste : storageTables.getStorageTable()) {
                UpdatePeriod dumpPeriod = null;
                if (ste.getUpdatePeriods() != null && !ste.getUpdatePeriods().getUpdatePeriod().isEmpty()) {
                    dumpPeriod = UpdatePeriod.valueOf((String)((XUpdatePeriod)ste.getUpdatePeriods().getUpdatePeriod().get(0)).name());
                }
                dumpPeriods.put(ste.getStorageName(), dumpPeriod);
            }
            return dumpPeriods;
        }
        return null;
    }

    public static Storage storageFromXStorage(XStorage xs) {
        if (xs == null) {
            return null;
        }
        Storage storage = null;
        try {
            Class<?> clazz = Class.forName(xs.getClassname());
            Constructor<?> constructor = clazz.getConstructor(String.class);
            storage = (Storage)constructor.newInstance(xs.getName());
            storage.addProperties(JAXBUtils.mapFromXProperties(xs.getProperties()));
            return storage;
        }
        catch (Exception e) {
            LOG.error((Object)("Could not create storage class" + xs.getClassname() + "with name:" + xs.getName()));
            throw new WebApplicationException((Throwable)e);
        }
    }

    public static XStorage xstorageFromStorage(Storage storage) {
        if (storage == null) {
            return null;
        }
        XStorage xstorage = null;
        xstorage = XCF.createXStorage();
        xstorage.setProperties(new XProperties());
        xstorage.setName(storage.getName());
        xstorage.setClassname(storage.getClass().getCanonicalName());
        xstorage.getProperties().getProperty().addAll(JAXBUtils.xPropertiesFromMap(storage.getProperties()));
        return xstorage;
    }

    public static XDimensionTable dimTableFromCubeDimTable(CubeDimensionTable cubeDimTable) {
        if (cubeDimTable == null) {
            return null;
        }
        XDimensionTable dimTab = XCF.createXDimensionTable();
        dimTab.setDimensionName(cubeDimTable.getDimName());
        dimTab.setTableName(cubeDimTable.getName());
        dimTab.setWeight(Double.valueOf(cubeDimTable.weight()));
        dimTab.setColumns(new XColumns());
        dimTab.setProperties(new XProperties());
        dimTab.setStorageTables(new XStorageTables());
        for (FieldSchema column : cubeDimTable.getColumns()) {
            dimTab.getColumns().getColumn().add(JAXBUtils.columnFromFieldSchema(column));
        }
        dimTab.getProperties().getProperty().addAll(JAXBUtils.xPropertiesFromMap(cubeDimTable.getProperties()));
        return dimTab;
    }

    public static List<? extends XTableReference> dimRefListFromTabRefList(List<TableReference> tabRefs) {
        if (tabRefs != null && !tabRefs.isEmpty()) {
            ArrayList<XTableReference> xTabRefs = new ArrayList<XTableReference>(tabRefs.size());
            for (TableReference ref : tabRefs) {
                XTableReference xRef = XCF.createXTableReference();
                xRef.setColumn(ref.getDestColumn());
                xRef.setTable(ref.getDestTable());
                xTabRefs.add(xRef);
            }
            return xTabRefs;
        }
        return null;
    }

    public static CubeDimensionTable cubeDimTableFromDimTable(XDimensionTable dimensionTable) {
        CubeDimensionTable cdim = new CubeDimensionTable(dimensionTable.getDimensionName(), dimensionTable.getTableName(), JAXBUtils.fieldSchemaListFromColumns(dimensionTable.getColumns()), dimensionTable.getWeight().doubleValue(), JAXBUtils.dumpPeriodsFromStorageTables(dimensionTable.getStorageTables()), JAXBUtils.mapFromXProperties(dimensionTable.getProperties()));
        return cdim;
    }

    public static CubeFactTable cubeFactFromFactTable(XFactTable fact) {
        ArrayList<FieldSchema> columns = JAXBUtils.fieldSchemaListFromColumns(fact.getColumns());
        Map<String, Set<UpdatePeriod>> storageUpdatePeriods = JAXBUtils.getFactUpdatePeriodsFromStorageTables(fact.getStorageTables());
        return new CubeFactTable(fact.getCubeName(), fact.getName(), columns, storageUpdatePeriods, fact.getWeight().doubleValue(), JAXBUtils.mapFromXProperties(fact.getProperties()));
    }

    public static XFactTable factTableFromCubeFactTable(CubeFactTable cFact) {
        XFactTable fact = XCF.createXFactTable();
        fact.setName(cFact.getName());
        fact.setColumns(new XColumns());
        fact.setProperties(new XProperties());
        fact.setStorageTables(new XStorageTables());
        fact.getProperties().getProperty().addAll(JAXBUtils.xPropertiesFromMap(cFact.getProperties()));
        fact.getColumns().getColumn().addAll(JAXBUtils.columnsFromFieldSchemaList(cFact.getColumns()));
        fact.setWeight(Double.valueOf(cFact.weight()));
        fact.setCubeName(cFact.getCubeName());
        return fact;
    }

    public static StorageTableDesc storageTableDescFromXStorageTableDesc(XStorageTableDesc xtableDesc) {
        StorageTableDesc tblDesc = new StorageTableDesc();
        tblDesc.setTblProps(JAXBUtils.mapFromXProperties(xtableDesc.getTableParameters()));
        tblDesc.setSerdeProps(JAXBUtils.mapFromXProperties(xtableDesc.getSerdeParameters()));
        tblDesc.setPartCols(JAXBUtils.fieldSchemaListFromColumns(xtableDesc.getPartCols()));
        tblDesc.setTimePartCols(xtableDesc.getTimePartCols());
        tblDesc.setExternal(xtableDesc.isExternal());
        tblDesc.setLocation(xtableDesc.getTableLocation());
        tblDesc.setInputFormat(xtableDesc.getInputFormat());
        tblDesc.setOutputFormat(xtableDesc.getOutputFormat());
        tblDesc.setFieldDelim(xtableDesc.getFieldDelimiter());
        tblDesc.setFieldEscape(xtableDesc.getEscapeChar());
        tblDesc.setCollItemDelim(xtableDesc.getCollectionDelimiter());
        tblDesc.setLineDelim(xtableDesc.getLineDelimiter());
        tblDesc.setMapKeyDelim(xtableDesc.getMapKeyDelimiter());
        tblDesc.setSerName(xtableDesc.getSerdeClassName());
        tblDesc.setStorageHandler(xtableDesc.getStorageHandlerName());
        return tblDesc;
    }

    public static StorageTableDesc storageTableDescFromXStorageTableElement(XStorageTableElement storageTableElement) {
        return JAXBUtils.storageTableDescFromXStorageTableDesc(storageTableElement.getTableDesc());
    }

    public static XStorageTableElement getXStorageTableFromHiveTable(Table tbl) {
        XStorageTableElement tblElement = new XStorageTableElement();
        tblElement.setUpdatePeriods(new XUpdatePeriods());
        tblElement.setTableDesc(JAXBUtils.getStorageTableDescFromHiveTable(tbl));
        return tblElement;
    }

    public static XStorageTableDesc getStorageTableDescFromHiveTable(Table tbl) {
        XStorageTableDesc tblDesc = new XStorageTableDesc();
        tblDesc.setPartCols(new XColumns());
        tblDesc.setTableParameters(new XProperties());
        tblDesc.setSerdeParameters(new XProperties());
        tblDesc.getPartCols().getColumn().addAll(JAXBUtils.columnsFromFieldSchemaList(tbl.getPartCols()));
        String timePartCols = (String)tbl.getParameters().get("cube.storagetable.time.partcols");
        if (timePartCols != null) {
            tblDesc.getTimePartCols().addAll(Arrays.asList(StringUtils.split((String)timePartCols, (String)",")));
        }
        tblDesc.setNumBuckets(Integer.valueOf(tbl.getNumBuckets()));
        tblDesc.getBucketCols().addAll(tbl.getBucketCols());
        ArrayList<String> sortCols = new ArrayList<String>();
        ArrayList<Integer> sortOrders = new ArrayList<Integer>();
        for (Order order : tbl.getSortCols()) {
            sortCols.add(order.getCol());
            sortOrders.add(order.getOrder());
        }
        tblDesc.getSortCols().addAll(sortCols);
        tblDesc.getSortColOrder().addAll(sortOrders);
        XSkewedInfo xskewinfo = new XSkewedInfo();
        xskewinfo.getColNames().addAll(tbl.getSkewedColNames());
        for (List value : tbl.getSkewedColValues()) {
            XSkewColList colVallist = new XSkewColList();
            colVallist.getElements().addAll(value);
            xskewinfo.getColValues().add(colVallist);
            XSkewedValueLocation valueLocation = new XSkewedValueLocation();
            if (tbl.getSkewedColValueLocationMaps().get(value) == null) continue;
            valueLocation.setValue(colVallist);
            valueLocation.setLocation((String)tbl.getSkewedColValueLocationMaps().get(value));
            xskewinfo.getValueLocationMap().add(valueLocation);
        }
        tblDesc.getTableParameters().getProperty().addAll(JAXBUtils.xPropertiesFromMap(tbl.getParameters()));
        tblDesc.getSerdeParameters().getProperty().addAll(JAXBUtils.xPropertiesFromMap(tbl.getTTable().getSd().getSerdeInfo().getParameters()));
        tblDesc.setExternal(tbl.getTableType().equals((Object)TableType.EXTERNAL_TABLE));
        tblDesc.setCompressed(Boolean.valueOf(tbl.getTTable().getSd().isCompressed()));
        tblDesc.setTableLocation(tbl.getDataLocation().toString());
        tblDesc.setInputFormat(tbl.getInputFormatClass().getCanonicalName());
        tblDesc.setOutputFormat(tbl.getOutputFormatClass().getCanonicalName());
        tblDesc.setFieldDelimiter(tbl.getSerdeParam("field.delim"));
        tblDesc.setLineDelimiter(tbl.getSerdeParam("line.delim"));
        tblDesc.setCollectionDelimiter(tbl.getSerdeParam("colelction.delim"));
        tblDesc.setMapKeyDelimiter(tbl.getSerdeParam("mapkey.delim"));
        tblDesc.setEscapeChar(tbl.getSerdeParam("escape.delim"));
        tblDesc.setSerdeClassName(tbl.getSerializationLib());
        tblDesc.setStorageHandlerName(tbl.getStorageHandler() != null ? tbl.getStorageHandler().getClass().getCanonicalName() : "");
        return tblDesc;
    }

    public static Map<String, StorageTableDesc> storageTableMapFromXStorageTables(XStorageTables storageTables) {
        HashMap<String, StorageTableDesc> storageTableMap = new HashMap<String, StorageTableDesc>();
        if (storageTables != null && !storageTables.getStorageTable().isEmpty()) {
            for (XStorageTableElement sTbl : storageTables.getStorageTable()) {
                storageTableMap.put(sTbl.getStorageName(), JAXBUtils.storageTableDescFromXStorageTableElement(sTbl));
            }
        }
        return storageTableMap;
    }

    public static Map<String, Date> timePartSpecfromXTimePartSpec(XTimePartSpec xtimePartSpec) {
        HashMap<String, Date> timePartSpec = new HashMap<String, Date>();
        if (xtimePartSpec != null && !xtimePartSpec.getPartSpecElement().isEmpty()) {
            for (XTimePartSpecElement xtimePart : xtimePartSpec.getPartSpecElement()) {
                timePartSpec.put(xtimePart.getKey(), JAXBUtils.getDateFromXML(xtimePart.getValue()));
            }
        }
        return timePartSpec;
    }

    public static Map<String, String> nonTimePartSpecfromXNonTimePartSpec(XPartSpec xnonTimePartSpec) {
        HashMap<String, String> nonTimePartSpec = new HashMap<String, String>();
        if (xnonTimePartSpec != null && !xnonTimePartSpec.getPartSpecElement().isEmpty()) {
            for (XPartSpecElement xPart : xnonTimePartSpec.getPartSpecElement()) {
                nonTimePartSpec.put(xPart.getKey(), xPart.getValue());
            }
        }
        return nonTimePartSpec;
    }

    public static XPartition xpartitionFromPartition(Partition p) throws HiveException {
        XPartition xp = new XPartition();
        xp.setFullPartitionSpec(new XPartSpec());
        xp.setPartitionParameters(new XProperties());
        xp.setSerdeParameters(new XProperties());
        xp.setName(p.getCompleteName());
        xp.setLocation(p.getLocation());
        xp.setInputFormat(p.getInputFormatClass().getCanonicalName());
        xp.setOutputFormat(p.getOutputFormatClass().getCanonicalName());
        xp.getPartitionParameters().getProperty().addAll(JAXBUtils.xPropertiesFromMap(p.getParameters()));
        String upParam = (String)p.getParameters().get("cube.storagetable.partition.update.period");
        xp.setUpdatePeriod(XUpdatePeriod.valueOf((String)upParam));
        for (Map.Entry entry : p.getSpec().entrySet()) {
            XPartSpecElement e = new XPartSpecElement();
            e.setKey((String)entry.getKey());
            e.setValue((String)entry.getValue());
            xp.getFullPartitionSpec().getPartSpecElement().add(e);
        }
        xp.setSerdeClassname(p.getTPartition().getSd().getSerdeInfo().getSerializationLib());
        xp.getSerdeParameters().getProperty().addAll(JAXBUtils.xPropertiesFromMap(p.getTPartition().getSd().getSerdeInfo().getParameters()));
        return xp;
    }

    public static StoragePartitionDesc storagePartSpecFromXPartition(XPartition xpart) {
        StoragePartitionDesc partDesc = new StoragePartitionDesc(xpart.getFactOrDimensionTableName(), JAXBUtils.timePartSpecfromXTimePartSpec(xpart.getTimePartitionSpec()), JAXBUtils.nonTimePartSpecfromXNonTimePartSpec(xpart.getNonTimePartitionSpec()), UpdatePeriod.valueOf((String)xpart.getUpdatePeriod().name()));
        partDesc.setPartParams(JAXBUtils.mapFromXProperties(xpart.getPartitionParameters()));
        partDesc.setSerdeParams(JAXBUtils.mapFromXProperties(xpart.getSerdeParameters()));
        partDesc.setLocation(xpart.getLocation());
        partDesc.setInputFormat(xpart.getInputFormat());
        partDesc.setOutputFormat(xpart.getOutputFormat());
        partDesc.setSerializationLib(xpart.getSerdeClassname());
        return partDesc;
    }

    public static Dimension dimensionFromXDimension(XDimension dimension) throws ParseException {
        LinkedHashSet<CubeDimAttribute> dims = new LinkedHashSet<CubeDimAttribute>();
        for (XDimAttribute xd : dimension.getAttributes().getDimAttribute()) {
            dims.add(JAXBUtils.hiveDimAttrFromXDimAttr(xd));
        }
        LinkedHashSet<ExprColumn> expressions = new LinkedHashSet<ExprColumn>();
        if (dimension.getExpressions() != null && !dimension.getExpressions().getExpression().isEmpty()) {
            for (XExprColumn xe : dimension.getExpressions().getExpression()) {
                expressions.add(JAXBUtils.hiveExprColumnFromXExprColumn(xe));
            }
        }
        LinkedHashSet<JoinChain> joinchains = new LinkedHashSet<JoinChain>();
        if (dimension.getJoinChains() != null && !dimension.getJoinChains().getJoinChain().isEmpty()) {
            for (XJoinChain xj : dimension.getJoinChains().getJoinChain()) {
                joinchains.add(JAXBUtils.joinChainFromXJoinChain(xj));
            }
        }
        Map<String, String> properties = JAXBUtils.mapFromXProperties(dimension.getProperties());
        return new Dimension(dimension.getName(), dims, expressions, joinchains, properties, 0.0);
    }

    public static XDimension xdimensionFromDimension(Dimension dimension) {
        XDimension xd = XCF.createXDimension();
        xd.setName(dimension.getName());
        xd.setAttributes(new XDimAttributes());
        xd.setExpressions(new XExpressions());
        xd.setJoinChains(new XJoinChains());
        xd.setProperties(new XProperties());
        xd.getProperties().getProperty().addAll(JAXBUtils.xPropertiesFromMap(dimension.getProperties()));
        for (CubeDimAttribute cd : dimension.getAttributes()) {
            xd.getAttributes().getDimAttribute().add(JAXBUtils.xDimAttrFromHiveDimAttr(cd, (AbstractBaseTable)dimension));
        }
        for (ExprColumn ec : dimension.getExpressions()) {
            xd.getExpressions().getExpression().add(JAXBUtils.xExprColumnFromHiveExprColumn(ec));
        }
        for (JoinChain jc : dimension.getJoinChains()) {
            xd.getJoinChains().getJoinChain().add(JAXBUtils.XJoinChainFromJoinChain(jc));
        }
        return xd;
    }

    public static XNativeTable nativeTableFromMetaTable(Table table) {
        XNativeTable xtable = XCF.createXNativeTable();
        xtable.setColumns(new XColumns());
        xtable.setName(table.getTableName());
        xtable.setDbname(table.getDbName());
        xtable.setOwner(table.getOwner());
        xtable.setCreatetime(table.getTTable().getCreateTime());
        xtable.setLastAccessTime(table.getTTable().getLastAccessTime());
        xtable.getColumns().getColumn().addAll(JAXBUtils.columnsFromFieldSchemaList(table.getCols()));
        xtable.setStorageDescriptor(JAXBUtils.getStorageTableDescFromHiveTable(table));
        xtable.setTableType(table.getTableType().name());
        return xtable;
    }
}

