/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.query;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.lens.api.LensException;
import org.apache.lens.api.query.QueryHandle;
import org.apache.lens.server.api.query.FinishedLensQuery;
import org.apache.lens.server.util.UtilityMethods;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LensServerDAO {
    private static final Logger LOG = LoggerFactory.getLogger(LensServerDAO.class);
    private DataSource ds;

    public void init(Configuration conf) {
        this.ds = UtilityMethods.getDataSourceFromConf(conf);
    }

    public Connection getConnection() throws SQLException {
        return this.ds.getConnection();
    }

    private void createTable(String sql) throws SQLException {
        QueryRunner runner = new QueryRunner(this.ds);
        runner.update(sql);
    }

    public void dropFinishedQueriesTable() {
        QueryRunner runner = new QueryRunner(this.ds);
        try {
            runner.update("drop table finished_queries");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createFinishedQueriesTable() throws Exception {
        String sql = "CREATE TABLE if not exists finished_queries (handle varchar(255) not null unique,userquery varchar(10000) not null,submitter varchar(255) not null,starttime bigint, endtime bigint,result varchar(255),status varchar(255), metadata varchar(100000), rows int, errormessage varchar(10000), driverstarttime bigint, driverendtime bigint, metadataclass varchar(10000),queryname varchar(255),submissiontime bigint)";
        try {
            this.createTable(sql);
            this.ds.getConnection().commit();
            LOG.info("Created finished queries table");
        }
        catch (SQLException e) {
            LOG.warn("Unable to create finished queries table", (Throwable)e);
        }
    }

    public void insertFinishedQuery(FinishedLensQuery query) throws Exception {
        String sql = "insert into finished_queries (handle, userquery,submitter,starttime,endtime,result,status,metadata,rows,errormessage,driverstarttime,driverendtime, metadataclass, queryname, submissiontime) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        QueryRunner runner = new QueryRunner(this.ds);
        try {
            runner.update(sql, new Object[]{query.getHandle(), query.getUserQuery(), query.getSubmitter(), query.getStartTime(), query.getEndTime(), query.getResult(), query.getStatus(), query.getMetadata(), query.getRows(), query.getErrorMessage(), query.getDriverStartTime(), query.getDriverEndTime(), query.getMetadataClass(), query.getQueryName(), query.getSubmissionTime()});
        }
        catch (SQLException e) {
            throw new Exception(e);
        }
    }

    public FinishedLensQuery getQuery(String handle) {
        BeanHandler rsh = new BeanHandler(FinishedLensQuery.class);
        String sql = "select * from finished_queries where handle=?";
        QueryRunner runner = new QueryRunner(this.ds);
        try {
            return (FinishedLensQuery)runner.query(sql, (ResultSetHandler)rsh, new Object[]{handle});
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<QueryHandle> findFinishedQueries(String state, String user, String queryName, long fromDate, long toDate) throws LensException {
        boolean addFilter = StringUtils.isNotBlank((CharSequence)state) || StringUtils.isNotBlank((CharSequence)user) || StringUtils.isNotBlank((CharSequence)queryName);
        StringBuilder builder = new StringBuilder("SELECT handle FROM finished_queries");
        ArrayList<Object> params = null;
        if (addFilter) {
            builder.append(" WHERE ");
            ArrayList<String> filters = new ArrayList<String>(3);
            params = new ArrayList<Object>(3);
            if (StringUtils.isNotBlank((CharSequence)state)) {
                filters.add("status=?");
                params.add(state);
            }
            if (StringUtils.isNotBlank((CharSequence)user)) {
                filters.add("submitter=?");
                params.add(user);
            }
            if (StringUtils.isNotBlank((CharSequence)queryName)) {
                filters.add("queryname like ?");
                params.add("%" + queryName + "%");
            }
            filters.add("submissiontime BETWEEN ? AND ?");
            params.add(fromDate);
            params.add(toDate);
            builder.append(StringUtils.join(filters, (String)" AND "));
        }
        ResultSetHandler<List<QueryHandle>> resultSetHandler = new ResultSetHandler<List<QueryHandle>>(){

            public List<QueryHandle> handle(ResultSet resultSet) throws SQLException {
                ArrayList<QueryHandle> queryHandleList = new ArrayList<QueryHandle>();
                while (resultSet.next()) {
                    String handle = resultSet.getString(1);
                    try {
                        queryHandleList.add(QueryHandle.fromString((String)handle));
                    }
                    catch (IllegalArgumentException exc) {
                        LOG.warn("Warning invalid query handle found in DB " + handle);
                    }
                }
                return queryHandleList;
            }
        };
        QueryRunner runner = new QueryRunner(this.ds);
        String query = builder.toString();
        try {
            if (addFilter) {
                return (List)runner.query(query, (ResultSetHandler)resultSetHandler, params.toArray());
            }
            return (List)runner.query(query, (ResultSetHandler)resultSetHandler);
        }
        catch (SQLException e) {
            throw new LensException((Throwable)e);
        }
    }
}

