/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.query;

import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.lens.api.APIResult;
import org.apache.lens.api.LensConf;
import org.apache.lens.api.LensException;
import org.apache.lens.api.LensSessionHandle;
import org.apache.lens.api.query.LensPreparedQuery;
import org.apache.lens.api.query.LensQuery;
import org.apache.lens.api.query.QueryHandle;
import org.apache.lens.api.query.QueryPrepareHandle;
import org.apache.lens.api.query.QueryResult;
import org.apache.lens.api.query.QueryResultSetMetadata;
import org.apache.lens.api.query.QuerySubmitResult;
import org.apache.lens.api.query.SubmitOp;
import org.apache.lens.server.LensServices;
import org.apache.lens.server.api.query.QueryExecutionService;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="/queryapi")
public class QueryServiceResource {
    public static final Logger LOG = LogManager.getLogger(QueryServiceResource.class);
    private QueryExecutionService queryServer = (QueryExecutionService)LensServices.get().getService("query");
    static String submitClue = ". supported values are:" + SubmitOp.EXPLAIN + ", " + SubmitOp.EXECUTE + " and " + SubmitOp.EXECUTE_WITH_TIMEOUT;
    static String prepareClue = ". supported values are:" + SubmitOp.PREPARE + " and " + SubmitOp.EXPLAIN_AND_PREPARE;
    static String submitPreparedClue = ". supported values are:" + SubmitOp.EXECUTE + " and " + SubmitOp.EXECUTE_WITH_TIMEOUT;

    private void checkSessionId(LensSessionHandle sessionHandle) {
        if (sessionHandle == null) {
            throw new BadRequestException("Invalid session handle");
        }
    }

    private void checkQuery(String query) {
        if (StringUtils.isBlank((String)query)) {
            throw new BadRequestException("Invalid query");
        }
    }

    @GET
    @Produces(value={"text/plain"})
    public String getMessage() {
        return "Queryapi is up";
    }

    QueryExecutionService getQueryServer() {
        return this.queryServer;
    }

    @GET
    @Path(value="queries")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public List<QueryHandle> getAllQueries(@QueryParam(value="sessionid") LensSessionHandle sessionid, @DefaultValue(value="") @QueryParam(value="state") String state, @DefaultValue(value="") @QueryParam(value="queryName") String queryName, @DefaultValue(value="") @QueryParam(value="user") String user, @DefaultValue(value="-1") @QueryParam(value="fromDate") long fromDate, @DefaultValue(value="-1") @QueryParam(value="toDate") long toDate) {
        this.checkSessionId(sessionid);
        try {
            if (toDate == -1L) {
                toDate = Long.MAX_VALUE;
            }
            return this.queryServer.getAllQueries(sessionid, state, user, queryName, fromDate, toDate);
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Path(value="queries")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public QuerySubmitResult query(@FormDataParam(value="sessionid") LensSessionHandle sessionid, @FormDataParam(value="query") String query, @FormDataParam(value="operation") String operation, @FormDataParam(value="conf") LensConf conf, @DefaultValue(value="30000") @FormDataParam(value="timeoutmillis") Long timeoutmillis, @DefaultValue(value="") @FormDataParam(value="queryName") String queryName) {
        this.checkQuery(query);
        this.checkSessionId(sessionid);
        try {
            SubmitOp sop = null;
            try {
                sop = SubmitOp.valueOf((String)operation.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException((Throwable)e);
            }
            if (sop == null) {
                throw new BadRequestException("Invalid operation type: " + operation + submitClue);
            }
            switch (sop) {
                case EXECUTE: {
                    return this.queryServer.executeAsync(sessionid, query, conf, queryName);
                }
                case EXPLAIN: {
                    return this.queryServer.explain(sessionid, query, conf);
                }
                case EXECUTE_WITH_TIMEOUT: {
                    return this.queryServer.execute(sessionid, query, timeoutmillis.longValue(), conf, queryName);
                }
            }
            throw new BadRequestException("Invalid operation type: " + operation + submitClue);
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="queries")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public APIResult cancelAllQueries(@QueryParam(value="sessionid") LensSessionHandle sessionid, @DefaultValue(value="") @QueryParam(value="state") String state, @DefaultValue(value="") @QueryParam(value="user") String user, @DefaultValue(value="") @QueryParam(value="queryName") String queryName, @DefaultValue(value="-1") @QueryParam(value="fromDate") long fromDate, @DefaultValue(value="-1") @QueryParam(value="toDate") long toDate) {
        this.checkSessionId(sessionid);
        int numCancelled = 0;
        List<QueryHandle> handles = null;
        boolean failed = false;
        try {
            handles = this.getAllQueries(sessionid, state, queryName, user, fromDate, toDate == -1L ? Long.MAX_VALUE : toDate);
            for (QueryHandle handle : handles) {
                if (!this.cancelQuery(sessionid, handle)) continue;
                ++numCancelled;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error canceling queries", (Throwable)e);
            failed = true;
        }
        String msgString = (StringUtils.isBlank((String)state) ? "" : " in state" + state) + (StringUtils.isBlank((String)user) ? "" : " for user " + user);
        if (handles != null && numCancelled == handles.size()) {
            return new APIResult(APIResult.Status.SUCCEEDED, "Cancel all queries " + msgString + " is successful");
        }
        assert (failed);
        if (numCancelled == 0) {
            return new APIResult(APIResult.Status.FAILED, "Cancel on the query " + msgString + " has failed");
        }
        return new APIResult(APIResult.Status.PARTIAL, "Cancel on the query " + msgString + " is partial");
    }

    @GET
    @Path(value="preparedqueries")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public List<QueryPrepareHandle> getAllPreparedQueries(@QueryParam(value="sessionid") LensSessionHandle sessionid, @DefaultValue(value="") @QueryParam(value="user") String user, @DefaultValue(value="") @QueryParam(value="queryName") String queryName, @DefaultValue(value="-1") @QueryParam(value="fromDate") long fromDate, @DefaultValue(value="-1") @QueryParam(value="toDate") long toDate) {
        this.checkSessionId(sessionid);
        try {
            if (toDate == -1L) {
                toDate = Long.MAX_VALUE;
            }
            return this.queryServer.getAllPreparedQueries(sessionid, user, queryName, fromDate, toDate);
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Path(value="preparedqueries")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public QuerySubmitResult prepareQuery(@FormDataParam(value="sessionid") LensSessionHandle sessionid, @FormDataParam(value="query") String query, @DefaultValue(value="") @FormDataParam(value="operation") String operation, @FormDataParam(value="conf") LensConf conf, @DefaultValue(value="") @FormDataParam(value="queryName") String queryName) {
        try {
            this.checkSessionId(sessionid);
            this.checkQuery(query);
            SubmitOp sop = null;
            try {
                sop = SubmitOp.valueOf((String)operation.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (sop == null) {
                throw new BadRequestException("Invalid operation type: " + operation + prepareClue);
            }
            switch (sop) {
                case PREPARE: {
                    return this.queryServer.prepare(sessionid, query, conf, queryName);
                }
                case EXPLAIN_AND_PREPARE: {
                    return this.queryServer.explainAndPrepare(sessionid, query, conf, queryName);
                }
            }
            throw new BadRequestException("Invalid operation type: " + operation + prepareClue);
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="preparedqueries")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public APIResult destroyPreparedQueries(@QueryParam(value="sessionid") LensSessionHandle sessionid, @DefaultValue(value="") @QueryParam(value="user") String user, @DefaultValue(value="") @QueryParam(value="queryName") String queryName, @DefaultValue(value="-1") @QueryParam(value="fromDate") long fromDate, @DefaultValue(value="-1") @QueryParam(value="toDate") long toDate) {
        String msgString;
        this.checkSessionId(sessionid);
        int numDestroyed = 0;
        boolean failed = false;
        List<QueryPrepareHandle> handles = null;
        try {
            handles = this.getAllPreparedQueries(sessionid, user, queryName, fromDate, toDate == -1L ? Long.MAX_VALUE : toDate);
            for (QueryPrepareHandle prepared : handles) {
                if (!this.destroyPrepared(sessionid, prepared)) continue;
                ++numDestroyed;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error destroying prepared queries", (Throwable)e);
            failed = true;
        }
        String string = msgString = StringUtils.isBlank((String)user) ? "" : " for user " + user;
        if (handles != null && numDestroyed == handles.size()) {
            return new APIResult(APIResult.Status.SUCCEEDED, "Destroy all prepared queries " + msgString + " is successful");
        }
        assert (failed);
        if (numDestroyed == 0) {
            return new APIResult(APIResult.Status.FAILED, "Destroy all prepared queries " + msgString + " has failed");
        }
        return new APIResult(APIResult.Status.PARTIAL, "Destroy all prepared queries " + msgString + " is partial");
    }

    private QueryHandle getQueryHandle(String queryHandle) {
        try {
            return QueryHandle.fromString((String)queryHandle);
        }
        catch (Exception e) {
            throw new BadRequestException("Invalid query handle: " + queryHandle, (Throwable)e);
        }
    }

    private QueryPrepareHandle getPrepareHandle(String prepareHandle) {
        try {
            return QueryPrepareHandle.fromString((String)prepareHandle);
        }
        catch (Exception e) {
            throw new BadRequestException("Invalid prepared query handle: " + prepareHandle, (Throwable)e);
        }
    }

    @GET
    @Path(value="preparedqueries/{prepareHandle}")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public LensPreparedQuery getPreparedQuery(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="prepareHandle") String prepareHandle) {
        this.checkSessionId(sessionid);
        try {
            return this.queryServer.getPreparedQuery(sessionid, this.getPrepareHandle(prepareHandle));
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="preparedqueries/{prepareHandle}")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public APIResult destroyPrepared(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="prepareHandle") String prepareHandle) {
        this.checkSessionId(sessionid);
        boolean ret = this.destroyPrepared(sessionid, this.getPrepareHandle(prepareHandle));
        if (ret) {
            return new APIResult(APIResult.Status.SUCCEEDED, "Destroy on the query " + prepareHandle + " is successful");
        }
        return new APIResult(APIResult.Status.FAILED, "Destroy on the query " + prepareHandle + " failed");
    }

    @GET
    @Path(value="queries/{queryHandle}")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public LensQuery getStatus(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="queryHandle") String queryHandle) {
        this.checkSessionId(sessionid);
        try {
            return this.queryServer.getQuery(sessionid, this.getQueryHandle(queryHandle));
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="queries/{queryHandle}")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public APIResult cancelQuery(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="queryHandle") String queryHandle) {
        this.checkSessionId(sessionid);
        boolean ret = this.cancelQuery(sessionid, this.getQueryHandle(queryHandle));
        if (ret) {
            return new APIResult(APIResult.Status.SUCCEEDED, "Cancel on the query " + queryHandle + " is successful");
        }
        return new APIResult(APIResult.Status.FAILED, "Cancel on the query " + queryHandle + " failed");
    }

    private boolean cancelQuery(LensSessionHandle sessionid, QueryHandle queryHandle) {
        try {
            return this.queryServer.cancelQuery(sessionid, queryHandle);
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    private boolean destroyPrepared(LensSessionHandle sessionid, QueryPrepareHandle queryHandle) {
        try {
            return this.queryServer.destroyPrepared(sessionid, queryHandle);
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @PUT
    @Path(value="queries/{queryHandle}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public APIResult updateConf(@FormDataParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="queryHandle") String queryHandle, @FormDataParam(value="conf") LensConf conf) {
        this.checkSessionId(sessionid);
        try {
            boolean ret = this.queryServer.updateQueryConf(sessionid, this.getQueryHandle(queryHandle), conf);
            if (ret) {
                return new APIResult(APIResult.Status.SUCCEEDED, "Update on the query conf for " + queryHandle + " is successful");
            }
            return new APIResult(APIResult.Status.FAILED, "Update on the query conf for " + queryHandle + " failed");
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @PUT
    @Path(value="preparedqueries/{prepareHandle}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public APIResult updatePreparedConf(@FormDataParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="prepareHandle") String prepareHandle, @FormDataParam(value="conf") LensConf conf) {
        this.checkSessionId(sessionid);
        try {
            boolean ret = this.queryServer.updateQueryConf(sessionid, this.getPrepareHandle(prepareHandle), conf);
            if (ret) {
                return new APIResult(APIResult.Status.SUCCEEDED, "Update on the query conf for " + prepareHandle + " is successful");
            }
            return new APIResult(APIResult.Status.FAILED, "Update on the query conf for " + prepareHandle + " failed");
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Path(value="preparedqueries/{prepareHandle}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public QuerySubmitResult executePrepared(@FormDataParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="prepareHandle") String prepareHandle, @DefaultValue(value="EXECUTE") @FormDataParam(value="operation") String operation, @FormDataParam(value="conf") LensConf conf, @DefaultValue(value="30000") @FormDataParam(value="timeoutmillis") Long timeoutmillis, @DefaultValue(value="") @FormDataParam(value="queryName") String queryName) {
        this.checkSessionId(sessionid);
        try {
            SubmitOp sop = null;
            try {
                sop = SubmitOp.valueOf((String)operation.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (sop == null) {
                throw new BadRequestException("Invalid operation type: " + operation + submitPreparedClue);
            }
            switch (sop) {
                case EXECUTE: {
                    return this.queryServer.executePrepareAsync(sessionid, this.getPrepareHandle(prepareHandle), conf, queryName);
                }
                case EXECUTE_WITH_TIMEOUT: {
                    return this.queryServer.executePrepare(sessionid, this.getPrepareHandle(prepareHandle), timeoutmillis.longValue(), conf, queryName);
                }
            }
            throw new BadRequestException("Invalid operation type: " + operation + submitPreparedClue);
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="queries/{queryHandle}/resultsetmetadata")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public QueryResultSetMetadata getResultSetMetadata(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="queryHandle") String queryHandle) {
        this.checkSessionId(sessionid);
        try {
            return this.queryServer.getResultSetMetadata(sessionid, this.getQueryHandle(queryHandle));
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="queries/{queryHandle}/resultset")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public QueryResult getResultSet(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="queryHandle") String queryHandle, @QueryParam(value="fromindex") long startIndex, @QueryParam(value="fetchsize") int fetchSize) {
        this.checkSessionId(sessionid);
        try {
            return this.queryServer.fetchResultSet(sessionid, this.getQueryHandle(queryHandle), startIndex, fetchSize);
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="queries/{queryHandle}/httpresultset")
    @Produces(value={"application/octet-stream"})
    public Response getHttpResultSet(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="queryHandle") String queryHandle) {
        try {
            return this.queryServer.getHttpResultSet(sessionid, this.getQueryHandle(queryHandle));
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="queries/{queryHandle}/resultset")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public APIResult closeResultSet(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="queryHandle") String queryHandle) {
        this.checkSessionId(sessionid);
        try {
            this.queryServer.closeResultSet(sessionid, this.getQueryHandle(queryHandle));
            return new APIResult(APIResult.Status.SUCCEEDED, "Close on the result set for query " + queryHandle + " is successful");
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }
}

