/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.session;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.lens.api.LensException;
import org.apache.lens.api.LensSessionHandle;
import org.apache.lens.server.LensService;
import org.apache.lens.server.LensServices;
import org.apache.lens.server.api.session.SessionService;
import org.apache.lens.server.query.QueryExecutionServiceImpl;
import org.apache.lens.server.session.LensSessionImpl;

public class HiveSessionService
extends LensService
implements SessionService {
    public static final Log LOG = LogFactory.getLog(HiveSessionService.class);
    private List<LensSessionImpl.LensSessionPersistInfo> restorableSessions;
    private ScheduledExecutorService sessionExpiryThread;
    private Runnable sessionExpiryRunnable = new SessionExpiryRunnable();

    public HiveSessionService(CLIService cliService) {
        super("session", cliService);
    }

    public int addResourceToAllServices(LensSessionHandle sessionid, String type, String path) {
        int numAdded = 0;
        boolean error = false;
        for (LensService service : LensServices.get().getLensServices()) {
            try {
                service.addResource(sessionid, type, path);
                ++numAdded;
            }
            catch (LensException e) {
                LOG.error((Object)("Failed to add resource type:" + type + " path:" + path + " in service:" + service), (Throwable)e);
                error = true;
                break;
            }
        }
        if (!error) {
            this.getSession(sessionid).addResource(type, path);
        }
        return numAdded;
    }

    public List<String> listAllResources(LensSessionHandle sessionHandle, String type) {
        if (!this.isValidResouceType(type)) {
            throw new BadRequestException("Bad resource type is passed. Please pass jar or file as source type");
        }
        List<LensSessionImpl.ResourceEntry> resources = this.getSession(sessionHandle).getResources();
        ArrayList<String> allResources = new ArrayList<String>();
        for (LensSessionImpl.ResourceEntry resource : resources) {
            if (type != null && !resource.getType().equalsIgnoreCase(type)) continue;
            allResources.add(resource.toString());
        }
        return allResources;
    }

    private boolean isValidResouceType(String type) {
        return type == null || type.equalsIgnoreCase("jar") || type.equalsIgnoreCase("file");
    }

    @Override
    public void addResource(LensSessionHandle sessionid, String type, String path) {
        String command = "add " + type.toLowerCase() + " " + path;
        try {
            this.acquire(sessionid);
            this.getCliService().executeStatement(HiveSessionService.getHiveSessionHandle(sessionid), command, null);
        }
        catch (HiveSQLException e) {
            throw new WebApplicationException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    @Override
    public void deleteResource(LensSessionHandle sessionid, String type, String path) {
        String command = "delete " + type.toLowerCase() + " " + path;
        try {
            this.acquire(sessionid);
            this.getCliService().executeStatement(HiveSessionService.getHiveSessionHandle(sessionid), command, null);
            this.getSession(sessionid).removeResource(type, path);
        }
        catch (HiveSQLException e) {
            throw new WebApplicationException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    private String getSessionParam(Configuration sessionConf, SessionState ss, String varname) {
        if (varname.indexOf("hivevar:") == 0) {
            String var = varname.substring("hivevar:".length());
            if (ss.getHiveVariables().get(var) != null) {
                return "hivevar:" + var + "=" + (String)ss.getHiveVariables().get(var);
            }
            throw new NotFoundException(varname + " is undefined as a hive variable");
        }
        String var = varname.indexOf("hiveconf:") == 0 ? varname.substring("hiveconf:".length()) : varname;
        if (sessionConf.get(var) != null) {
            return varname + "=" + sessionConf.get(var);
        }
        throw new NotFoundException(varname + " is undefined");
    }

    @Override
    public LensSessionHandle openSession(String username, String password, Map<String, String> configuration) throws LensException {
        LensSessionHandle sessionid = super.openSession(username, password, configuration);
        LOG.info((Object)("Opened session " + sessionid + " for user " + username));
        String[] auxJars = this.getSession(sessionid).getSessionConf().getStrings("lens.session.aux.jars");
        if (auxJars != null) {
            LOG.info((Object)("Adding aux jars:" + auxJars));
            for (String jar : auxJars) {
                this.addResourceToAllServices(sessionid, "jar", jar);
            }
        }
        return sessionid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllSessionParameters(LensSessionHandle sessionid, boolean verbose, String key) throws LensException {
        ArrayList<String> result = new ArrayList<String>();
        this.acquire(sessionid);
        try {
            SessionState ss = this.getSession(sessionid).getSessionState();
            if (!StringUtils.isBlank((CharSequence)key)) {
                result.add(this.getSessionParam(this.getSession(sessionid).getSessionConf(), ss, key));
            } else {
                TreeMap<String, String> sortedMap = new TreeMap<String, String>();
                sortedMap.put("silent", ss.getIsSilent() ? "on" : "off");
                for (String s : ss.getHiveVariables().keySet()) {
                    sortedMap.put("hivevar:" + s, (String)ss.getHiveVariables().get(s));
                }
                for (Map.Entry entry : this.getSession(sessionid).getSessionConf()) {
                    sortedMap.put((String)entry.getKey(), (String)entry.getValue());
                }
                for (Map.Entry entry : sortedMap.entrySet()) {
                    result.add(entry.toString());
                }
            }
        }
        finally {
            this.release(sessionid);
        }
        return result;
    }

    public void setSessionParameter(LensSessionHandle sessionid, String key, String value) {
        this.setSessionParameter(sessionid, key, value, true);
    }

    protected void setSessionParameter(LensSessionHandle sessionid, String key, String value, boolean addToSession) {
        LOG.info((Object)("Request to Set param key:" + key + " value:" + value));
        String command = "set " + key + "= " + value;
        try {
            this.acquire(sessionid);
            String var = key.indexOf("hiveconf:") == 0 ? key.substring("hiveconf:".length()) : key;
            this.getSession(sessionid).getSessionConf().set(var, value);
            this.getCliService().executeStatement(HiveSessionService.getHiveSessionHandle(sessionid), command, null);
            if (addToSession) {
                this.getSession(sessionid).setConfig(key, value);
            }
            LOG.info((Object)("Set param key:" + key + " value:" + value));
        }
        catch (HiveSQLException e) {
            throw new WebApplicationException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    public synchronized void start() {
        super.start();
        this.sessionExpiryThread = Executors.newSingleThreadScheduledExecutor();
        this.sessionExpiryThread.scheduleWithFixedDelay(this.sessionExpiryRunnable, 60L, 60L, TimeUnit.MINUTES);
        if (this.restorableSessions == null || this.restorableSessions.size() <= 0) {
            LOG.info((Object)"No sessions to restore");
            return;
        }
        for (LensSessionImpl.LensSessionPersistInfo persistInfo : this.restorableSessions) {
            try {
                LensSessionHandle sessionHandle = persistInfo.getSessionHandle();
                this.restoreSession(sessionHandle, persistInfo.getUsername(), persistInfo.getPassword());
                LensSessionImpl session = this.getSession(sessionHandle);
                session.setLastAccessTime(persistInfo.getLastAccessTime());
                session.getLensSessionPersistInfo().setConfig(persistInfo.getConfig());
                session.getLensSessionPersistInfo().setResources(persistInfo.getResources());
                session.setCurrentDatabase(persistInfo.getDatabase());
                for (LensSessionImpl.ResourceEntry resourceEntry : session.getResources()) {
                    try {
                        this.addResource(sessionHandle, resourceEntry.getType(), resourceEntry.getLocation());
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to restore resource for session: " + (Object)((Object)session) + " resource: " + resourceEntry));
                    }
                }
                for (Map.Entry entry : session.getConfig().entrySet()) {
                    try {
                        this.setSessionParameter(sessionHandle, (String)entry.getKey(), (String)entry.getValue(), false);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error setting parameter " + (String)entry.getKey() + "=" + (String)entry.getValue() + " for session: " + (Object)((Object)session)));
                    }
                }
                LOG.info((Object)("Restored session " + persistInfo.getSessionHandle().getPublicId()));
            }
            catch (LensException e) {
                throw new RuntimeException(e);
            }
        }
        LOG.info((Object)("Session service restoed " + this.restorableSessions.size() + " sessions"));
    }

    public synchronized void stop() {
        super.stop();
        if (this.sessionExpiryThread != null) {
            this.sessionExpiryThread.shutdownNow();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(sessionMap.size());
        for (LensSessionHandle sessionHandle : sessionMap.values()) {
            LensSessionImpl session = this.getSession(sessionHandle);
            session.getLensSessionPersistInfo().writeExternal(out);
        }
        LOG.info((Object)("Session service pesristed " + sessionMap.size() + " sessions"));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int numSessions = in.readInt();
        this.restorableSessions = new ArrayList<LensSessionImpl.LensSessionPersistInfo>();
        for (int i = 0; i < numSessions; ++i) {
            LensSessionImpl.LensSessionPersistInfo persistInfo = new LensSessionImpl.LensSessionPersistInfo();
            persistInfo.readExternal(in);
            this.restorableSessions.add(persistInfo);
            sessionMap.put(persistInfo.getSessionHandle().getPublicId().toString(), persistInfo.getSessionHandle());
        }
        LOG.info((Object)("Session service recovered " + sessionMap.size() + " sessions"));
    }

    @Override
    public void closeSession(LensSessionHandle sessionHandle) throws LensException {
        super.closeSession(sessionHandle);
        LensService svc = (LensService)LensServices.get().getService("query");
        if (svc instanceof QueryExecutionServiceImpl) {
            ((QueryExecutionServiceImpl)svc).closeDriverSessions(sessionHandle);
        }
    }

    Runnable getSessionExpiryRunnable() {
        return this.sessionExpiryRunnable;
    }

    public class SessionExpiryRunnable
    implements Runnable {
        public void runInternal() {
            ArrayList sessionsToRemove = new ArrayList(sessionMap.values());
            Iterator itr = sessionsToRemove.iterator();
            while (itr.hasNext()) {
                LensSessionHandle sessionHandle = (LensSessionHandle)itr.next();
                try {
                    LensSessionImpl session = HiveSessionService.this.getSession(sessionHandle);
                    if (!session.isActive()) continue;
                    itr.remove();
                }
                catch (NotFoundException nfe) {
                    itr.remove();
                }
            }
            for (LensSessionHandle sessionHandle : sessionsToRemove) {
                try {
                    long lastAccessTime = HiveSessionService.this.getSession(sessionHandle).getLastAccessTime();
                    HiveSessionService.this.closeSession(sessionHandle);
                    LOG.info((Object)("Closed inactive session " + sessionHandle.getPublicId() + " last accessed at " + new Date(lastAccessTime)));
                }
                catch (NotFoundException nfe) {
                }
                catch (LensException e) {
                    LOG.error((Object)("Error closing session " + sessionHandle.getPublicId() + " reason " + e.getMessage()));
                }
            }
        }

        @Override
        public void run() {
            try {
                this.runInternal();
            }
            catch (Exception e) {
                LOG.warn((Object)("Unknown error while checking for inactive sessions - " + e.getMessage()));
            }
        }
    }
}

