/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.session;

import java.util.HashMap;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lens.api.APIResult;
import org.apache.lens.api.LensConf;
import org.apache.lens.api.LensException;
import org.apache.lens.api.LensSessionHandle;
import org.apache.lens.api.StringList;
import org.apache.lens.server.LensService;
import org.apache.lens.server.LensServices;
import org.apache.lens.server.api.session.SessionService;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="/session")
public class SessionResource {
    public static final Log LOG = LogFactory.getLog(SessionResource.class);
    private SessionService sessionService = (SessionService)LensServices.get().getService("session");

    @GET
    @Produces(value={"text/plain"})
    public String getMessage() {
        return "session is up!";
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public LensSessionHandle openSession(@FormDataParam(value="username") String username, @FormDataParam(value="password") String password, @FormDataParam(value="sessionconf") LensConf sessionconf) {
        try {
            HashMap conf = sessionconf != null ? sessionconf.getProperties() : new HashMap();
            return this.sessionService.openSession(username, password, conf);
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @DELETE
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public APIResult closeSession(@QueryParam(value="sessionid") LensSessionHandle sessionid) {
        try {
            this.sessionService.closeSession(sessionid);
        }
        catch (LensException e) {
            return new APIResult(APIResult.Status.FAILED, e.getMessage());
        }
        return new APIResult(APIResult.Status.SUCCEEDED, "Close session with id" + sessionid + "succeeded");
    }

    @PUT
    @Path(value="resources/add")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public APIResult addResource(@FormDataParam(value="sessionid") LensSessionHandle sessionid, @FormDataParam(value="type") String type, @FormDataParam(value="path") String path) {
        int numAdded = this.sessionService.addResourceToAllServices(sessionid, type, path);
        if (numAdded == 0) {
            return new APIResult(APIResult.Status.FAILED, "Add resource has failed ");
        }
        if (numAdded != LensServices.get().getLensServices().size()) {
            return new APIResult(APIResult.Status.PARTIAL, "Add resource is partial");
        }
        return new APIResult(APIResult.Status.SUCCEEDED, "Add resource succeeded");
    }

    @GET
    @Path(value="resources/list")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public StringList listResources(@QueryParam(value="sessionid") LensSessionHandle sessionid, @QueryParam(value="type") String type) {
        List resources = this.sessionService.listAllResources(sessionid, type);
        return new StringList(resources);
    }

    @PUT
    @Path(value="resources/delete")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public APIResult deleteResource(@FormDataParam(value="sessionid") LensSessionHandle sessionid, @FormDataParam(value="type") String type, @FormDataParam(value="path") String path) {
        int numDeleted = 0;
        for (LensService service : LensServices.get().getLensServices()) {
            try {
                service.deleteResource(sessionid, type, path);
                ++numDeleted;
            }
            catch (LensException e) {
                LOG.error((Object)("Failed to delete resource in service:" + service), (Throwable)e);
                if (numDeleted != 0) {
                    return new APIResult(APIResult.Status.PARTIAL, "Delete resource is partial, failed for service:" + service.getName());
                }
                return new APIResult(APIResult.Status.PARTIAL, "Delete resource has failed");
            }
        }
        return new APIResult(APIResult.Status.SUCCEEDED, "Delete resource succeeded");
    }

    @GET
    @Path(value="params")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public StringList getParams(@QueryParam(value="sessionid") LensSessionHandle sessionid, @DefaultValue(value="false") @QueryParam(value="verbose") boolean verbose, @DefaultValue(value="") @QueryParam(value="key") String key) {
        try {
            List result = this.sessionService.getAllSessionParameters(sessionid, verbose, key);
            return new StringList(result);
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @PUT
    @Path(value="params")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public APIResult setParam(@FormDataParam(value="sessionid") LensSessionHandle sessionid, @FormDataParam(value="key") String key, @FormDataParam(value="value") String value) {
        this.sessionService.setSessionParameter(sessionid, key, value);
        return new APIResult(APIResult.Status.SUCCEEDED, "Set param succeeded");
    }
}

