/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.stats.event.query;

import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.lens.api.query.QueryStatus;
import org.apache.lens.lib.query.JSonSerde;
import org.apache.lens.server.stats.event.LoggableLensStatistics;
import org.apache.lens.server.stats.event.query.QueryDriverStatistics;

public class QueryExecutionStatistics
extends LoggableLensStatistics {
    private String handle;
    private String userQuery;
    private String submitter;
    private String clusterUser;
    private String sessionId;
    private long submissionTime;
    private long startTime;
    private long endTime;
    private String result;
    private QueryStatus status;
    private String cause;
    private QueryDriverStatistics driverStats;

    public QueryExecutionStatistics() {
    }

    public QueryExecutionStatistics(long eventTime) {
        super(eventTime);
    }

    @Override
    public Table getHiveTable(Configuration conf) {
        Table table = new Table(conf.get("lens.server.statistics.db", "lensstats"), ((Object)((Object)this)).getClass().getSimpleName());
        LinkedList<FieldSchema> colList = new LinkedList<FieldSchema>();
        colList.add(new FieldSchema("handle", "string", "Query Handle"));
        colList.add(new FieldSchema("userQuery", "string", "User Query before rewrite"));
        colList.add(new FieldSchema("submitter", "string", "submitter"));
        colList.add(new FieldSchema("clusterUser", "string", "Cluster User which will do all operations on hdfs"));
        colList.add(new FieldSchema("sessionId", "string", "Lens Session which ran the query"));
        colList.add(new FieldSchema("submissionTime", "bigint", "Time which query was submitted"));
        colList.add(new FieldSchema("startTime", "bigint", "Timestamp which query was Started"));
        colList.add(new FieldSchema("endTime", "bigint", "Timestamp which query was finished"));
        colList.add(new FieldSchema("result", "string", "path to result of query"));
        colList.add(new FieldSchema("cause", "string", "failure/eror cause if any"));
        colList.add(new FieldSchema("status", "map<string,string>", "status object of the query"));
        colList.add(new FieldSchema("driverStats", "map<string,string>", "driver statistics of the query"));
        table.setFields(colList);
        LinkedList<FieldSchema> partCols = new LinkedList<FieldSchema>();
        partCols.add(new FieldSchema("dt", "string", "partCol"));
        table.setPartCols(partCols);
        table.setSerializationLib(JSonSerde.class.getName());
        try {
            table.setInputFormatClass(TextInputFormat.class.getName());
        }
        catch (HiveException e) {
            e.printStackTrace();
        }
        return table;
    }

    public String getEventId() {
        return "queryExecutionStatistics";
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public String getUserQuery() {
        return this.userQuery;
    }

    public void setUserQuery(String userQuery) {
        this.userQuery = userQuery;
    }

    public String getSubmitter() {
        return this.submitter;
    }

    public void setSubmitter(String submitter) {
        this.submitter = submitter;
    }

    public String getClusterUser() {
        return this.clusterUser;
    }

    public void setClusterUser(String clusterUser) {
        this.clusterUser = clusterUser;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public long getSubmissionTime() {
        return this.submissionTime;
    }

    public void setSubmissionTime(long submissionTime) {
        this.submissionTime = submissionTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public QueryStatus getStatus() {
        return this.status;
    }

    public void setStatus(QueryStatus status) {
        this.status = status;
    }

    public String getCause() {
        return this.cause;
    }

    public void setCause(String cause) {
        this.cause = cause;
    }

    public QueryDriverStatistics getDriverStats() {
        return this.driverStats;
    }

    public void setDriverStats(QueryDriverStatistics driverStats) {
        this.driverStats = driverStats;
    }
}

