/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.stats.store.log;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.io.IOUtils;
import org.apache.lens.server.LensServices;
import org.apache.lens.server.api.events.AsyncEventListener;
import org.apache.lens.server.api.metrics.MetricsService;
import org.apache.lens.server.stats.event.LoggableLensStatistics;
import org.apache.lens.server.stats.store.log.PartitionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsLogPartitionHandler
extends AsyncEventListener<PartitionEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(StatisticsLogPartitionHandler.class);
    public static final String LOG_PARTITION_HANDLER_COUNTER = "log-partition-handler-errors";
    private Path warehousePath;
    private Hive client;
    private String database;

    public void initialize(Configuration conf) {
        String temp = conf.get("lens.server.statistics.warehouse.dir", "file:///tmp/lens/statistics/warehouse");
        this.warehousePath = new Path(temp);
        this.database = conf.get("lens.server.statistics.db", "lensstats");
        try {
            this.client = Hive.get();
        }
        catch (Exception e) {
            LOG.error("Unable to connect to hive metastore", (Throwable)e);
            throw new IllegalArgumentException("Unable to connect to hive metastore", e);
        }
    }

    public void process(PartitionEvent event) {
        String eventName = event.getEventName();
        Map<String, String> partitionMap = event.getPartMap();
        Path eventDir = new Path(this.warehousePath, eventName);
        for (Map.Entry<String, String> entry : partitionMap.entrySet()) {
            String partitionPath = entry.getKey().replace("-", "/");
            Path finalPath = new Path(eventDir, partitionPath + "/" + eventName + ".log");
            try {
                this.copyToHdfs(entry.getValue(), finalPath);
                boolean added = this.addPartition(eventName, entry.getKey(), finalPath, event.getClassName());
                if (!added) continue;
                new File(entry.getValue()).delete();
            }
            catch (Exception e) {
                MetricsService svc = (MetricsService)LensServices.get().getService("metrics");
                svc.incrCounter(StatisticsLogPartitionHandler.class, LOG_PARTITION_HANDLER_COUNTER);
                LOG.error("Unable to copy file to the file system", (Throwable)e);
            }
        }
    }

    private boolean addPartition(String eventName, String key, Path finalPath, String className) {
        try {
            Table t = this.getTable(eventName, className);
            HashMap<String, String> partSpec = new HashMap<String, String>();
            partSpec.put("dt", key);
            Partition p = this.client.createPartition(t, partSpec);
            p.setLocation(finalPath.toString());
            this.client.alterPartition(this.database, eventName, p);
            return true;
        }
        catch (Exception e) {
            LOG.warn("Unable to add the partition ", (Throwable)e);
            return false;
        }
    }

    private Table getTable(String eventName, String className) throws Exception {
        Table tmp = null;
        try {
            tmp = this.client.getTable(this.database, eventName, false);
            if (tmp == null) {
                tmp = this.createTable(eventName, className);
            }
        }
        catch (HiveException e) {
            LOG.warn("Exception thrown while creating the table", (Throwable)e);
        }
        return tmp;
    }

    private Table createTable(String eventName, String className) throws Exception {
        Table tmp;
        try {
            Database db = new Database();
            db.setName(this.database);
            this.client.createDatabase(db, true);
            Class<?> statisticsClass = Class.forName(className);
            LoggableLensStatistics stat = (LoggableLensStatistics)((Object)statisticsClass.newInstance());
            Configuration conf = new Configuration();
            conf.addResource("hive-site.xml");
            tmp = stat.getHiveTable(conf);
            tmp.setDbName(this.database);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating table  " + tmp.getTableName());
            }
            this.client.createTable(tmp);
            tmp = this.client.getTable(this.database, eventName);
        }
        catch (Exception e1) {
            LOG.warn("Unable to create hive table, exiting", (Throwable)e1);
            throw e1;
        }
        return tmp;
    }

    private void copyToHdfs(String localPath, Path finalPath) throws IOException {
        Configuration conf = new Configuration();
        FileSystem fs = finalPath.getFileSystem(conf);
        if (fs.exists(finalPath)) {
            fs.delete(finalPath, true);
        }
        IOUtils.copyBytes((InputStream)new FileInputStream(localPath), (OutputStream)fs.create(finalPath), (Configuration)conf, (boolean)true);
    }
}

