/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.stats.store.log;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.hadoop.conf.Configuration;
import org.apache.lens.server.api.events.LensEventService;
import org.apache.lens.server.stats.store.log.StatisticsLogFileScannerTask;
import org.eclipse.jetty.util.ConcurrentHashSet;

public class StatisticsLogRollupHandler {
    private StatisticsLogFileScannerTask task;
    private Timer timer;
    private long rate;
    private final ConcurrentHashSet<String> scanSet = new ConcurrentHashSet();

    public void initialize(Configuration conf) {
        this.task = new StatisticsLogFileScannerTask();
        this.timer = new Timer();
        this.rate = conf.getLong("lens.server.statistics.log.rollover.interval", 3600000L);
    }

    public void start(LensEventService service) {
        this.task.setService(service);
        this.timer.scheduleAtFixedRate((TimerTask)this.task, this.rate, this.rate);
    }

    public void stop() {
        this.timer.cancel();
    }

    public void addToScanTask(String event) {
        if (!this.scanSet.contains((Object)event)) {
            this.scanSet.add((Object)event);
            this.task.addLogFile(event);
        }
    }
}

