/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.ui;

import java.util.HashMap;
import java.util.UUID;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lens.api.APIResult;
import org.apache.lens.api.LensConf;
import org.apache.lens.api.LensException;
import org.apache.lens.api.LensSessionHandle;
import org.apache.lens.server.LensServices;
import org.apache.lens.server.api.session.SessionService;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="/uisession")
public class SessionUIResource {
    public static final Log LOG = LogFactory.getLog(SessionUIResource.class);
    public static HashMap<UUID, LensSessionHandle> openSessions = new HashMap();
    private SessionService sessionService = (SessionService)LensServices.get().getService("session");

    @GET
    @Produces(value={"text/plain"})
    public String getMessage() {
        return "session is up!";
    }

    private void checkSessionHandle(LensSessionHandle sessionHandle) {
        if (sessionHandle == null) {
            throw new BadRequestException("Invalid session handle");
        }
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public LensSessionHandle openSession(@FormDataParam(value="username") String username, @FormDataParam(value="password") String password, @FormDataParam(value="sessionconf") LensConf sessionconf) {
        try {
            HashMap conf = sessionconf != null ? sessionconf.getProperties() : new HashMap();
            LensSessionHandle handle = this.sessionService.openSession(username, password, conf);
            openSessions.put(handle.getPublicId(), handle);
            return handle;
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="{publicId}")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public APIResult closeSession(@PathParam(value="publicId") UUID publicId) {
        LOG.info((Object)("Closing session with id: " + publicId));
        LensSessionHandle sessionHandle = openSessions.get(publicId);
        this.checkSessionHandle(sessionHandle);
        openSessions.remove(publicId);
        try {
            this.sessionService.closeSession(sessionHandle);
        }
        catch (LensException e) {
            return new APIResult(APIResult.Status.FAILED, e.getMessage());
        }
        return new APIResult(APIResult.Status.SUCCEEDED, "Close session with id" + sessionHandle + "succeeded");
    }
}

