/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.user;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.lens.server.user.UserConfigLoader;
import org.apache.lens.server.user.UserConfigLoaderException;
import org.apache.lens.server.util.UtilityMethods;

public class DatabaseUserConfigLoader
extends UserConfigLoader {
    protected final String querySql;
    protected final String[] keys;
    protected final Cache<String, Map<String, String>> cache;
    protected BasicDataSource ds;

    public DatabaseUserConfigLoader(HiveConf conf) throws UserConfigLoaderException {
        super(conf);
        this.querySql = conf.get("lens.server.user.resolver.db.query");
        this.keys = conf.get("lens.server.user.resolver.db.keys").split("\\s*,\\s*", -1);
        this.cache = CacheBuilder.newBuilder().expireAfterWrite((long)conf.getInt("lens.server.user.resolver.cache.expiry", 2), TimeUnit.HOURS).maximumSize((long)conf.getInt("lens.server.user.resolver.cache.max_size", 100)).build();
    }

    @Override
    public Map<String, String> getUserConfig(final String loggedInUser) throws UserConfigLoaderException {
        try {
            return (Map)this.cache.get((Object)loggedInUser, (Callable)new Callable<Map<String, String>>(){

                @Override
                public Map<String, String> call() throws Exception {
                    try {
                        final String[] config = DatabaseUserConfigLoader.this.queryDatabase(DatabaseUserConfigLoader.this.querySql, false, loggedInUser);
                        if (config.length != DatabaseUserConfigLoader.this.keys.length) {
                            throw new UserConfigLoaderException("size of columns retrieved by db query(" + config.length + ") " + "is not equal to the number of keys required(" + DatabaseUserConfigLoader.this.keys.length + ").");
                        }
                        return new HashMap<String, String>(){
                            {
                                for (int i = 0; i < DatabaseUserConfigLoader.this.keys.length; ++i) {
                                    this.put(DatabaseUserConfigLoader.this.keys[i], config[i]);
                                }
                            }
                        };
                    }
                    catch (SQLException e) {
                        throw new UserConfigLoaderException(e);
                    }
                }
            });
        }
        catch (ExecutionException e) {
            throw new UserConfigLoaderException(e);
        }
    }

    private BasicDataSource refreshDataSource() {
        if (this.ds == null || this.ds.isClosed()) {
            this.ds = UtilityMethods.getDataSourceFromConf((Configuration)this.hiveConf);
        }
        return this.ds;
    }

    String[] queryDatabase(String querySql, boolean allowNull, Object ... args) throws SQLException {
        return UtilityMethods.queryDatabase(this.refreshDataSource(), querySql, allowNull, args);
    }
}

