/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.user;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.lens.server.user.DatabaseUserConfigLoader;
import org.apache.lens.server.user.UserConfigLoaderException;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class LDAPBackedDatabaseUserConfigLoader
extends DatabaseUserConfigLoader {
    private final Cache<String, String[]> intermediateCache;
    private final Cache<String[], Map<String, String>> cache;
    private final String intermediateQuerySql;
    private final String[] ldapFields;
    private final String intermediateDeleteSql;
    private final String intermediateInsertSql;
    private static final DateTimeFormatter outputFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:SS").withZoneUTC();
    private final int expiryHours;
    private final String searchBase;
    private final String searchFilterPattern;
    private final Hashtable<String, Object> env;

    public LDAPBackedDatabaseUserConfigLoader(final HiveConf conf) throws UserConfigLoaderException {
        super(conf);
        this.expiryHours = conf.getInt("lens.server.user.resolver.cache.expiry", 2);
        this.intermediateQuerySql = conf.get("lens.server.user.resolver.ldap.intermediate.db.query");
        this.intermediateDeleteSql = conf.get("lens.server.user.resolver.ldap.intermediate.db.delete.sql");
        this.intermediateInsertSql = conf.get("lens.server.user.resolver.ldap.intermediate.db.insert.sql");
        this.ldapFields = conf.get("lens.server.user.resolver.ldap.fields").split("\\s*,\\s*");
        this.searchBase = conf.get("lens.server.user.resolver.ldap.search.base");
        this.searchFilterPattern = conf.get("lens.server.user.resolver.ldap.search.filter");
        this.intermediateCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.expiryHours, TimeUnit.HOURS).maximumSize((long)conf.getInt("lens.server.user.resolver.cache.max_size", 100)).build();
        this.cache = CacheBuilder.newBuilder().expireAfterWrite((long)this.expiryHours, TimeUnit.HOURS).maximumSize((long)conf.getInt("lens.server.user.resolver.cache.max_size", 100)).build();
        this.env = new Hashtable<String, Object>(){
            {
                this.put("java.naming.security.authentication", "simple");
                this.put("java.naming.security.principal", conf.get("lens.server.user.resolver.ldap.bind.dn"));
                this.put("java.naming.security.credentials", conf.get("lens.server.user.resolver.ldap.bind.password"));
                this.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                this.put("java.naming.provider.url", conf.get("lens.server.user.resolver.ldap.url"));
                this.put("java.naming.ldap.attributes.binary", "objectSID");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SearchResult findAccountByAccountName(String accountName) throws NamingException {
        String searchFilter = String.format(this.searchFilterPattern, accountName);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        InitialLdapContext ctx = new InitialLdapContext(this.env, null);
        try {
            NamingEnumeration<SearchResult> results = ctx.search(this.searchBase, searchFilter, searchControls);
            if (!results.hasMoreElements()) {
                throw new UserConfigLoaderException("LDAP Search returned no accounts");
            }
            SearchResult searchResult = (SearchResult)results.nextElement();
            if (results.hasMoreElements()) {
                throw new UserConfigLoaderException("More than one account found in ldap search");
            }
            SearchResult searchResult2 = searchResult;
            return searchResult2;
        }
        finally {
            ctx.close();
        }
    }

    public String[] getAttributes(String user) throws NamingException {
        String[] attributes = new String[this.ldapFields.length];
        SearchResult sr = this.findAccountByAccountName(user);
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i] = sr.getAttributes().get(this.ldapFields[i]).get().toString();
        }
        return attributes;
    }

    @Override
    public Map<String, String> getUserConfig(final String loggedInUser) throws UserConfigLoaderException {
        try {
            final String[] intermediateKey = (String[])this.intermediateCache.get((Object)loggedInUser, (Callable)new Callable<String[]>(){

                @Override
                public String[] call() throws Exception {
                    String[] config = LDAPBackedDatabaseUserConfigLoader.this.queryDatabase(LDAPBackedDatabaseUserConfigLoader.this.intermediateQuerySql, true, loggedInUser, Timestamp.valueOf(DateTime.now().toString(outputFormatter)));
                    if (config == null) {
                        config = LDAPBackedDatabaseUserConfigLoader.this.getAttributes(loggedInUser);
                        Object[] updateArray = new Object[config.length + 2];
                        for (int i = 0; i < config.length; ++i) {
                            updateArray[i + 1] = config[i];
                        }
                        updateArray[0] = loggedInUser;
                        updateArray[config.length + 1] = Timestamp.valueOf(DateTime.now().plusHours(LDAPBackedDatabaseUserConfigLoader.this.expiryHours).toString(outputFormatter));
                        QueryRunner runner = new QueryRunner((DataSource)LDAPBackedDatabaseUserConfigLoader.this.ds);
                        runner.update(LDAPBackedDatabaseUserConfigLoader.this.intermediateDeleteSql, (Object)loggedInUser);
                        runner.update(LDAPBackedDatabaseUserConfigLoader.this.intermediateInsertSql, updateArray);
                    }
                    return config;
                }
            });
            return (Map)this.cache.get((Object)intermediateKey, (Callable)new Callable<Map<String, String>>(){

                @Override
                public Map<String, String> call() throws Exception {
                    final String[] argsAsArray = LDAPBackedDatabaseUserConfigLoader.this.queryDatabase(LDAPBackedDatabaseUserConfigLoader.this.querySql, false, intermediateKey);
                    if (argsAsArray.length != LDAPBackedDatabaseUserConfigLoader.this.keys.length) {
                        throw new UserConfigLoaderException("size of columns retrieved by db query(" + argsAsArray.length + ") " + "is not equal to the number of keys required(" + LDAPBackedDatabaseUserConfigLoader.this.keys.length + ").");
                    }
                    return new HashMap<String, String>(){
                        {
                            for (int i = 0; i < LDAPBackedDatabaseUserConfigLoader.this.keys.length; ++i) {
                                this.put(LDAPBackedDatabaseUserConfigLoader.this.keys[i], argsAsArray[i]);
                            }
                        }
                    };
                }
            });
        }
        catch (ExecutionException e) {
            throw new UserConfigLoaderException(e);
        }
    }
}

