/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.hadoop.conf.Configuration;

public class UtilityMethods {
    public static <K, V> void mergeMaps(Map<K, V> into, Map<K, V> from, boolean override) {
        for (K key : from.keySet()) {
            if (!override && into.containsKey(key)) continue;
            into.put(key, from.get(key));
        }
    }

    public static String removeDomain(String username) {
        if (username.contains("@")) {
            username = username.substring(0, username.indexOf("@"));
        }
        return username;
    }

    public static boolean anyNull(Object ... args) {
        for (Object arg : args) {
            if (arg != null) continue;
            return true;
        }
        return false;
    }

    public static String[] queryDatabase(BasicDataSource ds, String querySql, final boolean allowNull, Object ... args) throws SQLException {
        QueryRunner runner = new QueryRunner((DataSource)ds);
        return (String[])runner.query(querySql, (ResultSetHandler)new ResultSetHandler<String[]>(){

            public String[] handle(ResultSet resultSet) throws SQLException {
                String[] result = new String[resultSet.getMetaData().getColumnCount()];
                if (!resultSet.next()) {
                    if (allowNull) {
                        return null;
                    }
                    throw new SQLException("no rows retrieved in query");
                }
                for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                    result[i - 1] = resultSet.getString(i);
                }
                if (resultSet.next()) {
                    throw new SQLException("more than one row retrieved in query");
                }
                return result;
            }
        }, args);
    }

    public static BasicDataSource getDataSourceFromConf(Configuration conf) {
        BasicDataSource tmp = new BasicDataSource();
        tmp.setDriverClassName(conf.get("lens.server.db.driver.name", "org.hsqldb.jdbcDriver"));
        tmp.setUrl(conf.get("lens.server.db.jdbc.url", "jdbc:hsqldb:/tmp/lensserver/queries.db"));
        tmp.setUsername(conf.get("lens.server.db.jdbc.user", "SA"));
        tmp.setPassword(conf.get("lens.server.db.jdbc.pass", ""));
        return tmp;
    }

    public static String confToString(Configuration conf) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : conf) {
            sb.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append("\n");
        }
        return sb.toString();
    }
}

