/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.shaded.apache.http.impl.client;

import java.io.IOException;
import org.apache.livy.shaded.apache.http.HttpEntity;
import org.apache.livy.shaded.apache.http.HttpResponse;
import org.apache.livy.shaded.apache.http.StatusLine;
import org.apache.livy.shaded.apache.http.annotation.Contract;
import org.apache.livy.shaded.apache.http.annotation.ThreadingBehavior;
import org.apache.livy.shaded.apache.http.client.HttpResponseException;
import org.apache.livy.shaded.apache.http.client.ResponseHandler;
import org.apache.livy.shaded.apache.http.util.EntityUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public abstract class AbstractResponseHandler<T>
implements ResponseHandler<T> {
    @Override
    public T handleResponse(HttpResponse response) throws HttpResponseException, IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            EntityUtils.consume(entity);
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return entity == null ? null : (T)this.handleEntity(entity);
    }

    public abstract T handleEntity(HttpEntity var1) throws IOException;
}

