/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.test.junit;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.test.TestProperties;
import org.apache.logging.log4j.test.junit.DirectoryCleaner;
import org.apache.logging.log4j.test.junit.ExtensionContextAnchor;
import org.apache.logging.log4j.test.junit.TempLoggingDir;
import org.apache.logging.log4j.test.junit.TestPropertySource;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ExtensionContextException;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.io.CleanupMode;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ModifierSupport;

public class TempLoggingDirectory
implements BeforeAllCallback,
BeforeEachCallback,
ParameterResolver {
    public void beforeAll(ExtensionContext context) throws Exception {
        List fields = AnnotationSupport.findAnnotatedFields((Class)context.getRequiredTestClass(), TempLoggingDir.class, ModifierSupport::isStatic);
        Path loggingPath = null;
        for (Field field : fields) {
            if (loggingPath != null) {
                StatusLogger.getLogger().warn("Multiple static fields with @TempLoggingDir annotation are not supported.");
            } else {
                CleanupMode cleanup = this.determineCleanupMode(field);
                loggingPath = this.createLoggingPath(context, cleanup).getPath();
            }
            field.setAccessible(true);
            field.set(null, loggingPath);
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        context.getParent().ifPresent(c -> {
            PathHolder holder = ExtensionContextAnchor.getAttribute(PathHolder.class, PathHolder.class, c);
            if (holder != null) {
                holder.addContext(context);
            }
        });
        List fields = AnnotationSupport.findAnnotatedFields((Class)context.getRequiredTestClass(), TempLoggingDir.class, ModifierSupport::isNotStatic);
        Path loggingPath = null;
        Object instance = context.getRequiredTestInstance();
        for (Field field : fields) {
            if (loggingPath != null) {
                StatusLogger.getLogger().warn("Multiple instance fields with @TempLoggingDir annotation are not supported.");
            } else {
                CleanupMode cleanup = this.determineCleanupMode(field);
                loggingPath = this.createLoggingPath(context, cleanup).getPath();
            }
            field.setAccessible(true);
            field.set(instance, loggingPath);
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (parameterContext.getParameter().getType().isAssignableFrom(Path.class)) {
            return parameterContext.findAnnotation(TempLoggingDir.class).isPresent();
        }
        return false;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        TempLoggingDir annotation = (TempLoggingDir)parameterContext.findAnnotation(TempLoggingDir.class).get();
        PathHolder holder = ExtensionContextAnchor.getAttribute(PathHolder.class, PathHolder.class, extensionContext);
        if (holder == null || !extensionContext.equals(holder.getMainContext())) {
            CleanupMode mode = this.determineCleanupMode(annotation);
            holder = this.createLoggingPath(extensionContext, mode);
        }
        return holder.getPath();
    }

    private PathHolder createLoggingPath(ExtensionContext context, CleanupMode cleanup) {
        TestProperties props = TestPropertySource.createProperties(context);
        Path perClassPath = this.determinePerClassPath(context);
        Path loggingPath = context.getTestMethod().map(m -> perClassPath.resolve(m.getName())).orElse(perClassPath);
        try {
            Files.createDirectories(loggingPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ExtensionContextException("Failed to create temporary directory.", (Throwable)e);
        }
        props.setProperty("logging.path", loggingPath.toString());
        PathHolder holder = new PathHolder(loggingPath, cleanup, context);
        ExtensionContextAnchor.setAttribute(PathHolder.class, holder, context);
        return holder;
    }

    private Path determinePerClassPath(ExtensionContext context) {
        PathHolder holder = ExtensionContextAnchor.getAttribute(PathHolder.class, PathHolder.class, context);
        if (holder == null) {
            try {
                String baseDir = System.getProperty("basedir");
                Path basePath = (baseDir != null ? Paths.get(baseDir, "target") : Paths.get(".", new String[0])).resolve("logs");
                Class clazz = context.getRequiredTestClass();
                Package pkg = clazz.getPackage();
                String dir = pkg.getName().replaceAll("[.$]", File.separatorChar == '\\' ? "\\\\" : File.separator);
                Path packagePath = basePath.resolve(dir);
                Files.createDirectories(packagePath, new FileAttribute[0]);
                return Files.createTempDirectory(packagePath, clazz.getSimpleName(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ExtensionContextException("Failed to create temporary directory.", (Throwable)e);
            }
        }
        return holder.getPath();
    }

    private CleanupMode determineCleanupMode(TempLoggingDir annotation) {
        CleanupMode mode = annotation.cleanup();
        return mode != CleanupMode.DEFAULT ? mode : CleanupMode.ON_SUCCESS;
    }

    private CleanupMode determineCleanupMode(Field field) {
        return this.determineCleanupMode(field.getAnnotation(TempLoggingDir.class));
    }

    private static class PathHolder
    implements ExtensionContext.Store.CloseableResource {
        private final Path path;
        private final CleanupMode cleanupMode;
        private final ExtensionContext mainContext;
        private final Map<ExtensionContext, Boolean> contexts = new ConcurrentHashMap<ExtensionContext, Boolean>();

        public PathHolder(Path path, CleanupMode cleanup, ExtensionContext context) {
            this.path = path;
            this.cleanupMode = cleanup;
            this.contexts.put(context, Boolean.TRUE);
            this.mainContext = context;
        }

        public void addContext(ExtensionContext context) {
            this.contexts.put(context, Boolean.TRUE);
        }

        public Path getPath() {
            return this.path;
        }

        public ExtensionContext getMainContext() {
            return this.mainContext;
        }

        public void close() throws IOException {
            if (this.cleanupMode == CleanupMode.NEVER || this.cleanupMode == CleanupMode.ON_SUCCESS && this.contexts.keySet().stream().anyMatch(context -> context.getExecutionException().isPresent())) {
                StatusLogger.getLogger().debug("Skipping cleanup of directory {}.", (Object)this.path);
                return;
            }
            DirectoryCleaner.deleteDirectory(this.path);
        }
    }
}

