/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Level {
    OFF(0),
    FATAL(1),
    ERROR(2),
    WARN(3),
    INFO(4),
    DEBUG(5),
    TRACE(6),
    ALL(Integer.MAX_VALUE);

    private final int intLevel;

    private Level(int val) {
        this.intLevel = val;
    }

    public static Level toLevel(String sArg) {
        return Level.toLevel(sArg, DEBUG);
    }

    public static Level toLevel(String sArg, Level defaultLevel) {
        if (sArg == null) {
            return defaultLevel;
        }
        for (Level level : Level.values()) {
            if (!level.name().equals(sArg)) continue;
            return level;
        }
        return defaultLevel;
    }

    public boolean isAtLeastAsSpecificAs(Level level) {
        return this.intLevel <= level.intLevel;
    }

    public boolean isAtLeastAsSpecificAs(int level) {
        return this.intLevel <= level;
    }

    public boolean lessOrEqual(Level level) {
        return this.intLevel <= level.intLevel;
    }

    public boolean lessOrEqual(int level) {
        return this.intLevel <= level;
    }

    public int intLevel() {
        return this.intLevel;
    }
}

