/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.io.Serializable;
import java.util.Map;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.MultiformatMessage;
import org.apache.logging.log4j.message.StructuredDataId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuredDataMessage
extends MapMessage
implements MultiformatMessage,
Serializable {
    public static final String FULL = "FULL";
    private static final long serialVersionUID = 1703221292892071920L;
    private static final int MAX_LENGTH = 32;
    private static final int HASHVAL = 31;
    private StructuredDataId id;
    private String message;
    private String type;

    public StructuredDataMessage(String id, String msg, String type) {
        this.id = new StructuredDataId(id, null, null);
        this.message = msg;
        this.type = type;
    }

    public StructuredDataMessage(String id, String msg, String type, Map<String, String> data) {
        super(data);
        this.id = new StructuredDataId(id, null, null);
        this.message = msg;
        this.type = type;
    }

    public StructuredDataMessage(StructuredDataId id, String msg, String type) {
        this.id = id;
        this.message = msg;
        this.type = type;
    }

    public StructuredDataMessage(StructuredDataId id, String msg, String type, Map<String, String> data) {
        super(data);
        this.id = id;
        this.message = msg;
        this.type = type;
    }

    private StructuredDataMessage(StructuredDataMessage msg, Map<String, String> map) {
        super(map);
        this.id = msg.id;
        this.message = msg.message;
        this.type = msg.type;
    }

    protected StructuredDataMessage() {
    }

    public StructuredDataId getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = new StructuredDataId(id, null, null);
    }

    protected void setId(StructuredDataId id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    protected void setType(String type) {
        if (type.length() > 32) {
            throw new IllegalArgumentException("Structured data type exceeds maximum length of 32 characters: " + type);
        }
        this.type = type;
    }

    @Override
    public String getMessageFormat() {
        return this.message;
    }

    protected void setMessageFormat(String msg) {
        this.message = msg;
    }

    @Override
    protected void validate(String key, String value) {
        if (value.length() > 32) {
            throw new IllegalArgumentException("Structured data values are limited to 32 characters. key: " + key + " value: " + value);
        }
    }

    @Override
    public String asString() {
        return this.asString(FULL, null);
    }

    @Override
    public String asString(String format) {
        return this.asString(format, null);
    }

    public final String asString(String format, StructuredDataId structuredDataId) {
        String msg;
        StructuredDataId id;
        StringBuilder sb = new StringBuilder();
        boolean full = FULL.equals(format);
        if (full) {
            String type = this.getType();
            if (type == null) {
                return sb.toString();
            }
            sb.append(this.getType()).append(" ");
        }
        if ((id = (id = this.getId()) != null ? id.makeId(structuredDataId) : structuredDataId) == null || id.getName() == null) {
            return sb.toString();
        }
        sb.append("[");
        sb.append(id);
        sb.append(" ");
        this.appendMap(sb);
        sb.append("]");
        if (full && (msg = this.getMessageFormat()) != null) {
            sb.append(" ").append(msg);
        }
        return sb.toString();
    }

    @Override
    public String getFormattedMessage() {
        return this.asString(FULL, null);
    }

    @Override
    public String getFormattedMessage(String[] formats) {
        if (formats != null && formats.length > 0) {
            for (String format : formats) {
                if (!format.equalsIgnoreCase(FULL)) continue;
                return this.asString(FULL, null);
            }
            return this.asString(null, null);
        }
        return this.asString(FULL, null);
    }

    @Override
    public String toString() {
        return this.asString(null, null);
    }

    @Override
    public MapMessage newInstance(Map<String, String> map) {
        return new StructuredDataMessage(this, map);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StructuredDataMessage that = (StructuredDataMessage)o;
        if (!super.equals(o)) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.message != null ? !this.message.equals(that.message) : that.message != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        return result;
    }
}

