/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.Properties;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.PropertySource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.ResourceLock;
import uk.org.webcompere.systemstubs.environment.EnvironmentVariables;
import uk.org.webcompere.systemstubs.jupiter.SystemStubsExtension;
import uk.org.webcompere.systemstubs.properties.SystemProperties;

@ExtendWith(value={SystemStubsExtension.class})
@ResourceLock(value="java.lang.System.properties")
public class PropertiesUtilOrderTest {
    private final Properties properties = new Properties();

    @BeforeEach
    public void setUp() throws Exception {
        this.properties.load(ClassLoader.getSystemResourceAsStream("PropertiesUtilOrderTest.properties"));
    }

    @Test
    public void normalizedOverrideLegacy() {
        PropertiesUtil util = new PropertiesUtil(this.properties);
        String legacy = "props.legacy";
        String normalized = "props.normalized";
        Assertions.assertEquals((Object)"props.legacy", (Object)this.properties.getProperty("log4j.legacyProperty"));
        Assertions.assertTrue((boolean)util.hasProperty("log4j.legacyProperty"));
        Assertions.assertEquals((Object)"props.normalized", (Object)util.getStringProperty("log4j.legacyProperty"));
        Assertions.assertEquals((Object)"props.legacy", (Object)this.properties.getProperty("org.apache.logging.log4j.legacyProperty2"));
        Assertions.assertTrue((boolean)util.hasProperty("log4j.legacyProperty2"));
        Assertions.assertEquals((Object)"props.normalized", (Object)util.getStringProperty("org.apache.logging.log4j.legacyProperty2"));
        Assertions.assertEquals((Object)"props.legacy", (Object)this.properties.getProperty("Log4jLegacyProperty3"));
        Assertions.assertTrue((boolean)util.hasProperty("log4j.legacyProperty3"));
        Assertions.assertEquals((Object)"props.normalized", (Object)util.getStringProperty("Log4jLegacyProperty3"));
        Assertions.assertTrue((boolean)util.hasProperty("log4j.nonOverriddenLegacy"));
        Assertions.assertEquals((Object)"props.legacy", (Object)util.getStringProperty("log4j.nonOverriddenLegacy"));
    }

    @Test
    public void fallsBackToTokenMatching() {
        PropertiesUtil util = new PropertiesUtil(this.properties);
        for (int i = 1; i <= 4; ++i) {
            String key = "log4j2.tokenBasedProperty" + i;
            Assertions.assertTrue((boolean)util.hasProperty(key));
            Assertions.assertEquals((Object)"props.token", (Object)util.getStringProperty(key));
        }
        Assertions.assertTrue((boolean)util.hasProperty("log4j2.normalizedProperty"));
        Assertions.assertEquals((Object)"props.normalized", (Object)util.getStringProperty("log4j2.normalizedProperty"));
    }

    @Test
    public void orderOfNormalizedProperties(EnvironmentVariables env, SystemProperties sysProps) {
        this.properties.remove("log4j2.normalizedProperty");
        this.properties.remove("LOG4J_normalized.property");
        PropertiesUtil util = new PropertiesUtil(this.properties);
        Assertions.assertFalse((boolean)util.hasProperty("Log4jNormalizedProperty"));
        Assertions.assertEquals(null, (Object)util.getStringProperty("Log4jNormalizedProperty"));
        Assertions.assertFalse((boolean)util.hasProperty("log4j2.normalizedProperty"));
        Assertions.assertEquals(null, (Object)util.getStringProperty("log4j2.normalizedProperty"));
        this.properties.setProperty("log4j2.normalizedProperty", "props.normalized");
        util.reload();
        Assertions.assertTrue((boolean)util.hasProperty("Log4jNormalizedProperty"));
        Assertions.assertEquals((Object)"props.normalized", (Object)util.getStringProperty("Log4jNormalizedProperty"));
        Assertions.assertTrue((boolean)util.hasProperty("log4j2.normalizedProperty"));
        Assertions.assertEquals((Object)"props.normalized", (Object)util.getStringProperty("log4j2.normalizedProperty"));
        env.set("LOG4J_NORMALIZED_PROPERTY", "env");
        util.reload();
        Assertions.assertTrue((boolean)util.hasProperty("Log4jNormalizedProperty"));
        Assertions.assertEquals((Object)"env", (Object)util.getStringProperty("Log4jNormalizedProperty"));
        Assertions.assertTrue((boolean)util.hasProperty("log4j2.normalizedProperty"));
        Assertions.assertEquals((Object)"env", (Object)util.getStringProperty("log4j2.normalizedProperty"));
        sysProps.set("log4j2.normalizedProperty", "sysProps");
        util.reload();
        Assertions.assertTrue((boolean)util.hasProperty("Log4jNormalizedProperty"));
        Assertions.assertEquals((Object)"sysProps", (Object)util.getStringProperty("Log4jNormalizedProperty"));
        Assertions.assertTrue((boolean)util.hasProperty("log4j2.normalizedProperty"));
        Assertions.assertEquals((Object)"sysProps", (Object)util.getStringProperty("log4j2.normalizedProperty"));
    }

    @Test
    public void highPriorityNonEnumerableSource(SystemProperties sysProps) {
        Assertions.assertNotNull((Object)this.properties.getProperty("log4j2.normalizedProperty"));
        Assertions.assertNotNull((Object)this.properties.getProperty("log4j.onlyLegacy"));
        sysProps.set("log4j2.normalizedProperty", "sysProps.normalized");
        sysProps.set("log4j.onlyLegacy", "sysProps.legazy");
        Assertions.assertNull((Object)this.properties.getProperty("log4j2.normalizedPropertySysProps"));
        Assertions.assertNull((Object)this.properties.getProperty("log4j.onlyLegacySysProps"));
        sysProps.set("log4j2.normalizedPropertySysProps", "sysProps.normalized");
        sysProps.set("log4j.onlyLegacySysProps", "sysProps.legacy");
        Assertions.assertNotNull((Object)this.properties.getProperty("log4j2.normalizedPropertyProps"));
        Assertions.assertNotNull((Object)this.properties.getProperty("log4j.onlyLegacyProps"));
        PropertiesUtil util = new PropertiesUtil((PropertySource)new NonEnumerablePropertySource(this.properties));
        Assertions.assertTrue((boolean)util.hasProperty("log4j2.normalizedProperty"));
        Assertions.assertEquals((Object)"props.normalized", (Object)util.getStringProperty("log4j2.normalizedProperty"));
        Assertions.assertTrue((boolean)util.hasProperty("log4j.onlyLegacy"));
        Assertions.assertEquals((Object)"props.legacy", (Object)util.getStringProperty("log4j.onlyLegacy"));
        Assertions.assertTrue((boolean)util.hasProperty("log4j2.normalizedPropertySysProps"));
        Assertions.assertEquals((Object)"sysProps.normalized", (Object)util.getStringProperty("log4j2.normalizedPropertySysProps"));
        Assertions.assertTrue((boolean)util.hasProperty("log4j.onlyLegacySysProps"));
        Assertions.assertEquals((Object)"sysProps.legacy", (Object)util.getStringProperty("log4j.onlyLegacySysProps"));
        Assertions.assertTrue((boolean)util.hasProperty("log4j2.normalizedPropertyProps"));
        Assertions.assertEquals((Object)"props.normalized", (Object)util.getStringProperty("log4j2.normalizedPropertyProps"));
        Assertions.assertTrue((boolean)util.hasProperty("log4j.onlyLegacyProps"));
        Assertions.assertEquals((Object)"props.legacy", (Object)util.getStringProperty("log4j.onlyLegacyProps"));
    }

    @Test
    public void nullChecks(SystemProperties sysProps) {
        sysProps.set("log4j2.someProperty", "sysProps");
        sysProps.set("Log4jLegacyProperty", "sysProps");
        PropertiesUtil util = new PropertiesUtil((PropertySource)new NullPropertySource());
        Assertions.assertTrue((boolean)util.hasProperty("log4j2.someProperty"));
        Assertions.assertEquals((Object)"sysProps", (Object)util.getStringProperty("log4j2.someProperty"));
        Assertions.assertTrue((boolean)util.hasProperty("Log4jLegacyProperty"));
        Assertions.assertEquals((Object)"sysProps", (Object)util.getStringProperty("Log4jLegacyProperty"));
        Assertions.assertTrue((boolean)util.hasProperty("log4j.legacyProperty"));
        Assertions.assertEquals((Object)"sysProps", (Object)util.getStringProperty("log4j.legacyProperty"));
        Assertions.assertFalse((boolean)util.hasProperty("log4j2.nonExistentProperty"));
        Assertions.assertNull((Object)util.getStringProperty("log4j2.nonExistentProperty"));
    }

    public static class NullPropertySource
    implements PropertySource {
        public int getPriority() {
            return Integer.MIN_VALUE;
        }
    }

    public static class NonEnumerablePropertySource
    implements PropertySource {
        private final Properties props;

        public NonEnumerablePropertySource(Properties props) {
            this.props = props;
        }

        public int getPriority() {
            return Integer.MIN_VALUE;
        }

        public CharSequence getNormalForm(Iterable<? extends CharSequence> tokens) {
            return "log4j2." + PropertySource.Util.joinAsCamelCase(tokens);
        }

        public String getProperty(String key) {
            return this.props.getProperty(key);
        }

        public boolean containsProperty(String key) {
            return this.getProperty(key) != null;
        }
    }
}

