/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.status.StatusLogger;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class LoggerRegistry<T extends ExtendedLogger> {
    private final Map<String, Map<MessageFactory, WeakReference<T>>> loggerRefByMessageFactoryByName = new HashMap<String, Map<MessageFactory, WeakReference<T>>>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();

    public LoggerRegistry() {
    }

    @Deprecated
    public LoggerRegistry(@Nullable MapFactory<T> mapFactory) {
        this();
    }

    @Deprecated
    public T getLogger(String name) {
        Objects.requireNonNull(name, "name");
        return this.getLogger(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getLogger(String name, @Nullable MessageFactory messageFactory) {
        Objects.requireNonNull(name, "name");
        this.readLock.lock();
        try {
            Map<MessageFactory, WeakReference<T>> loggerRefByMessageFactory = this.loggerRefByMessageFactoryByName.get(name);
            if (loggerRefByMessageFactory == null) {
                T t = null;
                return t;
            }
            MessageFactory effectiveMessageFactory = messageFactory != null ? messageFactory : ParameterizedMessageFactory.INSTANCE;
            WeakReference<T> loggerRef = loggerRefByMessageFactory.get(effectiveMessageFactory);
            if (loggerRef == null) {
                T t = null;
                return t;
            }
            ExtendedLogger extendedLogger = (ExtendedLogger)loggerRef.get();
            return (T)extendedLogger;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Collection<T> getLoggers() {
        return this.getLoggers(new ArrayList());
    }

    public Collection<T> getLoggers(Collection<T> destination) {
        Objects.requireNonNull(destination, "destination");
        this.readLock.lock();
        try {
            this.loggerRefByMessageFactoryByName.values().stream().flatMap(loggerRefByMessageFactory -> loggerRefByMessageFactory.values().stream().map(Reference::get)).filter(Objects::nonNull).forEach(destination::add);
        }
        finally {
            this.readLock.unlock();
        }
        return destination;
    }

    @Deprecated
    public boolean hasLogger(String name) {
        Objects.requireNonNull(name, "name");
        T logger = this.getLogger(name);
        return logger != null;
    }

    public boolean hasLogger(String name, @Nullable MessageFactory messageFactory) {
        Objects.requireNonNull(name, "name");
        T logger = this.getLogger(name, messageFactory);
        return logger != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLogger(String name, Class<? extends MessageFactory> messageFactoryClass) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(messageFactoryClass, "messageFactoryClass");
        this.readLock.lock();
        try {
            boolean bl = this.loggerRefByMessageFactoryByName.getOrDefault(name, Collections.emptyMap()).keySet().stream().anyMatch(messageFactory -> messageFactoryClass.equals(messageFactory.getClass()));
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void putIfAbsent(@Nullable String name, @Nullable MessageFactory messageFactory, T logger) {
        Objects.requireNonNull(logger, "logger");
        this.writeLock.lock();
        try {
            String loggerName = logger.getName();
            Map loggerRefByMessageFactory = this.loggerRefByMessageFactoryByName.computeIfAbsent(loggerName, this::createLoggerRefByMessageFactoryMap);
            Object loggerMessageFactory = logger.getMessageFactory();
            WeakReference loggerRef = (WeakReference)loggerRefByMessageFactory.get(loggerMessageFactory);
            if (loggerRef == null || loggerRef.get() == null) {
                loggerRefByMessageFactory.put(loggerMessageFactory, new WeakReference<T>(logger));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T computeIfAbsent(String name, MessageFactory messageFactory, BiFunction<String, MessageFactory, T> loggerSupplier) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(messageFactory, "messageFactory");
        Objects.requireNonNull(loggerSupplier, "loggerSupplier");
        Object logger = this.getLogger(name, messageFactory);
        if (logger != null) {
            return (T)logger;
        }
        this.writeLock.lock();
        try {
            Map loggerRefByMessageFactory = this.loggerRefByMessageFactoryByName.computeIfAbsent(name, this::createLoggerRefByMessageFactoryMap);
            WeakReference loggerRef = (WeakReference)loggerRefByMessageFactory.get(messageFactory);
            if (loggerRef != null && (logger = (ExtendedLogger)loggerRef.get()) != null) {
                Object object = logger;
                return object;
            }
            logger = (ExtendedLogger)loggerSupplier.apply(name, messageFactory);
            Object loggerMessageFactory = logger.getMessageFactory();
            if (!loggerMessageFactory.equals(messageFactory)) {
                StatusLogger.getLogger().error("Newly registered logger with name `{}` and message factory `{}`, is requested to be associated with a different message factory: `{}`.\nEffectively the message factory of the logger will be used and the other one will be ignored.\nThis generally hints a problem at the logger context implementation.\nPlease report this using the Log4j project issue tracker.", (Object)name, loggerMessageFactory, (Object)messageFactory);
            }
            loggerRefByMessageFactory.put(loggerMessageFactory, new WeakReference<Object>(logger));
            Object object = logger;
            return (T)object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Map<MessageFactory, WeakReference<T>> createLoggerRefByMessageFactoryMap(String ignored) {
        return new WeakHashMap<MessageFactory, WeakReference<T>>();
    }

    @Deprecated
    public static class WeakMapFactory<T extends ExtendedLogger>
    implements MapFactory<T> {
        @Override
        public Map<String, T> createInnerMap() {
            return new WeakHashMap();
        }

        @Override
        public Map<String, Map<String, T>> createOuterMap() {
            return new WeakHashMap<String, Map<String, T>>();
        }

        @Override
        public void putIfAbsent(Map<String, T> innerMap, String name, T logger) {
            innerMap.put(name, logger);
        }
    }

    @Deprecated
    public static class ConcurrentMapFactory<T extends ExtendedLogger>
    implements MapFactory<T> {
        @Override
        public Map<String, T> createInnerMap() {
            return new ConcurrentHashMap();
        }

        @Override
        public Map<String, Map<String, T>> createOuterMap() {
            return new ConcurrentHashMap<String, Map<String, T>>();
        }

        @Override
        public void putIfAbsent(Map<String, T> innerMap, String name, T logger) {
            innerMap.putIfAbsent(name, logger);
        }
    }

    @Deprecated
    public static interface MapFactory<T extends ExtendedLogger> {
        public Map<String, T> createInnerMap();

        public Map<String, Map<String, T>> createOuterMap();

        public void putIfAbsent(Map<String, T> var1, String var2, T var3);
    }
}

