/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.status;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.util.PropertyEnvironment;

public class StatusLoggerConfiguration {
    private final PropertyEnvironment environment;

    public StatusLoggerConfiguration(PropertyEnvironment environment) {
        this.environment = environment;
    }

    public int getMaxEntries() {
        return this.environment.getIntegerProperty("log4j2.statusEntries", 200);
    }

    public Level getDefaultLevel() {
        return Level.toLevel(this.environment.getStringProperty("log4j2.statusLoggerLevel"), Level.WARN);
    }

    public boolean isDebugEnabled() {
        return this.environment.getBooleanProperty("log4j2.*.System.debug", false, true);
    }

    public DateFormat getDateTimeFormat() {
        String format = this.environment.getStringProperty("log4j2.statusLoggerDateFormat");
        if (format != null) {
            try {
                return new SimpleDateFormat(format);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }
}

