/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.logging.log4j.util.InternalApi;
import org.apache.logging.log4j.util.Lazy;
import org.apache.logging.log4j.util.LowLevelLogUtil;
import org.apache.logging.log4j.util.PropertiesPropertySource;
import org.apache.logging.log4j.util.PropertyEnvironment;
import org.apache.logging.log4j.util.PropertyFilePropertySource;
import org.apache.logging.log4j.util.PropertySource;
import org.apache.logging.log4j.util.ServiceRegistry;

@InternalApi
public class PropertiesUtil
implements PropertyEnvironment {
    private static final String LOG4J_PROPERTIES_FILE_NAME = "log4j2.component.properties";
    private static final String LOG4J_SYSTEM_PROPERTIES_FILE_NAME = "log4j2.system.properties";
    private static final Lazy<PropertiesUtil> COMPONENT_PROPERTIES = Lazy.lazy(() -> new PropertiesUtil(LOG4J_PROPERTIES_FILE_NAME));
    private final Environment environment;

    public PropertiesUtil(Properties props) {
        this(new PropertiesPropertySource(props));
    }

    public PropertiesUtil(String propertiesFileName) {
        this(propertiesFileName, true);
    }

    private PropertiesUtil(String propertiesFileName, boolean useTccl) {
        this.environment = new Environment(new PropertyFilePropertySource(propertiesFileName, useTccl));
    }

    PropertiesUtil(PropertySource source) {
        this.environment = new Environment(source);
    }

    public static PropertiesUtil getProperties() {
        return COMPONENT_PROPERTIES.value();
    }

    public static PropertyEnvironment getProperties(String namespace) {
        return new Environment(new PropertyFilePropertySource(String.format("log4j2.%s.properties", namespace)));
    }

    public static ResourceBundle getCharsetsResourceBundle() {
        return ResourceBundle.getBundle("Log4j-charsets");
    }

    @Override
    public void addPropertySource(PropertySource propertySource) {
        if (this.environment != null) {
            this.environment.addPropertySource(propertySource);
        }
    }

    @Override
    public boolean hasProperty(String name) {
        return this.environment.hasProperty(name);
    }

    public double getDoubleProperty(String name, double defaultValue) {
        String prop = this.getStringProperty(name);
        if (prop != null) {
            try {
                return Double.parseDouble(prop);
            }
            catch (Exception ignored) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    @Override
    public String getStringProperty(String name) {
        return this.environment.getStringProperty(name);
    }

    public static Properties getSystemProperties() {
        try {
            return new Properties(System.getProperties());
        }
        catch (SecurityException ex) {
            LowLevelLogUtil.logException("Unable to access system properties.", ex);
            return new Properties();
        }
    }

    public void reload() {
        this.environment.reload();
    }

    public static Properties extractSubset(Properties properties, String prefix) {
        Properties subset = new Properties();
        if (prefix == null || prefix.length() == 0) {
            return subset;
        }
        Object prefixToMatch = prefix.charAt(prefix.length() - 1) != '.' ? prefix + "." : prefix;
        ArrayList<String> keys = new ArrayList<String>();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith((String)prefixToMatch)) continue;
            subset.setProperty(key.substring(((String)prefixToMatch).length()), properties.getProperty(key));
            keys.add(key);
        }
        for (String key : keys) {
            properties.remove(key);
        }
        return subset;
    }

    public static Map<String, Properties> partitionOnCommonPrefixes(Properties properties) {
        return PropertiesUtil.partitionOnCommonPrefixes(properties, false);
    }

    public static Map<String, Properties> partitionOnCommonPrefixes(Properties properties, boolean includeBaseKey) {
        ConcurrentHashMap<String, Properties> parts = new ConcurrentHashMap<String, Properties>();
        for (String key : properties.stringPropertyNames()) {
            int idx = key.indexOf(46);
            if (idx < 0) {
                if (!includeBaseKey) continue;
                if (!parts.containsKey(key)) {
                    parts.put(key, new Properties());
                }
                ((Properties)parts.get(key)).setProperty("", properties.getProperty(key));
                continue;
            }
            String prefix = key.substring(0, idx);
            if (!parts.containsKey(prefix)) {
                parts.put(prefix, new Properties());
            }
            ((Properties)parts.get(prefix)).setProperty(key.substring(idx + 1), properties.getProperty(key));
        }
        return parts;
    }

    private static class Environment
    implements PropertyEnvironment {
        private final Set<PropertySource> sources = new ConcurrentSkipListSet<PropertySource>(new PropertySource.Comparator());
        private final Map<String, String> literal = new ConcurrentHashMap<String, String>();
        private final Map<String, String> normalized = new ConcurrentHashMap<String, String>();
        private final Map<List<CharSequence>, String> tokenized = new ConcurrentHashMap<List<CharSequence>, String>();

        private Environment(PropertySource propertySource) {
            PropertyFilePropertySource sysProps = new PropertyFilePropertySource(PropertiesUtil.LOG4J_SYSTEM_PROPERTIES_FILE_NAME);
            try {
                sysProps.forEach((key, value) -> {
                    if (System.getProperty(key) == null) {
                        System.setProperty(key, value);
                    }
                });
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.sources.add(propertySource);
            ServiceRegistry registry = ServiceRegistry.getInstance();
            this.sources.addAll(registry.getServices(PropertySource.class, MethodHandles.lookup(), null, false));
            this.reload();
        }

        @Override
        public void addPropertySource(PropertySource propertySource) {
            this.sources.add(propertySource);
        }

        private synchronized void reload() {
            this.literal.clear();
            this.normalized.clear();
            this.tokenized.clear();
            HashSet keys = new HashSet();
            this.sources.stream().map(PropertySource::getPropertyNames).forEach(keys::addAll);
            keys.stream().filter(Objects::nonNull).forEach(key -> {
                List<CharSequence> tokens = PropertySource.Util.tokenize(key);
                boolean hasTokens = !tokens.isEmpty();
                this.sources.forEach(source -> {
                    String normalKey;
                    if (source.containsProperty((String)key)) {
                        String value = source.getProperty((String)key);
                        this.literal.putIfAbsent((String)key, value);
                        if (hasTokens) {
                            this.tokenized.putIfAbsent(tokens, value);
                        }
                    }
                    if (hasTokens && (normalKey = Objects.toString(source.getNormalForm(tokens), null)) != null && source.containsProperty(normalKey)) {
                        this.normalized.putIfAbsent((String)key, source.getProperty(normalKey));
                    }
                });
            });
        }

        @Override
        public String getStringProperty(String key) {
            if (this.normalized.containsKey(key)) {
                return this.normalized.get(key);
            }
            if (this.literal.containsKey(key)) {
                return this.literal.get(key);
            }
            List<CharSequence> tokens = PropertySource.Util.tokenize(key);
            boolean hasTokens = !tokens.isEmpty();
            for (PropertySource source : this.sources) {
                String normalKey;
                if (hasTokens && (normalKey = Objects.toString(source.getNormalForm(tokens), null)) != null && source.containsProperty(normalKey)) {
                    return source.getProperty(normalKey);
                }
                if (!source.containsProperty(key)) continue;
                return source.getProperty(key);
            }
            return this.tokenized.get(tokens);
        }

        @Override
        public boolean hasProperty(String key) {
            List<CharSequence> tokens = PropertySource.Util.tokenize(key);
            return this.normalized.containsKey(key) || this.literal.containsKey(key) || this.tokenized.containsKey(tokens) || this.sources.stream().anyMatch(s -> {
                CharSequence normalizedKey = s.getNormalForm(tokens);
                return s.containsProperty(key) || normalizedKey != null && s.containsProperty(normalizedKey.toString());
            });
        }
    }
}

