/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.docgen.processor.internal;

import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.docgen.processor.internal.StructuralNodeImpl;
import org.asciidoctor.ast.ContentNode;
import org.asciidoctor.ast.ListItem;
import org.asciidoctor.ast.StructuralNode;

public final class ListImpl
extends StructuralNodeImpl
implements org.asciidoctor.ast.List {
    public static final String ORDERED_LIST_CONTEXT = "olist";
    private static final char ORDERED_LIST_MARKER = '.';
    public static final String UNORDERED_LIST_CONTEXT = "ulist";
    private static final char UNORDERED_LIST_MARKER = '*';

    public ListImpl(ContentNode parent) {
        super(parent);
        this.setContext(ORDERED_LIST_CONTEXT);
    }

    @Override
    public void formatTo(StringBuilder buffer) {
        String prefix = this.computeItemPrefix();
        List<StructuralNode> blocks = this.getBlocks();
        if (!blocks.isEmpty()) {
            buffer.append(prefix);
        }
        ListImpl.formatNodeCollection(blocks, prefix, buffer);
    }

    private String computeItemPrefix() {
        StringBuilder sb = new StringBuilder();
        ListImpl currentNode = this;
        while (currentNode instanceof org.asciidoctor.ast.List && Objects.equals(this.getContext(), currentNode.getContext())) {
            sb.append(ORDERED_LIST_CONTEXT.equals(currentNode.getContext()) ? (char)'.' : '*');
            currentNode = currentNode.getParent();
            if (!(currentNode instanceof ListItem)) break;
            currentNode = currentNode.getParent();
        }
        return sb.reverse().append(' ').toString();
    }

    public List<StructuralNode> getItems() {
        return this.getBlocks();
    }

    public boolean hasItems() {
        return !this.getBlocks().isEmpty();
    }

    @Override
    public void setContext(String context) {
        switch (context) {
            case "olist": 
            case "ulist": {
                break;
            }
            default: {
                throw new RuntimeException("Unknown list context " + context);
            }
        }
        super.setContext(context);
    }
}

