/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.mongodb4;

import com.mongodb.ConnectionString;
import com.mongodb.MongoException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.result.InsertOneResult;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.nosql.AbstractNoSqlConnection;
import org.apache.logging.log4j.core.appender.nosql.NoSqlObject;
import org.apache.logging.log4j.mongodb4.MongoDb4DocumentObject;
import org.apache.logging.log4j.status.StatusLogger;
import org.bson.Document;

public final class MongoDb4Connection
extends AbstractNoSqlConnection<Document, MongoDb4DocumentObject> {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final ConnectionString connectionString;
    private final MongoCollection<Document> collection;
    private final MongoClient mongoClient;

    private static MongoCollection<Document> getOrCreateMongoCollection(MongoDatabase database, String collectionName, boolean isCapped, Long sizeInBytes) {
        try {
            LOGGER.debug("Gettting collection '{}'...", (Object)collectionName);
            MongoCollection found = database.getCollection(collectionName);
            LOGGER.debug("Got collection {}", (Object)found);
            return found;
        }
        catch (IllegalStateException e) {
            LOGGER.debug("Collection '{}' does not exist.", (Object)collectionName);
            CreateCollectionOptions options = new CreateCollectionOptions().capped(isCapped).sizeInBytes(sizeInBytes.longValue());
            LOGGER.debug("Creating collection '{}' with options {}...", (Object)collectionName, (Object)options);
            database.createCollection(collectionName, options);
            LOGGER.debug("Created collection.");
            MongoCollection created = database.getCollection(collectionName);
            LOGGER.debug("Got created collection {}", (Object)created);
            return created;
        }
    }

    public MongoDb4Connection(ConnectionString connectionString, MongoClient mongoClient, MongoDatabase mongoDatabase, boolean isCapped, Integer sizeInBytes) {
        this(connectionString, mongoClient, mongoDatabase, isCapped, (long)sizeInBytes);
    }

    public MongoDb4Connection(ConnectionString connectionString, MongoClient mongoClient, MongoDatabase mongoDatabase, boolean isCapped, Long sizeInBytes) {
        this.connectionString = connectionString;
        this.mongoClient = mongoClient;
        this.collection = MongoDb4Connection.getOrCreateMongoCollection(mongoDatabase, connectionString.getCollection(), isCapped, sizeInBytes);
    }

    public void closeImpl() {
        this.mongoClient.close();
    }

    public MongoDb4DocumentObject[] createList(int length) {
        return new MongoDb4DocumentObject[length];
    }

    public MongoDb4DocumentObject createObject() {
        return new MongoDb4DocumentObject();
    }

    public void insertObject(NoSqlObject<Document> object) {
        try {
            Document unwrapped = (Document)object.unwrap();
            LOGGER.debug("Inserting BSON Document {}", (Object)unwrapped);
            InsertOneResult insertOneResult = this.collection.insertOne((Object)unwrapped);
            LOGGER.debug("Insert MongoDb result {}", (Object)insertOneResult);
        }
        catch (MongoException e) {
            throw new AppenderLoggingException("Failed to write log event to MongoDB due to error: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        return String.format("Mongo4Connection [connectionString=%s, collection=%s, mongoClient=%s]", this.connectionString, this.collection, this.mongoClient);
    }
}

