/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.tojul;

import java.util.logging.Logger;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.LoggerContext;
import org.apache.logging.log4j.spi.LoggerRegistry;
import org.apache.logging.log4j.tojul.JULLogger;

class JULLoggerContext
implements LoggerContext {
    private final LoggerRegistry<ExtendedLogger> loggerRegistry = new LoggerRegistry();
    private static final MessageFactory DEFAULT_MESSAGE_FACTORY = ParameterizedMessageFactory.INSTANCE;

    JULLoggerContext() {
    }

    public Object getExternalContext() {
        return null;
    }

    public ExtendedLogger getLogger(String name) {
        return this.getLogger(name, DEFAULT_MESSAGE_FACTORY);
    }

    public ExtendedLogger getLogger(String name, MessageFactory messageFactory) {
        MessageFactory effectiveMessageFactory = messageFactory != null ? messageFactory : DEFAULT_MESSAGE_FACTORY;
        ExtendedLogger oldLogger = this.loggerRegistry.getLogger(name, effectiveMessageFactory);
        if (oldLogger != null) {
            return oldLogger;
        }
        ExtendedLogger newLogger = JULLoggerContext.createLogger(name, effectiveMessageFactory);
        this.loggerRegistry.putIfAbsent(name, effectiveMessageFactory, newLogger);
        return this.loggerRegistry.getLogger(name, effectiveMessageFactory);
    }

    private static ExtendedLogger createLogger(String name, MessageFactory messageFactory) {
        Logger logger = Logger.getLogger(name);
        return new JULLogger(name, messageFactory, logger);
    }

    public boolean hasLogger(String name) {
        return this.loggerRegistry.hasLogger(name, DEFAULT_MESSAGE_FACTORY);
    }

    public boolean hasLogger(String name, MessageFactory messageFactory) {
        MessageFactory effectiveMessageFactory = messageFactory != null ? messageFactory : DEFAULT_MESSAGE_FACTORY;
        return this.loggerRegistry.hasLogger(name, effectiveMessageFactory);
    }

    public boolean hasLogger(String name, Class<? extends MessageFactory> messageFactoryClass) {
        return this.loggerRegistry.hasLogger(name, messageFactoryClass);
    }
}

