/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.web;

import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;

public class Log4jContextListener
implements ServletContextListener {
    public static final String LOG4J_CONTEXT_ATTRIBUTE = "Log4JContext";
    public static final String LOG4J_CONFIG = "log4jConfiguration";
    public static final String LOG4J_CONTEXT_NAME = "log4jContextName";

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        String locn = context.getInitParameter(LOG4J_CONFIG);
        String name = context.getInitParameter(LOG4J_CONTEXT_NAME);
        if (name == null) {
            name = context.getServletContextName();
        }
        if (name == null && locn == null) {
            context.log("No Log4j context configuration provided");
            return;
        }
        context.setAttribute(LOG4J_CONTEXT_ATTRIBUTE, (Object)Configurator.initialize((String)name, (ClassLoader)this.getClassLoader(context), (String)locn));
    }

    public void contextDestroyed(ServletContextEvent event) {
        LoggerContext ctx = (LoggerContext)event.getServletContext().getAttribute(LOG4J_CONTEXT_ATTRIBUTE);
        Configurator.shutdown((LoggerContext)ctx);
    }

    private ClassLoader getClassLoader(ServletContext context) {
        Method[] methods = context.getClass().getMethods();
        Method getClassLoader = null;
        for (Method method : methods) {
            if (!method.getName().equals("getClassLoader")) continue;
            getClassLoader = method;
            break;
        }
        if (getClassLoader != null) {
            try {
                return (ClassLoader)getClassLoader.invoke((Object)context, null);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return Log4jContextListener.class.getClassLoader();
    }
}

