/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.dict;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.lucene.analysis.ja.dict.BinaryDictionary;
import org.apache.lucene.analysis.ja.dict.TokenInfoFST;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.util.IOSupplier;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;

public final class TokenInfoDictionary
extends BinaryDictionary {
    public static final String FST_FILENAME_SUFFIX = "$fst.dat";
    private final TokenInfoFST fst;

    @Deprecated(forRemoval=true, since="9.1")
    public TokenInfoDictionary(BinaryDictionary.ResourceScheme resourceScheme, String resourcePath) throws IOException {
        this((IOSupplier<InputStream>)((IOSupplier)() -> BinaryDictionary.getResource(resourceScheme, resourcePath + "$targetMap.dat")), (IOSupplier<InputStream>)((IOSupplier)() -> BinaryDictionary.getResource(resourceScheme, resourcePath + "$posDict.dat")), (IOSupplier<InputStream>)((IOSupplier)() -> BinaryDictionary.getResource(resourceScheme, resourcePath + "$buffer.dat")), (IOSupplier<InputStream>)((IOSupplier)() -> BinaryDictionary.getResource(resourceScheme, resourcePath + FST_FILENAME_SUFFIX)));
    }

    public TokenInfoDictionary(Path targetMapFile, Path posDictFile, Path dictFile, Path fstFile) throws IOException {
        this((IOSupplier<InputStream>)((IOSupplier)() -> Files.newInputStream(targetMapFile, new OpenOption[0])), (IOSupplier<InputStream>)((IOSupplier)() -> Files.newInputStream(posDictFile, new OpenOption[0])), (IOSupplier<InputStream>)((IOSupplier)() -> Files.newInputStream(dictFile, new OpenOption[0])), (IOSupplier<InputStream>)((IOSupplier)() -> Files.newInputStream(fstFile, new OpenOption[0])));
    }

    public TokenInfoDictionary(URL targetMapUrl, URL posDictUrl, URL dictUrl, URL fstUrl) throws IOException {
        this((IOSupplier<InputStream>)((IOSupplier)() -> targetMapUrl.openStream()), (IOSupplier<InputStream>)((IOSupplier)() -> posDictUrl.openStream()), (IOSupplier<InputStream>)((IOSupplier)() -> dictUrl.openStream()), (IOSupplier<InputStream>)((IOSupplier)() -> fstUrl.openStream()));
    }

    private TokenInfoDictionary() throws IOException {
        this((IOSupplier<InputStream>)((IOSupplier)() -> TokenInfoDictionary.getClassResource("$targetMap.dat")), (IOSupplier<InputStream>)((IOSupplier)() -> TokenInfoDictionary.getClassResource("$posDict.dat")), (IOSupplier<InputStream>)((IOSupplier)() -> TokenInfoDictionary.getClassResource("$buffer.dat")), (IOSupplier<InputStream>)((IOSupplier)() -> TokenInfoDictionary.getClassResource(FST_FILENAME_SUFFIX)));
    }

    private TokenInfoDictionary(IOSupplier<InputStream> targetMapResource, IOSupplier<InputStream> posResource, IOSupplier<InputStream> dictResource, IOSupplier<InputStream> fstResource) throws IOException {
        super(targetMapResource, posResource, dictResource);
        FST fst;
        try (BufferedInputStream is = new BufferedInputStream((InputStream)fstResource.get());){
            InputStreamDataInput in = new InputStreamDataInput((InputStream)is);
            fst = new FST(FST.readMetadata((DataInput)in, (Outputs)PositiveIntOutputs.getSingleton()), (DataInput)in);
        }
        this.fst = new TokenInfoFST((FST<Long>)fst, true);
    }

    private static InputStream getClassResource(String suffix) throws IOException {
        String resourcePath = TokenInfoDictionary.class.getSimpleName() + suffix;
        return (InputStream)IOUtils.requireResourceNonNull((Object)TokenInfoDictionary.class.getResourceAsStream(resourcePath), (String)resourcePath);
    }

    public TokenInfoFST getFST() {
        return this.fst;
    }

    public static TokenInfoDictionary getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        static final TokenInfoDictionary INSTANCE;

        private SingletonHolder() {
        }

        static {
            try {
                INSTANCE = new TokenInfoDictionary();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Cannot load TokenInfoDictionary.", ioe);
            }
        }
    }
}

