/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.LimitTokenCountFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class LimitTokenCountFilterFactory
extends TokenFilterFactory {
    int maxTokenCount;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        String maxTokenCountArg = args.get("maxTokenCount");
        if (maxTokenCountArg == null) {
            throw new IllegalArgumentException("maxTokenCount is mandatory.");
        }
        this.maxTokenCount = Integer.parseInt(args.get(maxTokenCountArg));
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new LimitTokenCountFilter(input, this.maxTokenCount);
    }
}

