/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.morfologik;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import morfologik.stemming.IStemmer;
import morfologik.stemming.PolishStemmer;
import morfologik.stemming.WordData;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.morfologik.MorphosyntacticTagAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.util.CharacterUtils;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.Version;

public class MorfologikFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final MorphosyntacticTagAttribute tagAtt = (MorphosyntacticTagAttribute)this.addAttribute(MorphosyntacticTagAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final CharsRef scratch = new CharsRef(0);
    private final CharacterUtils charUtils;
    private AttributeSource.State current;
    private final TokenStream input;
    private final IStemmer stemmer;
    private List<WordData> lemmaList;
    private int lemmaListIndex;

    public MorfologikFilter(TokenStream in, PolishStemmer.DICTIONARY dict, Version version) {
        super(in);
        this.input = in;
        this.stemmer = new PolishStemmer(dict);
        this.charUtils = CharacterUtils.getInstance((Version)version);
        this.lemmaList = Collections.emptyList();
    }

    private void popNextLemma() {
        WordData lemma = this.lemmaList.get(this.lemmaListIndex++);
        this.termAtt.setEmpty().append(lemma.getStem());
        this.tagAtt.setTag(lemma.getTag());
    }

    private boolean lookupSurfaceForm(CharSequence token) {
        this.lemmaList = this.stemmer.lookup(token);
        this.lemmaListIndex = 0;
        return this.lemmaList.size() > 0;
    }

    public final boolean incrementToken() throws IOException {
        if (this.lemmaListIndex < this.lemmaList.size()) {
            this.restoreState(this.current);
            this.posIncrAtt.setPositionIncrement(0);
            this.popNextLemma();
            return true;
        }
        if (this.input.incrementToken()) {
            if (this.lookupSurfaceForm((CharSequence)this.termAtt) || this.lookupSurfaceForm(this.toLowercase((CharSequence)this.termAtt))) {
                this.current = this.captureState();
                this.popNextLemma();
            } else {
                this.tagAtt.clear();
            }
            return true;
        }
        return false;
    }

    private CharSequence toLowercase(CharSequence chs) {
        int length = this.scratch.length = chs.length();
        this.scratch.grow(length);
        char[] buffer = this.scratch.chars;
        for (int i = 0; i < length; i += Character.toChars(Character.toLowerCase(this.charUtils.codePointAt(chs, i)), buffer, i)) {
        }
        return this.scratch;
    }

    public void reset() throws IOException {
        this.lemmaListIndex = 0;
        this.lemmaList = Collections.emptyList();
        super.reset();
    }
}

