/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.facet.FacetUtils;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.AssociationAggregationFunction;
import org.apache.lucene.facet.taxonomy.FloatTaxonomyFacets;
import org.apache.lucene.facet.taxonomy.OrdinalsReader;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;

public class TaxonomyFacetFloatAssociations
extends FloatTaxonomyFacets {
    private final OrdinalsReader ordinalsReader;

    public TaxonomyFacetFloatAssociations(TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, AssociationAggregationFunction aggregationFunction) throws IOException {
        this("$facets", taxoReader, config, fc, aggregationFunction);
    }

    public TaxonomyFacetFloatAssociations(TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, AssociationAggregationFunction aggregationFunction, DoubleValuesSource valuesSource) throws IOException {
        this("$facets", taxoReader, config, fc, aggregationFunction, valuesSource);
    }

    public TaxonomyFacetFloatAssociations(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, AssociationAggregationFunction aggregationFunction) throws IOException {
        super(indexFieldName, taxoReader, aggregationFunction, config);
        this.ordinalsReader = null;
        this.aggregateValues(aggregationFunction, fc.getMatchingDocs());
    }

    public TaxonomyFacetFloatAssociations(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, AssociationAggregationFunction aggregationFunction, DoubleValuesSource valuesSource) throws IOException {
        super(indexFieldName, taxoReader, aggregationFunction, config);
        this.ordinalsReader = null;
        this.aggregateValues(aggregationFunction, fc.getMatchingDocs(), fc.getKeepScores(), valuesSource);
    }

    @Deprecated
    public TaxonomyFacetFloatAssociations(OrdinalsReader ordinalsReader, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, AssociationAggregationFunction aggregationFunction, DoubleValuesSource valuesSource) throws IOException {
        super(ordinalsReader.getIndexFieldName(), taxoReader, aggregationFunction, config);
        this.ordinalsReader = ordinalsReader;
        this.aggregateValues(aggregationFunction, fc.getMatchingDocs(), fc.getKeepScores(), valuesSource);
    }

    private static DoubleValues scores(final FacetsCollector.MatchingDocs hits) {
        return new DoubleValues(){
            int index = -1;

            public double doubleValue() throws IOException {
                return hits.scores[this.index];
            }

            public boolean advanceExact(int doc) throws IOException {
                this.index = doc;
                return true;
            }
        };
    }

    private void aggregateValues(AssociationAggregationFunction aggregationFunction, List<FacetsCollector.MatchingDocs> matchingDocs, boolean keepScores, DoubleValuesSource valueSource) throws IOException {
        if (this.ordinalsReader != null) {
            IntsRef scratch = new IntsRef();
            for (FacetsCollector.MatchingDocs hits : matchingDocs) {
                int doc;
                OrdinalsReader.OrdinalsSegmentReader ords = this.ordinalsReader.getReader(hits.context);
                DoubleValues scores = keepScores ? TaxonomyFacetFloatAssociations.scores(hits) : null;
                DoubleValues functionValues = valueSource.getValues(hits.context, scores);
                DocIdSetIterator docs = hits.bits.iterator();
                while ((doc = docs.nextDoc()) != Integer.MAX_VALUE) {
                    ords.get(doc, scratch);
                    if (!functionValues.advanceExact(doc)) continue;
                    float value = (float)functionValues.doubleValue();
                    for (int i = 0; i < scratch.length; ++i) {
                        float newValue;
                        int ord = scratch.ints[i];
                        this.values[ord] = newValue = aggregationFunction.aggregate(this.values[ord], value);
                    }
                }
            }
        } else {
            for (FacetsCollector.MatchingDocs hits : matchingDocs) {
                SortedNumericDocValues ordinalValues = FacetUtils.loadOrdinalValues(hits.context.reader(), this.indexFieldName);
                if (ordinalValues == null) continue;
                DoubleValues scores = keepScores ? TaxonomyFacetFloatAssociations.scores(hits) : null;
                DoubleValues functionValues = valueSource.getValues(hits.context, scores);
                DocIdSetIterator it = ConjunctionUtils.intersectIterators(List.of(hits.bits.iterator(), ordinalValues));
                int doc = it.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if (functionValues.advanceExact(doc)) {
                        float value = (float)functionValues.doubleValue();
                        int ordinalCount = ordinalValues.docValueCount();
                        for (int i = 0; i < ordinalCount; ++i) {
                            float newValue;
                            int ord = (int)ordinalValues.nextValue();
                            this.values[ord] = newValue = aggregationFunction.aggregate(this.values[ord], value);
                        }
                    }
                    doc = it.nextDoc();
                }
            }
        }
        this.rollup();
    }

    private void aggregateValues(AssociationAggregationFunction aggregationFunction, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            BinaryDocValues dv = DocValues.getBinary((LeafReader)hits.context.reader(), (String)this.indexFieldName);
            DocIdSetIterator it = ConjunctionUtils.intersectIterators(Arrays.asList(hits.bits.iterator(), dv));
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                BytesRef bytesRef = dv.binaryValue();
                byte[] bytes = bytesRef.bytes;
                int end = bytesRef.offset + bytesRef.length;
                for (int offset = bytesRef.offset; offset < end; offset += 4) {
                    float newValue;
                    int ord = BitUtil.VH_BE_INT.get(bytes, offset);
                    float value = BitUtil.VH_BE_FLOAT.get(bytes, offset += 4);
                    this.values[ord] = newValue = aggregationFunction.aggregate(this.values[ord], value);
                }
                doc = it.nextDoc();
            }
        }
    }
}

