/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.analyzing;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;

public class AnalyzingQueryParser
extends QueryParser {
    public AnalyzingQueryParser(String field, Analyzer analyzer) {
        super(field, analyzer);
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        ArrayList<String> tlist = new ArrayList<String>();
        ArrayList<String> wlist = new ArrayList<String>();
        boolean isWithinToken = !termStr.startsWith("?") && !termStr.startsWith("*");
        StringBuffer tmpBuffer = new StringBuffer();
        char[] chars = termStr.toCharArray();
        for (int i = 0; i < termStr.length(); ++i) {
            if (chars[i] == '?' || chars[i] == '*') {
                if (isWithinToken) {
                    tlist.add(tmpBuffer.toString());
                    tmpBuffer.setLength(0);
                }
                isWithinToken = false;
            } else {
                if (!isWithinToken) {
                    wlist.add(tmpBuffer.toString());
                    tmpBuffer.setLength(0);
                }
                isWithinToken = true;
            }
            tmpBuffer.append(chars[i]);
        }
        if (isWithinToken) {
            tlist.add(tmpBuffer.toString());
        } else {
            wlist.add(tmpBuffer.toString());
        }
        TokenStream source = this.getAnalyzer().tokenStream(field, (Reader)new StringReader(termStr));
        TermAttribute termAtt = (TermAttribute)source.addAttribute(TermAttribute.class);
        int countTokens = 0;
        while (true) {
            try {
                if (!source.incrementToken()) {
                }
            }
            catch (IOException e) {}
            break;
            String term = termAtt.term();
            if ("".equals(term)) continue;
            try {
                tlist.set(countTokens++, term);
            }
            catch (IndexOutOfBoundsException ioobe) {
                countTokens = -1;
            }
        }
        try {
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (countTokens != tlist.size()) {
            throw new ParseException("Cannot build WildcardQuery with analyzer " + this.getAnalyzer().getClass() + " - tokens added or lost");
        }
        if (tlist.size() == 0) {
            return null;
        }
        if (tlist.size() == 1) {
            if (wlist != null && wlist.size() == 1) {
                return super.getWildcardQuery(field, (String)tlist.get(0) + ((String)wlist.get(0)).toString());
            }
            throw new IllegalArgumentException("getWildcardQuery called without wildcard");
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tlist.size(); ++i) {
            sb.append((String)tlist.get(i));
            if (wlist == null || wlist.size() <= i) continue;
            sb.append((String)wlist.get(i));
        }
        return super.getWildcardQuery(field, sb.toString());
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        TokenStream source = this.getAnalyzer().tokenStream(field, (Reader)new StringReader(termStr));
        ArrayList<String> tlist = new ArrayList<String>();
        TermAttribute termAtt = (TermAttribute)source.addAttribute(TermAttribute.class);
        while (true) {
            try {
                if (!source.incrementToken()) {
                }
            }
            catch (IOException e) {}
            break;
            tlist.add(termAtt.term());
        }
        try {
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (tlist.size() == 1) {
            return super.getPrefixQuery(field, (String)tlist.get(0));
        }
        throw new ParseException("Cannot build PrefixQuery with analyzer " + this.getAnalyzer().getClass() + (tlist.size() > 1 ? " - token(s) added" : " - token consumed"));
    }

    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        TokenStream source = this.getAnalyzer().tokenStream(field, (Reader)new StringReader(termStr));
        TermAttribute termAtt = (TermAttribute)source.addAttribute(TermAttribute.class);
        String nextToken = null;
        boolean multipleTokens = false;
        try {
            if (source.incrementToken()) {
                nextToken = termAtt.term();
            }
            multipleTokens = source.incrementToken();
        }
        catch (IOException e) {
            nextToken = null;
        }
        try {
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (multipleTokens) {
            throw new ParseException("Cannot build FuzzyQuery with analyzer " + this.getAnalyzer().getClass() + " - tokens were added");
        }
        return nextToken == null ? null : super.getFuzzyQuery(field, nextToken, minSimilarity);
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean inclusive) throws ParseException {
        TokenStream source = this.getAnalyzer().tokenStream(field, (Reader)new StringReader(part1));
        TermAttribute termAtt = (TermAttribute)source.addAttribute(TermAttribute.class);
        boolean multipleTokens = false;
        try {
            if (source.incrementToken()) {
                part1 = termAtt.term();
            }
            multipleTokens = source.incrementToken();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (multipleTokens) {
            throw new ParseException("Cannot build RangeQuery with analyzer " + this.getAnalyzer().getClass() + " - tokens were added to part1");
        }
        source = this.getAnalyzer().tokenStream(field, (Reader)new StringReader(part2));
        termAtt = (TermAttribute)source.addAttribute(TermAttribute.class);
        try {
            if (source.incrementToken()) {
                part2 = termAtt.term();
            }
            multipleTokens = source.incrementToken();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (multipleTokens) {
            throw new ParseException("Cannot build RangeQuery with analyzer " + this.getAnalyzer().getClass() + " - tokens were added to part2");
        }
        return super.getRangeQuery(field, part1, part2, inclusive);
    }
}

