/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.OpenBitSet;

public class MultiPassIndexSplitter {
    public void split(IndexReader input, Directory[] outputs, boolean seq) throws IOException {
        if (outputs == null || outputs.length < 2) {
            throw new IOException("Invalid number of outputs.");
        }
        if (input == null || input.numDocs() < 2) {
            throw new IOException("Not enough documents for splitting");
        }
        int numParts = outputs.length;
        input = new FakeDeleteIndexReader((IndexReader)input);
        int maxDoc = input.maxDoc();
        int partLen = maxDoc / numParts;
        for (int i = 0; i < numParts; ++i) {
            input.undeleteAll();
            if (seq) {
                int j;
                int lo = partLen * i;
                int hi = lo + partLen;
                for (j = 0; j < lo; ++j) {
                    input.deleteDocument(j);
                }
                if (i < numParts - 1) {
                    for (j = hi; j < maxDoc; ++j) {
                        input.deleteDocument(j);
                    }
                }
            } else {
                for (int j = 0; j < maxDoc; ++j) {
                    if ((j + numParts - i) % numParts == 0) continue;
                    input.deleteDocument(j);
                }
            }
            IndexWriter w = new IndexWriter(outputs[i], (Analyzer)new WhitespaceAnalyzer(), true, IndexWriter.MaxFieldLength.UNLIMITED);
            System.err.println("Writing part " + (i + 1) + " ...");
            w.addIndexes(new IndexReader[]{input});
            w.close();
        }
        System.err.println("Done.");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 5) {
            System.err.println("Usage: MultiPassIndexSplitter -out <outputDir> -num <numParts> [-seq] <inputIndex1> [<inputIndex2 ...]");
            System.err.println("\tinputIndex\tpath to input index, multiple values are ok");
            System.err.println("\t-out ouputDir\tpath to output directory to contain partial indexes");
            System.err.println("\t-num numParts\tnumber of parts to produce");
            System.err.println("\t-seq\tsequential docid-range split (default is round-robin)");
            System.exit(-1);
        }
        ArrayList<IndexReader> indexes = new ArrayList<IndexReader>();
        String outDir = null;
        int numParts = -1;
        boolean seq = false;
        for (int i = 0; i < args.length; ++i) {
            FSDirectory dir;
            block14: {
                if (args[i].equals("-out")) {
                    outDir = args[++i];
                    continue;
                }
                if (args[i].equals("-num")) {
                    numParts = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-seq")) {
                    seq = true;
                    continue;
                }
                File file = new File(args[i]);
                if (!file.exists() || !file.isDirectory()) {
                    System.err.println("Invalid input path - skipping: " + file);
                    continue;
                }
                dir = FSDirectory.open((File)new File(args[i]));
                try {
                    if (!IndexReader.indexExists((Directory)dir)) {
                        System.err.println("Invalid input index - skipping: " + file);
                    }
                    break block14;
                }
                catch (Exception e) {
                    System.err.println("Invalid input index - skipping: " + file);
                }
                continue;
            }
            indexes.add(IndexReader.open((Directory)dir, (boolean)true));
        }
        if (outDir == null) {
            throw new Exception("Required argument missing: -out outputDir");
        }
        if (numParts < 2) {
            throw new Exception("Invalid value of required argument: -num numParts");
        }
        if (indexes.size() == 0) {
            throw new Exception("No input indexes to process");
        }
        File out = new File(outDir);
        if (!out.mkdirs()) {
            throw new Exception("Can't create output directory: " + out);
        }
        Directory[] dirs = new Directory[numParts];
        for (int i = 0; i < numParts; ++i) {
            dirs[i] = FSDirectory.open((File)new File(out, "part-" + i));
        }
        MultiPassIndexSplitter splitter = new MultiPassIndexSplitter();
        Object input = indexes.size() == 1 ? (IndexReader)indexes.get(0) : new MultiReader(indexes.toArray(new IndexReader[indexes.size()]));
        splitter.split((IndexReader)input, dirs, seq);
    }

    public static class FakeDeleteIndexReader
    extends FilterIndexReader {
        OpenBitSet dels;
        OpenBitSet oldDels = null;

        public FakeDeleteIndexReader(IndexReader in) {
            super(in);
            this.dels = new OpenBitSet((long)in.maxDoc());
            if (in.hasDeletions()) {
                this.oldDels = new OpenBitSet((long)in.maxDoc());
                for (int i = 0; i < in.maxDoc(); ++i) {
                    if (!in.isDeleted(i)) continue;
                    this.oldDels.set((long)i);
                }
                this.dels.or(this.oldDels);
            }
        }

        public int numDocs() {
            return this.in.maxDoc() - (int)this.dels.cardinality();
        }

        protected void doUndeleteAll() throws CorruptIndexException, IOException {
            this.dels = new OpenBitSet((long)this.in.maxDoc());
            if (this.oldDels != null) {
                this.dels.or(this.oldDels);
            }
        }

        protected void doDelete(int n) throws CorruptIndexException, IOException {
            this.dels.set((long)n);
        }

        public boolean hasDeletions() {
            return !this.dels.isEmpty();
        }

        public boolean isDeleted(int n) {
            return this.dels.get(n);
        }

        public TermPositions termPositions() throws IOException {
            return new FilterIndexReader.FilterTermPositions(this.in.termPositions()){

                public boolean next() throws IOException {
                    boolean res;
                    while ((res = super.next()) && FakeDeleteIndexReader.this.dels.get(this.doc())) {
                    }
                    return res;
                }
            };
        }
    }
}

