/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilterScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public final class FunctionScoreQuery
extends Query {
    private final Query in;
    private final DoubleValuesSource source;

    public FunctionScoreQuery(Query in, DoubleValuesSource source) {
        this.in = in;
        this.source = source;
    }

    public Query getWrappedQuery() {
        return this.in;
    }

    public static FunctionScoreQuery boostByValue(Query in, DoubleValuesSource boost) {
        return new FunctionScoreQuery(in, new MultiplicativeBoostValuesSource(boost));
    }

    public static FunctionScoreQuery boostByQuery(Query in, Query boostMatch, float boostValue) {
        return new FunctionScoreQuery(in, new MultiplicativeBoostValuesSource(new QueryBoostValuesSource(DoubleValuesSource.fromQuery((Query)boostMatch), boostValue)));
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        Weight inner = this.in.createWeight(searcher, needsScores && this.source.needsScores(), 1.0f);
        if (!needsScores) {
            return inner;
        }
        return new FunctionScoreWeight(this, inner, this.source.rewrite(searcher), boost);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.in.rewrite(reader);
        if (rewritten == this.in) {
            return this;
        }
        return new FunctionScoreQuery(rewritten, this.source);
    }

    public String toString(String field) {
        return "FunctionScoreQuery(" + this.in.toString(field) + ", scored by " + this.source.toString() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FunctionScoreQuery that = (FunctionScoreQuery)((Object)o);
        return Objects.equals(this.in, that.in) && Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(this.in, this.source);
    }

    private static class QueryBoostValuesSource
    extends DoubleValuesSource {
        private final DoubleValuesSource query;
        private final float boost;

        QueryBoostValuesSource(DoubleValuesSource query, float boost) {
            this.query = query;
            this.boost = boost;
        }

        public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            final DoubleValues in = this.query.getValues(ctx, null);
            return DoubleValues.withDefault((DoubleValues)new DoubleValues(){

                public double doubleValue() {
                    return boost;
                }

                public boolean advanceExact(int doc) throws IOException {
                    return in.advanceExact(doc);
                }
            }, (double)1.0);
        }

        public boolean needsScores() {
            return false;
        }

        public DoubleValuesSource rewrite(IndexSearcher reader) throws IOException {
            return new QueryBoostValuesSource(this.query.rewrite(reader), this.boost);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            QueryBoostValuesSource that = (QueryBoostValuesSource)((Object)o);
            return Float.compare(that.boost, this.boost) == 0 && Objects.equals(this.query, that.query);
        }

        public int hashCode() {
            return Objects.hash(this.query, Float.valueOf(this.boost));
        }

        public String toString() {
            return "queryboost(" + this.query + ")^" + this.boost;
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return this.query.isCacheable(ctx);
        }
    }

    private static class MultiplicativeBoostValuesSource
    extends DoubleValuesSource {
        private final DoubleValuesSource boost;

        private MultiplicativeBoostValuesSource(DoubleValuesSource boost) {
            this.boost = boost;
        }

        public DoubleValues getValues(LeafReaderContext ctx, final DoubleValues scores) throws IOException {
            final DoubleValues in = DoubleValues.withDefault((DoubleValues)this.boost.getValues(ctx, scores), (double)1.0);
            return new DoubleValues(){

                public double doubleValue() throws IOException {
                    return scores.doubleValue() * in.doubleValue();
                }

                public boolean advanceExact(int doc) throws IOException {
                    return in.advanceExact(doc);
                }
            };
        }

        public boolean needsScores() {
            return true;
        }

        public DoubleValuesSource rewrite(IndexSearcher reader) throws IOException {
            return new MultiplicativeBoostValuesSource(this.boost.rewrite(reader));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            MultiplicativeBoostValuesSource that = (MultiplicativeBoostValuesSource)((Object)o);
            return Objects.equals(this.boost, that.boost);
        }

        public int hashCode() {
            return Objects.hash(this.boost);
        }

        public String toString() {
            return "boost(" + this.boost.toString() + ")";
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return this.boost.isCacheable(ctx);
        }
    }

    private static class FunctionScoreWeight
    extends Weight {
        final Weight inner;
        final DoubleValuesSource valueSource;
        final float boost;

        FunctionScoreWeight(Query query, Weight inner, DoubleValuesSource valueSource, float boost) {
            super(query);
            this.inner = inner;
            this.valueSource = valueSource;
            this.boost = boost;
        }

        public void extractTerms(Set<Term> terms) {
            this.inner.extractTerms(terms);
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            Scorer scorer = this.inner.scorer(context);
            if (scorer.iterator().advance(doc) != doc) {
                return Explanation.noMatch((String)"No match", (Explanation[])new Explanation[0]);
            }
            Explanation scoreExplanation = this.inner.explain(context, doc);
            Explanation expl = this.valueSource.explain(context, doc, scoreExplanation);
            return Explanation.match((float)(expl.getValue() * this.boost), (String)"product of:", (Explanation[])new Explanation[]{Explanation.match((float)this.boost, (String)"boost", (Explanation[])new Explanation[0]), expl});
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            Scorer in = this.inner.scorer(context);
            if (in == null) {
                return null;
            }
            final DoubleValues scores = this.valueSource.getValues(context, DoubleValuesSource.fromScorer((Scorer)in));
            return new FilterScorer(in){

                public float score() throws IOException {
                    if (scores.advanceExact(this.docID())) {
                        return (float)(scores.doubleValue() * (double)boost);
                    }
                    return 0.0f;
                }
            };
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return this.inner.isCacheable(ctx) && this.valueSource.isCacheable(ctx);
        }
    }
}

