/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleFieldComparator;
import org.apache.lucene.search.SortField;

public abstract class ValueSource {
    public abstract FunctionValues getValues(Map var1, LeafReaderContext var2) throws IOException;

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String description();

    public String toString() {
        return this.description();
    }

    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
    }

    public static Map newContext(IndexSearcher searcher) {
        IdentityHashMap<String, IndexSearcher> context = new IdentityHashMap<String, IndexSearcher>();
        context.put("searcher", searcher);
        return context;
    }

    public LongValuesSource asLongValuesSource() {
        return new WrappedLongValuesSource(this);
    }

    public DoubleValuesSource asDoubleValuesSource() {
        return new WrappedDoubleValuesSource(this);
    }

    public static ValueSource fromDoubleValuesSource(DoubleValuesSource in) {
        return new FromDoubleValuesSource(in);
    }

    public SortField getSortField(boolean reverse) {
        return new ValueSourceSortField(reverse);
    }

    class ValueSourceComparator
    extends SimpleFieldComparator<Double> {
        private final double[] values;
        private FunctionValues docVals;
        private double bottom;
        private final Map fcontext;
        private double topValue;

        ValueSourceComparator(Map fcontext, int numHits) {
            this.fcontext = fcontext;
            this.values = new double[numHits];
        }

        public int compare(int slot1, int slot2) {
            return Double.compare(this.values[slot1], this.values[slot2]);
        }

        public int compareBottom(int doc) throws IOException {
            return Double.compare(this.bottom, this.docVals.doubleVal(doc));
        }

        public void copy(int slot, int doc) throws IOException {
            this.values[slot] = this.docVals.doubleVal(doc);
        }

        public void doSetNextReader(LeafReaderContext context) throws IOException {
            this.docVals = ValueSource.this.getValues(this.fcontext, context);
        }

        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        public void setTopValue(Double value) {
            this.topValue = value;
        }

        public Double value(int slot) {
            return this.values[slot];
        }

        public int compareTop(int doc) throws IOException {
            double docValue = this.docVals.doubleVal(doc);
            return Double.compare(this.topValue, docValue);
        }
    }

    class ValueSourceComparatorSource
    extends FieldComparatorSource {
        private final Map context;

        public ValueSourceComparatorSource(Map context) {
            this.context = context;
        }

        public FieldComparator<Double> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) {
            return new ValueSourceComparator(this.context, numHits);
        }
    }

    class ValueSourceSortField
    extends SortField {
        public ValueSourceSortField(boolean reverse) {
            super(ValueSource.this.description(), SortField.Type.REWRITEABLE, reverse);
        }

        public SortField rewrite(IndexSearcher searcher) throws IOException {
            Map context = ValueSource.newContext(searcher);
            ValueSource.this.createWeight(context, searcher);
            return new SortField(this.getField(), (FieldComparatorSource)new ValueSourceComparatorSource(context), this.getReverse());
        }
    }

    private static class FromDoubleValuesSource
    extends ValueSource {
        final DoubleValuesSource in;

        private FromDoubleValuesSource(DoubleValuesSource in) {
            this.in = in;
        }

        @Override
        public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
            Scorer scorer = (Scorer)context.get("scorer");
            DoubleValues scores = scorer == null ? null : DoubleValuesSource.fromScorer((Scorable)scorer);
            IndexSearcher searcher = (IndexSearcher)context.get("searcher");
            final DoubleValues inner = searcher != null ? this.in.rewrite(searcher).getValues(readerContext, scores) : this.in.getValues(readerContext, scores);
            return new FunctionValues(){

                @Override
                public String toString(int doc) throws IOException {
                    return in.toString();
                }

                @Override
                public float floatVal(int doc) throws IOException {
                    if (!inner.advanceExact(doc)) {
                        return 0.0f;
                    }
                    return (float)inner.doubleValue();
                }

                @Override
                public double doubleVal(int doc) throws IOException {
                    if (!inner.advanceExact(doc)) {
                        return 0.0;
                    }
                    return inner.doubleValue();
                }

                @Override
                public boolean exists(int doc) throws IOException {
                    return inner.advanceExact(doc);
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FromDoubleValuesSource that = (FromDoubleValuesSource)o;
            return Objects.equals(this.in, that.in);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.in);
        }

        @Override
        public String description() {
            return this.in.toString();
        }
    }

    private static class WrappedDoubleValuesSource
    extends DoubleValuesSource {
        private final ValueSource in;
        private IndexSearcher searcher;

        private WrappedDoubleValuesSource(ValueSource in) {
            this.in = in;
        }

        public DoubleValues getValues(LeafReaderContext ctx, final DoubleValues scores) throws IOException {
            HashMap<String, ScoreAndDoc> context = new HashMap<String, ScoreAndDoc>();
            final ScoreAndDoc scorer = new ScoreAndDoc();
            context.put("scorer", scorer);
            context.put("searcher", (ScoreAndDoc)this.searcher);
            final FunctionValues fv = this.in.getValues(context, ctx);
            return new DoubleValues(){

                public double doubleValue() throws IOException {
                    return fv.doubleVal(scorer.current);
                }

                public boolean advanceExact(int doc) throws IOException {
                    scorer.current = doc;
                    scorer.score = scores != null && scores.advanceExact(doc) ? (float)scores.doubleValue() : 0.0f;
                    return true;
                }
            };
        }

        public boolean needsScores() {
            return true;
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }

        public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) throws IOException {
            HashMap<String, ScoreAndDoc> context = new HashMap<String, ScoreAndDoc>();
            ScoreAndDoc scorer = new ScoreAndDoc();
            scorer.score = scoreExplanation.getValue().floatValue();
            context.put("scorer", scorer);
            context.put("searcher", (ScoreAndDoc)this.searcher);
            FunctionValues fv = this.in.getValues(context, ctx);
            return fv.explain(docId);
        }

        public DoubleValuesSource rewrite(IndexSearcher searcher) throws IOException {
            this.searcher = searcher;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            WrappedDoubleValuesSource that = (WrappedDoubleValuesSource)((Object)o);
            return Objects.equals(this.in, that.in);
        }

        public int hashCode() {
            return Objects.hash(this.in);
        }

        public String toString() {
            return this.in.toString();
        }
    }

    private static class WrappedLongValuesSource
    extends LongValuesSource {
        private final ValueSource in;

        private WrappedLongValuesSource(ValueSource in) {
            this.in = in;
        }

        public LongValues getValues(LeafReaderContext ctx, final DoubleValues scores) throws IOException {
            IdentityHashMap<String, ScoreAndDoc> context = new IdentityHashMap<String, ScoreAndDoc>();
            final ScoreAndDoc scorer = new ScoreAndDoc();
            context.put("scorer", scorer);
            final FunctionValues fv = this.in.getValues(context, ctx);
            return new LongValues(){

                public long longValue() throws IOException {
                    return fv.longVal(scorer.current);
                }

                public boolean advanceExact(int doc) throws IOException {
                    scorer.current = doc;
                    scorer.score = scores != null && scores.advanceExact(doc) ? (float)scores.doubleValue() : 0.0f;
                    return fv.exists(doc);
                }
            };
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }

        public boolean needsScores() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            WrappedLongValuesSource that = (WrappedLongValuesSource)((Object)o);
            return Objects.equals(this.in, that.in);
        }

        public int hashCode() {
            return Objects.hash(this.in);
        }

        public String toString() {
            return this.in.toString();
        }

        public LongValuesSource rewrite(IndexSearcher searcher) throws IOException {
            return this;
        }
    }

    private static class ScoreAndDoc
    extends Scorable {
        int current = -1;
        float score = 0.0f;

        private ScoreAndDoc() {
        }

        public int docID() {
            return this.current;
        }

        public float score() {
            return this.score;
        }
    }
}

