/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FilterMatchesIterator;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.intervals.ConjunctionIntervalsSource;
import org.apache.lucene.search.intervals.IntervalFunction;
import org.apache.lucene.search.intervals.IntervalIterator;
import org.apache.lucene.search.intervals.IntervalMatches;
import org.apache.lucene.search.intervals.IntervalsSource;
import org.apache.lucene.util.ArrayUtil;

class MinimizingConjunctionIntervalsSource
extends ConjunctionIntervalsSource {
    MinimizingConjunctionIntervalsSource(List<IntervalsSource> subSources, IntervalFunction function) {
        super(subSources, function);
    }

    @Override
    public MatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
        ArrayList<CacheingMatchesIterator> subs = new ArrayList<CacheingMatchesIterator>();
        for (IntervalsSource source : this.subSources) {
            MatchesIterator mi = source.matches(field, ctx, doc);
            if (mi == null) {
                return null;
            }
            subs.add(new CacheingMatchesIterator(mi));
        }
        IntervalIterator it = this.function.apply(subs.stream().map(m -> IntervalMatches.wrapMatches((MatchesIterator)m, doc)).collect(Collectors.toList()));
        if (it.advance(doc) != doc) {
            return null;
        }
        if (it.nextInterval() == Integer.MAX_VALUE) {
            return null;
        }
        return new ConjunctionMatchesIterator(it, subs);
    }

    private static class CacheingMatchesIterator
    extends FilterMatchesIterator {
        boolean positioned = false;
        int[] posAndOffsets = new int[16];
        int count = 0;

        CacheingMatchesIterator(MatchesIterator in) {
            super(in);
        }

        private void cache() throws IOException {
            this.count = 0;
            MatchesIterator mi = this.in.getSubMatches();
            if (mi == null) {
                this.count = 1;
                this.posAndOffsets[0] = this.in.startPosition();
                this.posAndOffsets[1] = this.in.endPosition();
                this.posAndOffsets[2] = this.in.startOffset();
                this.posAndOffsets[3] = this.in.endOffset();
            } else {
                while (mi.next()) {
                    if (this.count * 4 >= this.posAndOffsets.length) {
                        this.posAndOffsets = ArrayUtil.grow((int[])this.posAndOffsets, (int)((this.count + 1) * 4));
                    }
                    this.posAndOffsets[this.count * 4] = mi.startPosition();
                    this.posAndOffsets[this.count * 4 + 1] = mi.endPosition();
                    this.posAndOffsets[this.count * 4 + 2] = mi.startOffset();
                    this.posAndOffsets[this.count * 4 + 3] = mi.endOffset();
                    ++this.count;
                }
            }
        }

        public boolean next() throws IOException {
            if (!this.positioned) {
                this.positioned = true;
            } else {
                this.cache();
            }
            return this.in.next();
        }

        int startOffset(int endPos) throws IOException {
            if (this.endPosition() <= endPos) {
                return this.in.startOffset();
            }
            return this.posAndOffsets[2];
        }

        int endOffset(int endPos) throws IOException {
            if (this.endPosition() <= endPos) {
                return this.in.endOffset();
            }
            return this.posAndOffsets[this.count * 4 + 3];
        }

        MatchesIterator getSubMatches(int endPos) throws IOException {
            if (this.endPosition() <= endPos) {
                this.cache();
            }
            return new MatchesIterator(){
                int upto = -1;

                public boolean next() {
                    ++this.upto;
                    return this.upto < count;
                }

                public int startPosition() {
                    return posAndOffsets[this.upto * 4];
                }

                public int endPosition() {
                    return posAndOffsets[this.upto * 4 + 1];
                }

                public int startOffset() {
                    return posAndOffsets[this.upto * 4 + 2];
                }

                public int endOffset() {
                    return posAndOffsets[this.upto * 4 + 3];
                }

                public MatchesIterator getSubMatches() {
                    return null;
                }

                public Query getQuery() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class ConjunctionMatchesIterator
    implements MatchesIterator {
        final IntervalIterator iterator;
        final List<CacheingMatchesIterator> subs;
        boolean cached = true;

        private ConjunctionMatchesIterator(IntervalIterator iterator, List<CacheingMatchesIterator> subs) {
            this.iterator = iterator;
            this.subs = subs;
        }

        public boolean next() throws IOException {
            if (this.cached) {
                this.cached = false;
                return true;
            }
            return this.iterator.nextInterval() != Integer.MAX_VALUE;
        }

        public int startPosition() {
            return this.iterator.start();
        }

        public int endPosition() {
            return this.iterator.end();
        }

        public int startOffset() throws IOException {
            int start = Integer.MAX_VALUE;
            int endPos = this.endPosition();
            for (CacheingMatchesIterator s : this.subs) {
                start = Math.min(start, s.startOffset(endPos));
            }
            return start;
        }

        public int endOffset() throws IOException {
            int end = 0;
            int endPos = this.endPosition();
            for (CacheingMatchesIterator s : this.subs) {
                end = Math.max(end, s.endOffset(endPos));
            }
            return end;
        }

        public MatchesIterator getSubMatches() throws IOException {
            ArrayList<MatchesIterator> mis = new ArrayList<MatchesIterator>();
            int endPos = this.endPosition();
            for (CacheingMatchesIterator s : this.subs) {
                mis.add(s.getSubMatches(endPos));
            }
            return MatchesUtils.disjunction(mis);
        }

        public Query getQuery() {
            return null;
        }
    }
}

