/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.intervals.DifferenceIntervalFunction;
import org.apache.lucene.search.intervals.IntervalIterator;
import org.apache.lucene.search.intervals.IntervalMatches;
import org.apache.lucene.search.intervals.IntervalsSource;

class DifferenceIntervalsSource
extends IntervalsSource {
    private final IntervalsSource minuend;
    private final IntervalsSource subtrahend;
    private final DifferenceIntervalFunction function;

    DifferenceIntervalsSource(IntervalsSource minuend, IntervalsSource subtrahend, DifferenceIntervalFunction function) {
        this.minuend = minuend;
        this.subtrahend = subtrahend;
        this.function = function;
    }

    @Override
    public IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
        IntervalIterator minIt = this.minuend.intervals(field, ctx);
        if (minIt == null) {
            return null;
        }
        IntervalIterator subIt = this.subtrahend.intervals(field, ctx);
        if (subIt == null) {
            return minIt;
        }
        return this.function.apply(minIt, subIt);
    }

    @Override
    public MatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
        MatchesIterator minIt = this.minuend.matches(field, ctx, doc);
        if (minIt == null) {
            return null;
        }
        MatchesIterator subIt = this.subtrahend.matches(field, ctx, doc);
        if (subIt == null) {
            return minIt;
        }
        IntervalIterator difference = this.function.apply(IntervalMatches.wrapMatches(minIt, doc), IntervalMatches.wrapMatches(subIt, doc));
        return IntervalMatches.asMatches(difference, minIt, doc);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DifferenceIntervalsSource that = (DifferenceIntervalsSource)o;
        return Objects.equals(this.minuend, that.minuend) && Objects.equals(this.subtrahend, that.subtrahend) && Objects.equals(this.function, that.function);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.minuend, this.subtrahend, this.function);
    }

    @Override
    public String toString() {
        return this.function + "(" + this.minuend + ", " + this.subtrahend + ")";
    }

    @Override
    public void extractTerms(String field, Set<Term> terms) {
        this.minuend.extractTerms(field, terms);
    }

    @Override
    public int minExtent() {
        return this.minuend.minExtent();
    }
}

