/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.analyzing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.analyzing.AnalyzingInfixSuggester;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;

public class BlendedInfixSuggester
extends AnalyzingInfixSuggester {
    protected static double LINEAR_COEF = 0.1;
    public static int DEFAULT_NUM_FACTOR = 10;
    private final int numFactor;
    private final BlenderType blenderType;
    private static Comparator<Lookup.LookupResult> LOOKUP_COMP = new LookUpComparator();

    public BlendedInfixSuggester(Version matchVersion, Directory dir, Analyzer analyzer) throws IOException {
        super(matchVersion, dir, analyzer);
        this.blenderType = BlenderType.POSITION_LINEAR;
        this.numFactor = DEFAULT_NUM_FACTOR;
    }

    public BlendedInfixSuggester(Version matchVersion, Directory dir, Analyzer indexAnalyzer, Analyzer queryAnalyzer, int minPrefixChars, BlenderType blenderType, int numFactor) throws IOException {
        super(matchVersion, dir, indexAnalyzer, queryAnalyzer, minPrefixChars);
        this.blenderType = blenderType;
        this.numFactor = numFactor;
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, Set<BytesRef> contexts, boolean onlyMorePopular, int num) throws IOException {
        return super.lookup(key, contexts, onlyMorePopular, num * this.numFactor);
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, Set<BytesRef> contexts, int num, boolean allTermsRequired, boolean doHighlight) throws IOException {
        return super.lookup(key, contexts, num * this.numFactor, allTermsRequired, doHighlight);
    }

    @Override
    protected FieldType getTextFieldType() {
        FieldType ft = new FieldType(TextField.TYPE_NOT_STORED);
        ft.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        ft.setStoreTermVectors(true);
        ft.setStoreTermVectorPositions(true);
        ft.setOmitNorms(true);
        return ft;
    }

    @Override
    protected List<Lookup.LookupResult> createResults(IndexSearcher searcher, TopFieldDocs hits, int num, CharSequence key, boolean doHighlight, Set<String> matchedTokens, String prefixToken) throws IOException {
        BinaryDocValues textDV = MultiDocValues.getBinaryValues((IndexReader)searcher.getIndexReader(), (String)"text");
        assert (textDV != null);
        BinaryDocValues payloadsDV = MultiDocValues.getBinaryValues((IndexReader)searcher.getIndexReader(), (String)"payloads");
        TreeSet<Lookup.LookupResult> results = new TreeSet<Lookup.LookupResult>(LOOKUP_COMP);
        int actualNum = num / this.numFactor;
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            Lookup.LookupResult result;
            FieldDoc fd = (FieldDoc)hits.scoreDocs[i];
            String text = textDV.get(fd.doc).utf8ToString();
            long weight = (Long)fd.fields[0];
            BytesRef payload = payloadsDV != null ? BytesRef.deepCopyOf((BytesRef)payloadsDV.get(fd.doc)) : null;
            double coefficient = text.startsWith(key.toString()) ? 1.0 : this.createCoefficient(searcher, fd.doc, matchedTokens, prefixToken);
            long score = (long)((double)weight * coefficient);
            if (doHighlight) {
                Object highlightKey = this.highlight(text, matchedTokens, prefixToken);
                result = new Lookup.LookupResult((CharSequence)highlightKey.toString(), highlightKey, score, payload);
            } else {
                result = new Lookup.LookupResult((CharSequence)text, score, payload);
            }
            BlendedInfixSuggester.boundedTreeAdd(results, result, actualNum);
        }
        return new ArrayList<Lookup.LookupResult>(results.descendingSet());
    }

    private static void boundedTreeAdd(TreeSet<Lookup.LookupResult> results, Lookup.LookupResult result, int num) {
        if (results.size() >= num) {
            if (results.first().value < result.value) {
                results.pollFirst();
            } else {
                return;
            }
        }
        results.add(result);
    }

    private double createCoefficient(IndexSearcher searcher, int doc, Set<String> matchedTokens, String prefixToken) throws IOException {
        BytesRef term;
        Terms tv = searcher.getIndexReader().getTermVector(doc, "text");
        TermsEnum it = tv.iterator(TermsEnum.EMPTY);
        Integer position = Integer.MAX_VALUE;
        while ((term = it.next()) != null) {
            String docTerm = term.utf8ToString();
            if (!matchedTokens.contains(docTerm) && !docTerm.startsWith(prefixToken)) continue;
            DocsAndPositionsEnum docPosEnum = it.docsAndPositions(null, null, 1);
            docPosEnum.nextDoc();
            int p = docPosEnum.nextPosition();
            if (p >= position) continue;
            position = p;
        }
        return this.calculateCoefficient(position);
    }

    protected double calculateCoefficient(int position) {
        double coefficient;
        switch (this.blenderType) {
            case POSITION_LINEAR: {
                coefficient = 1.0 - LINEAR_COEF * (double)position;
                break;
            }
            case POSITION_RECIPROCAL: {
                coefficient = 1.0 / (double)(position + 1);
                break;
            }
            default: {
                coefficient = 1.0;
            }
        }
        return coefficient;
    }

    private static class LookUpComparator
    implements Comparator<Lookup.LookupResult> {
        private LookUpComparator() {
        }

        @Override
        public int compare(Lookup.LookupResult o1, Lookup.LookupResult o2) {
            if (o1.value > o2.value) {
                return 1;
            }
            if (o1.value < o2.value) {
                return -1;
            }
            return Lookup.CHARSEQUENCE_COMPARATOR.compare(o1.key, o2.key);
        }
    }

    public static enum BlenderType {
        CUSTOM,
        POSITION_LINEAR,
        POSITION_RECIPROCAL;

    }
}

