/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.regex;

import org.apache.commons.cli2.Option;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.utils.regex.FPGFormatter;
import org.apache.mahout.utils.regex.RegexMapper;
import org.apache.mahout.utils.regex.URLDecodeTransformer;

public class RegexConverterDriver
extends AbstractJob {
    public int run(String[] args) throws Exception {
        Class analyzerClass;
        String formatter;
        String trans;
        this.addInputOption();
        this.addOutputOption();
        this.addOption((Option)DefaultOptionCreator.overwriteOption().create());
        this.addOption("regex", "regex", "The regular expression to use", true);
        this.addOption("groupsToKeep", "g", "The number of the capturing groups to keep", false);
        this.addOption("transformerClass", "t", "The optional class specifying the Regex Transformer", false);
        this.addOption("formatterClass", "t", "The optional class specifying the Regex Formatter", false);
        this.addOption((Option)DefaultOptionCreator.analyzerOption().create());
        if (this.parseArguments(args) == null) {
            return -1;
        }
        Configuration conf = this.getConf();
        conf.set("regex", this.getOption("regex"));
        String gtk = this.getOption("groupsToKeep");
        if (gtk != null) {
            conf.set("regex.groups", gtk);
        }
        if ((trans = this.getOption("transformerClass")) != null) {
            if ("url".equalsIgnoreCase(trans)) {
                trans = URLDecodeTransformer.class.getName();
            }
            conf.set("transformer.class", trans);
        }
        if ((formatter = this.getOption("formatterClass")) != null) {
            if ("fpg".equalsIgnoreCase(formatter)) {
                formatter = FPGFormatter.class.getName();
            }
            conf.set("formatter.class", formatter);
        }
        Path input = this.getInputPath();
        Path output = this.getOutputPath();
        if (this.hasOption("overwrite")) {
            HadoopUtil.delete((Configuration)this.getConf(), (Path[])new Path[]{output});
        }
        if ((analyzerClass = this.getAnalyzerClassFromOption()) != null) {
            conf.set("analyzerName", analyzerClass.getName());
        }
        Job job = this.prepareJob(input, output, TextInputFormat.class, RegexMapper.class, LongWritable.class, Text.class, TextOutputFormat.class);
        job.waitForCompletion(true);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new RegexConverterDriver(), (String[])args);
    }
}

