/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors;

import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.cli2.util.HelpFormatter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterable;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.utils.vectors.VectorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VectorDumper {
    private static final Logger log = LoggerFactory.getLogger(VectorDumper.class);

    private VectorDumper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block25: {
            DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
            ArgumentBuilder abuilder = new ArgumentBuilder();
            GroupBuilder gbuilder = new GroupBuilder();
            DefaultOption seqOpt = obuilder.withLongName("seqFile").withRequired(false).withArgument(abuilder.withName("seqFile").withMinimum(1).withMaximum(1).create()).withDescription("The Sequence File containing the Vectors").withShortName("s").create();
            DefaultOption vectorAsKeyOpt = obuilder.withLongName("useKey").withRequired(false).withDescription("If the Key is a vector, then dump that instead").withShortName("u").create();
            DefaultOption printKeyOpt = obuilder.withLongName("printKey").withRequired(false).withDescription("Print out the key as well, delimited by a tab (or the value if useKey is true)").withShortName("p").create();
            DefaultOption outputOpt = obuilder.withLongName("output").withRequired(false).withArgument(abuilder.withName("output").withMinimum(1).withMaximum(1).create()).withDescription("The output file.  If not specified, dumps to the console").withShortName("o").create();
            DefaultOption dictOpt = obuilder.withLongName("dictionary").withRequired(false).withArgument(abuilder.withName("dictionary").withMinimum(1).withMaximum(1).create()).withDescription("The dictionary file. ").withShortName("d").create();
            DefaultOption dictTypeOpt = obuilder.withLongName("dictionaryType").withRequired(false).withArgument(abuilder.withName("dictionaryType").withMinimum(1).withMaximum(1).create()).withDescription("The dictionary file type (text|sequencefile)").withShortName("dt").create();
            DefaultOption csvOpt = obuilder.withLongName("csv").withRequired(false).withDescription("Output the Vector as CSV.  Otherwise it substitutes in the terms for vector cell entries").withShortName("c").create();
            DefaultOption namesAsCommentsOpt = obuilder.withLongName("namesAsComments").withRequired(false).withDescription("If using CSV output, optionally add a comment line for each NamedVector (if the vector is one) printing out the name").withShortName("n").create();
            DefaultOption sortVectorsOpt = obuilder.withLongName("sortVectors").withRequired(false).withDescription("Sort output key/value pairs of the vector entries in abs magnitude descending order").withShortName("sort").create();
            DefaultOption sizeOpt = obuilder.withLongName("sizeOnly").withRequired(false).withDescription("Dump only the size of the vector").withShortName("sz").create();
            DefaultOption numItemsOpt = obuilder.withLongName("numItems").withRequired(false).withArgument(abuilder.withName("n").withMinimum(1).withMaximum(1).create()).withDescription("Output at most <n> vecors").withShortName("n").create();
            DefaultOption numIndexesPerVectorOpt = obuilder.withLongName("vectorSize").withShortName("vs").withRequired(false).withArgument(abuilder.withName("vs").withMinimum(1).withMaximum(1).create()).withDescription("Truncate vectors to <vs> length when dumping (most useful when in conjunction with -sort").create();
            DefaultOption filtersOpt = obuilder.withLongName("filter").withRequired(false).withArgument(abuilder.withName("filter").withMinimum(1).withMaximum(100).create()).withDescription("Only dump out those vectors whose name matches the filter.  Multiple items may be specified by repeating the argument.").withShortName("fi").create();
            DefaultOption helpOpt = obuilder.withLongName("help").withDescription("Print out help").withShortName("h").create();
            Group group = gbuilder.withName("Options").withOption((Option)seqOpt).withOption((Option)outputOpt).withOption((Option)dictTypeOpt).withOption((Option)dictOpt).withOption((Option)csvOpt).withOption((Option)vectorAsKeyOpt).withOption((Option)printKeyOpt).withOption((Option)sortVectorsOpt).withOption((Option)filtersOpt).withOption((Option)helpOpt).withOption((Option)numItemsOpt).withOption((Option)sizeOpt).withOption((Option)numIndexesPerVectorOpt).create();
            try {
                Writer writer;
                boolean shouldClose;
                Parser parser = new Parser();
                parser.setGroup(group);
                CommandLine cmdLine = parser.parse(args);
                if (cmdLine.hasOption((Option)helpOpt)) {
                    CommandLineUtil.printHelpWithGenericOptions((Group)group);
                    return;
                }
                if (!cmdLine.hasOption((Option)seqOpt)) break block25;
                Configuration conf = new Configuration();
                Path pathPattern = new Path(cmdLine.getValue((Option)seqOpt).toString());
                FileSystem fs = FileSystem.get((Configuration)conf);
                FileStatus[] inputPaths = fs.globStatus(pathPattern);
                String dictionaryType = "text";
                if (cmdLine.hasOption((Option)dictTypeOpt)) {
                    dictionaryType = cmdLine.getValue((Option)dictTypeOpt).toString();
                }
                boolean sortVectors = cmdLine.hasOption((Option)sortVectorsOpt);
                log.info("Sort? " + sortVectors);
                String[] dictionary = null;
                if (cmdLine.hasOption((Option)dictOpt)) {
                    if ("text".equals(dictionaryType)) {
                        dictionary = VectorHelper.loadTermDictionary(new File(cmdLine.getValue((Option)dictOpt).toString()));
                    } else if ("sequencefile".equals(dictionaryType)) {
                        dictionary = VectorHelper.loadTermDictionary(conf, cmdLine.getValue((Option)dictOpt).toString());
                    } else {
                        throw new OptionException((Option)dictTypeOpt);
                    }
                }
                HashSet filters = cmdLine.hasOption((Option)filtersOpt) ? new HashSet(cmdLine.getValues((Option)filtersOpt)) : null;
                boolean useCSV = cmdLine.hasOption((Option)csvOpt);
                boolean sizeOnly = cmdLine.hasOption((Option)sizeOpt);
                boolean namesAsComments = cmdLine.hasOption((Option)namesAsCommentsOpt);
                boolean transposeKeyValue = cmdLine.hasOption((Option)vectorAsKeyOpt);
                if (cmdLine.hasOption((Option)outputOpt)) {
                    shouldClose = true;
                    writer = Files.newWriter((File)new File(cmdLine.getValue((Option)outputOpt).toString()), (Charset)Charsets.UTF_8);
                } else {
                    shouldClose = false;
                    writer = new OutputStreamWriter(System.out);
                }
                try {
                    boolean printKey = cmdLine.hasOption((Option)printKeyOpt);
                    if (useCSV && dictionary != null) {
                        writer.write("#");
                        for (int j = 0; j < dictionary.length; ++j) {
                            writer.write(dictionary[j]);
                            if (j >= dictionary.length - 1) continue;
                            writer.write(44);
                        }
                        writer.write(10);
                    }
                    Long numItems = null;
                    if (cmdLine.hasOption((Option)numItemsOpt)) {
                        numItems = Long.parseLong(cmdLine.getValue((Option)numItemsOpt).toString());
                        writer.append("#Max Items to dump: ").append(String.valueOf(numItems)).append('\n');
                    }
                    int maxIndexesPerVector = cmdLine.hasOption((Option)numIndexesPerVectorOpt) ? Integer.parseInt(cmdLine.getValue((Option)numIndexesPerVectorOpt).toString()) : Integer.MAX_VALUE;
                    long itemCount = 0L;
                    int fileCount = 0;
                    for (FileStatus stat : inputPaths) {
                        if (numItems != null && numItems <= itemCount) break;
                        Path path = stat.getPath();
                        log.info("Processing file '{}' ({}/{})", new Object[]{path, ++fileCount, inputPaths.length});
                        SequenceFileIterable iterable = new SequenceFileIterable(path, true, conf);
                        Iterator iterator = iterable.iterator();
                        long i = 0L;
                        while (iterator.hasNext() && (numItems == null || itemCount < numItems)) {
                            Pair record = (Pair)iterator.next();
                            Writable keyWritable = (Writable)record.getFirst();
                            Writable valueWritable = (Writable)record.getSecond();
                            if (printKey) {
                                Writable notTheVectorWritable = transposeKeyValue ? valueWritable : keyWritable;
                                writer.write(notTheVectorWritable.toString());
                                writer.write(9);
                            }
                            VectorWritable vectorWritable = (VectorWritable)(transposeKeyValue ? keyWritable : valueWritable);
                            Vector vector = vectorWritable.get();
                            if (filters != null && vector instanceof NamedVector && !filters.contains(((NamedVector)vector).getName())) continue;
                            if (sizeOnly) {
                                if (vector instanceof NamedVector) {
                                    writer.write(((NamedVector)vector).getName());
                                    writer.write(":");
                                } else {
                                    writer.write(String.valueOf(i++));
                                    writer.write(":");
                                }
                                writer.write(String.valueOf(vector.size()));
                                writer.write(10);
                            } else {
                                String fmtStr = useCSV ? VectorHelper.vectorToCSVString(vector, namesAsComments) : VectorHelper.vectorToJson(vector, dictionary, maxIndexesPerVector, sortVectors);
                                writer.write(fmtStr);
                                writer.write(10);
                            }
                            ++itemCount;
                        }
                    }
                    writer.flush();
                }
                finally {
                    if (shouldClose) {
                        Closeables.closeQuietly((Closeable)writer);
                    }
                }
            }
            catch (OptionException e) {
                log.error("Exception", (Throwable)e);
                VectorDumper.printHelp(group);
            }
        }
    }

    private static void printHelp(Group group) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setGroup(group);
        formatter.print();
    }
}

