/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.clustering;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.Text;
import org.apache.mahout.clustering.AbstractCluster;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.classify.WeightedPropertyVectorWritable;
import org.apache.mahout.clustering.classify.WeightedVectorWritable;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.math.Vector;
import org.apache.mahout.utils.clustering.AbstractClusterWriter;

public class ClusterDumperWriter
extends AbstractClusterWriter {
    private final int subString;
    private final String[] dictionary;
    private final int numTopFeatures;

    public ClusterDumperWriter(Writer writer, Map<Integer, List<WeightedVectorWritable>> clusterIdToPoints, DistanceMeasure measure, int numTopFeatures, String[] dictionary, int subString) {
        super(writer, clusterIdToPoints, measure);
        this.numTopFeatures = numTopFeatures;
        this.dictionary = dictionary;
        this.subString = subString;
    }

    @Override
    public void write(ClusterWritable clusterWritable) throws IOException {
        Map<Integer, List<WeightedVectorWritable>> clusterIdToPoints;
        List<WeightedVectorWritable> points;
        Cluster cluster = clusterWritable.getValue();
        String fmtStr = cluster.asFormatString(this.dictionary);
        Writer writer = this.getWriter();
        if (this.subString > 0 && fmtStr.length() > this.subString) {
            writer.write(58);
            writer.write(fmtStr, 0, Math.min(this.subString, fmtStr.length()));
        } else {
            writer.write(fmtStr);
        }
        writer.write(10);
        if (this.dictionary != null) {
            String topTerms = ClusterDumperWriter.getTopFeatures(clusterWritable.getValue().getCenter(), this.dictionary, this.numTopFeatures);
            writer.write("\tTop Terms: ");
            writer.write(topTerms);
            writer.write(10);
        }
        if ((points = (clusterIdToPoints = this.getClusterIdToPoints()).get(clusterWritable.getValue().getId())) != null) {
            writer.write("\tWeight : [props - optional]:  Point:\n\t");
            Iterator<WeightedVectorWritable> iterator = points.iterator();
            while (iterator.hasNext()) {
                WeightedVectorWritable point = iterator.next();
                writer.write(String.valueOf(point.getWeight()));
                if (point instanceof WeightedPropertyVectorWritable) {
                    WeightedPropertyVectorWritable tmp = (WeightedPropertyVectorWritable)point;
                    Map map = tmp.getProperties();
                    writer.write(" : [");
                    if (map != null) {
                        for (Map.Entry entry : map.entrySet()) {
                            writer.write(((Text)entry.getKey()).toString());
                            writer.write("=");
                            writer.write(((Text)entry.getValue()).toString());
                        }
                    }
                    writer.write("]");
                }
                writer.write(": ");
                writer.write(AbstractCluster.formatVector((Vector)point.getVector(), (String[])this.dictionary));
                if (!iterator.hasNext()) continue;
                writer.write("\n\t");
            }
            writer.write(10);
        }
    }
}

