/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors.csv;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVStrategy;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;

public class CSVVectorIterator
extends AbstractIterator<Vector> {
    private final CSVParser parser;

    public CSVVectorIterator(Reader reader) {
        this.parser = new CSVParser(reader);
    }

    public CSVVectorIterator(Reader reader, CSVStrategy strategy) {
        this.parser = new CSVParser(reader, strategy);
    }

    protected Vector computeNext() {
        String[] line;
        try {
            line = this.parser.getLine();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (line == null) {
            return (Vector)this.endOfData();
        }
        DenseVector result = new DenseVector(line.length);
        for (int i = 0; i < line.length; ++i) {
            result.setQuick(i, Double.parseDouble(line[i]));
        }
        return result;
    }
}

