/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.email;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.mahout.common.iterator.FileLineIterable;
import org.apache.mahout.utils.email.MailOptions;
import org.apache.mahout.utils.io.ChunkedWrapper;
import org.apache.mahout.utils.io.ChunkedWriter;
import org.apache.mahout.utils.io.IOWriterWrapper;
import org.apache.mahout.utils.io.WrappedWriter;

public class MailProcessor {
    private static final Pattern MESSAGE_START = Pattern.compile("^From \\S+@\\S.*\\d{4}$", 2);
    private static final Pattern MESSAGE_ID_PREFIX = Pattern.compile("^message-id: <(.*)>$", 2);
    public static final Pattern SUBJECT_PREFIX = Pattern.compile("^subject: (.*)$", 2);
    public static final Pattern FROM_PREFIX = Pattern.compile("^from: (\\S.*)$", 2);
    public static final Pattern REFS_PREFIX = Pattern.compile("^references: (.*)$", 2);
    public static final Pattern TO_PREFIX = Pattern.compile("^to: (.*)$", 2);
    private final String prefix;
    private final MailOptions options;
    private final WrappedWriter writer;

    public MailProcessor(MailOptions options, String prefix, Writer writer) {
        this.writer = new IOWriterWrapper(writer);
        this.options = options;
        this.prefix = prefix;
    }

    public MailProcessor(MailOptions options, String prefix, ChunkedWriter writer) {
        this.writer = new ChunkedWrapper(writer);
        this.options = options;
        this.prefix = prefix;
    }

    public long parseMboxLineByLine(File mboxFile) throws IOException {
        long messageCount = 0L;
        try {
            StringBuilder contents = new StringBuilder();
            StringBuilder body = new StringBuilder();
            Matcher messageIdMatcher = MESSAGE_ID_PREFIX.matcher("");
            Matcher messageBoundaryMatcher = MESSAGE_START.matcher("");
            String[] patternResults = new String[this.options.getPatternsToMatch().length];
            Matcher[] matchers = new Matcher[this.options.getPatternsToMatch().length];
            for (int i = 0; i < matchers.length; ++i) {
                matchers[i] = this.options.getPatternsToMatch()[i].matcher("");
            }
            String messageId = null;
            boolean inBody = false;
            Pattern quotedTextPattern = this.options.getQuotedTextPattern();
            for (String nextLine : new FileLineIterable(mboxFile, this.options.getCharset(), false)) {
                if (this.options.isStripQuotedText() && quotedTextPattern.matcher(nextLine).find()) continue;
                for (int i = 0; i < matchers.length; ++i) {
                    Matcher matcher = matchers[i];
                    matcher.reset(nextLine);
                    if (!matcher.matches()) continue;
                    patternResults[i] = matcher.group(1);
                }
                if (messageId != null) {
                    messageBoundaryMatcher.reset(nextLine);
                    if (messageBoundaryMatcher.matches()) {
                        String key = MailProcessor.generateKey(mboxFile, this.prefix, messageId);
                        MailProcessor.writeContent(this.options.getSeparator(), contents, body, patternResults);
                        this.writer.write(key, contents.toString());
                        contents.setLength(0);
                        body.setLength(0);
                        messageId = null;
                        inBody = false;
                        continue;
                    }
                    if (inBody && this.options.isIncludeBody()) {
                        if (nextLine.isEmpty()) continue;
                        body.append(nextLine).append(this.options.getBodySeparator());
                        continue;
                    }
                    inBody = nextLine.isEmpty();
                    continue;
                }
                if (nextLine.length() <= 14) continue;
                messageIdMatcher.reset(nextLine);
                if (!messageIdMatcher.matches()) continue;
                messageId = messageIdMatcher.group(1);
                ++messageCount;
            }
            if (messageId != null) {
                String key = MailProcessor.generateKey(mboxFile, this.prefix, messageId);
                MailProcessor.writeContent(this.options.getSeparator(), contents, body, patternResults);
                this.writer.write(key, contents.toString());
                contents.setLength(0);
            }
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        return messageCount;
    }

    protected static String generateKey(File mboxFile, String prefix, String messageId) {
        return prefix + File.separator + mboxFile.getName() + File.separator + messageId;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public MailOptions getOptions() {
        return this.options;
    }

    private static void writeContent(String separator, StringBuilder contents, CharSequence body, String[] matches) {
        for (String match : matches) {
            if (match != null) {
                contents.append(match).append(separator);
                continue;
            }
            contents.append("").append(separator);
        }
        contents.append('\n').append(body);
    }
}

