/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text.wikipedia;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.StopwordAnalyzerBase;
import org.apache.lucene.analysis.wikipedia.WikipediaTokenizer;
import org.apache.lucene.util.Version;

public class WikipediaAnalyzer
extends StopwordAnalyzerBase {
    public WikipediaAnalyzer() {
        super(Version.LUCENE_43, StopAnalyzer.ENGLISH_STOP_WORDS_SET);
    }

    public WikipediaAnalyzer(CharArraySet stopSet) {
        super(Version.LUCENE_43, stopSet);
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        WikipediaTokenizer tokenizer = new WikipediaTokenizer(reader);
        StandardFilter result = new StandardFilter(Version.LUCENE_43, (TokenStream)tokenizer);
        result = new LowerCaseFilter(Version.LUCENE_43, (TokenStream)result);
        result = new StopFilter(Version.LUCENE_43, (TokenStream)result, this.getStopwordSet());
        return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)result);
    }
}

