/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.swing;

import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.uncommons.maths.AdjustableNumberGenerator;
import org.uncommons.maths.NumberGenerator;
import org.uncommons.watchmaker.swing.EvolutionControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericParameterControl<T extends Number>
implements EvolutionControl {
    private final T defaultValue;
    private final JSpinner control;
    private final AdjustableNumberGenerator<T> numberGenerator;

    public NumericParameterControl(T minimum, T maximum, T stepSize, T initialValue) {
        this.defaultValue = initialValue;
        this.numberGenerator = new AdjustableNumberGenerator(this.defaultValue);
        this.control = new JSpinner(new SpinnerNumberModel((Number)initialValue, (Comparable)minimum, (Comparable)maximum, (Number)stepSize));
        this.control.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                NumericParameterControl.this.numberGenerator.setValue((Number)NumericParameterControl.this.control.getValue());
            }
        });
    }

    @Override
    public JSpinner getControl() {
        return this.control;
    }

    @Override
    public void reset() {
        this.control.setValue(this.defaultValue);
        this.control.setEnabled(true);
    }

    public NumberGenerator<T> getNumberGenerator() {
        return this.numberGenerator;
    }
}

