/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

class CapacitySchedulerConf {
    public static final String SCHEDULER_CONF_FILE = "capacity-scheduler.xml";
    private int defaultUlimitMinimum;
    private float defaultUserLimitFactor;
    private boolean defaultSupportPriority;
    private static final String QUEUE_CONF_PROPERTY_NAME_PREFIX = "mapred.capacity-scheduler.queue.";
    @Deprecated
    static String DEFAULT_PERCENTAGE_OF_PMEM_IN_VMEM_PROPERTY = "mapred.capacity-scheduler.task.default-pmem-percentage-in-vmem";
    @Deprecated
    static final String UPPER_LIMIT_ON_TASK_PMEM_PROPERTY = "mapred.capacity-scheduler.task.limit.maxpmem";
    private static final String CAPACITY_PROPERTY = "capacity";
    static final String MAX_CAPACITY_PROPERTY = "maximum-capacity";
    private static final int INITIALIZATION_THREAD_POLLING_INTERVAL = 3000;
    private static final int MAX_INITIALIZATION_WORKER_THREADS = 5;
    private Configuration rmConf = new Configuration(false);
    private int defaultInitToAcceptJobsFactor;
    private int defaultMaxActiveTasksPerUserToInitialize;
    private int defaultMaxActiveTasksPerQueueToInitialize;
    static final String MAX_SYSTEM_JOBS_KEY = "mapred.capacity-scheduler.maximum-system-jobs";
    static final int DEFAULT_MAX_SYSTEM_JOBS = 5000;
    static final int DEFAULT_MAX_TASKS_TO_SCHEDULE_AFTER_OFFSWITCH = 0;

    public CapacitySchedulerConf() {
        this.rmConf.addResource(SCHEDULER_CONF_FILE);
        this.initializeDefaults();
    }

    public CapacitySchedulerConf(Path configFile) {
        this.rmConf.addResource(configFile);
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        this.defaultUlimitMinimum = this.rmConf.getInt("mapred.capacity-scheduler.default-minimum-user-limit-percent", 100);
        this.defaultUserLimitFactor = this.rmConf.getFloat("mapred.capacity-scheduler.default-user-limit-factor", 1.0f);
        this.defaultSupportPriority = this.rmConf.getBoolean("mapred.capacity-scheduler.default-supports-priority", false);
        this.defaultMaxActiveTasksPerQueueToInitialize = this.rmConf.getInt("mapred.capacity-scheduler.default-maximum-active-tasks-per-queue", 200000);
        this.defaultMaxActiveTasksPerUserToInitialize = this.rmConf.getInt("mapred.capacity-scheduler.default-maximum-active-tasks-per-user", 100000);
        this.defaultInitToAcceptJobsFactor = this.rmConf.getInt("mapred.capacity-scheduler.default-init-accept-jobs-factor", 10);
    }

    public float getCapacity(String queue) {
        String raw = this.rmConf.getRaw(CapacitySchedulerConf.toFullPropertyName(queue, CAPACITY_PROPERTY));
        if (raw == null) {
            return -1.0f;
        }
        float result = this.rmConf.getFloat(CapacitySchedulerConf.toFullPropertyName(queue, CAPACITY_PROPERTY), -1.0f);
        if ((double)result < 0.0 || (double)result > 100.0) {
            throw new IllegalArgumentException("Illegal capacity for queue " + queue + " of " + result);
        }
        return result;
    }

    public void setCapacity(String queue, float capacity) {
        this.rmConf.setFloat(CapacitySchedulerConf.toFullPropertyName(queue, CAPACITY_PROPERTY), capacity);
    }

    public float getMaxCapacity(String queue) {
        float result = this.rmConf.getFloat(CapacitySchedulerConf.toFullPropertyName(queue, MAX_CAPACITY_PROPERTY), -1.0f);
        float f = result = result <= 0.0f ? -1.0f : result;
        if ((double)result > 100.0) {
            throw new IllegalArgumentException("Illegal maximum-capacity for queue " + queue + " of " + result);
        }
        if (result != -1.0f && result < this.getCapacity(queue)) {
            throw new IllegalArgumentException("maximum-capacity " + result + " for a queue should be greater than or equal to capacity ");
        }
        return result;
    }

    public void setMaxCapacity(String queue, float maxCapacity) {
        this.rmConf.setFloat(CapacitySchedulerConf.toFullPropertyName(queue, MAX_CAPACITY_PROPERTY), maxCapacity);
    }

    public boolean isPrioritySupported(String queue) {
        return this.rmConf.getBoolean(CapacitySchedulerConf.toFullPropertyName(queue, "supports-priority"), this.defaultSupportPriority);
    }

    public void setPrioritySupported(String queue, boolean value) {
        this.rmConf.setBoolean(CapacitySchedulerConf.toFullPropertyName(queue, "supports-priority"), value);
    }

    public int getMinimumUserLimitPercent(String queue) {
        int userLimit = this.rmConf.getInt(CapacitySchedulerConf.toFullPropertyName(queue, "minimum-user-limit-percent"), this.defaultUlimitMinimum);
        if (userLimit <= 0 || userLimit > 100) {
            throw new IllegalArgumentException("Invalid user limit : " + userLimit + " for queue : " + queue);
        }
        return userLimit;
    }

    public void setMinimumUserLimitPercent(String queue, int value) {
        this.rmConf.setInt(CapacitySchedulerConf.toFullPropertyName(queue, "minimum-user-limit-percent"), value);
    }

    public float getUserLimitFactor(String queue) {
        return this.rmConf.getFloat(CapacitySchedulerConf.toFullPropertyName(queue, "user-limit-factor"), this.defaultUserLimitFactor);
    }

    public void setUserLimitFactor(String queue, float userLimitFactor) {
        this.rmConf.setFloat(CapacitySchedulerConf.toFullPropertyName(queue, "user-limit-factor"), userLimitFactor);
    }

    public synchronized void reloadConfiguration() {
        this.rmConf.reloadConfiguration();
        this.initializeDefaults();
    }

    static final String toFullPropertyName(String queue, String property) {
        return QUEUE_CONF_PROPERTY_NAME_PREFIX + queue + "." + property;
    }

    public int getMaxSystemJobs() {
        int maxSystemJobs = this.rmConf.getInt(MAX_SYSTEM_JOBS_KEY, 5000);
        if (maxSystemJobs <= 0) {
            throw new IllegalArgumentException("Invalid maximum system jobs: " + maxSystemJobs);
        }
        return maxSystemJobs;
    }

    public void setMaxSystemJobs(int maxSystemJobs) {
        this.rmConf.setInt(MAX_SYSTEM_JOBS_KEY, maxSystemJobs);
    }

    public int getInitToAcceptJobsFactor(String queue) {
        int initToAccepFactor = this.rmConf.getInt(CapacitySchedulerConf.toFullPropertyName(queue, "init-accept-jobs-factor"), this.defaultInitToAcceptJobsFactor);
        if (initToAccepFactor <= 0) {
            throw new IllegalArgumentException("Invalid maximum jobs per user configuration " + initToAccepFactor);
        }
        return initToAccepFactor;
    }

    public void setInitToAcceptJobsFactor(String queue, int initToAcceptFactor) {
        this.rmConf.setInt(CapacitySchedulerConf.toFullPropertyName(queue, "init-accept-jobs-factor"), initToAcceptFactor);
    }

    public int getMaxInitializedActiveTasks(String queue) {
        return this.rmConf.getInt(CapacitySchedulerConf.toFullPropertyName(queue, "maximum-initialized-active-tasks"), this.defaultMaxActiveTasksPerQueueToInitialize);
    }

    public void setMaxInitializedActiveTasks(String queue, int value) {
        this.rmConf.setInt(CapacitySchedulerConf.toFullPropertyName(queue, "maximum-initialized-active-tasks"), value);
    }

    public int getMaxInitializedActiveTasksPerUser(String queue) {
        return this.rmConf.getInt(CapacitySchedulerConf.toFullPropertyName(queue, "maximum-initialized-active-tasks-per-user"), this.defaultMaxActiveTasksPerUserToInitialize);
    }

    public void setMaxInitializedActiveTasksPerUser(String queue, int value) {
        this.rmConf.setInt(CapacitySchedulerConf.toFullPropertyName(queue, "maximum-initialized-active-tasks-per-user"), value);
    }

    public long getSleepInterval() {
        long sleepInterval = this.rmConf.getLong("mapred.capacity-scheduler.init-poll-interval", 3000L);
        if (sleepInterval <= 0L) {
            throw new IllegalArgumentException("Invalid initializater poller interval " + sleepInterval);
        }
        return sleepInterval;
    }

    public int getMaxWorkerThreads() {
        int maxWorkerThreads = this.rmConf.getInt("mapred.capacity-scheduler.init-worker-threads", 5);
        if (maxWorkerThreads <= 0) {
            throw new IllegalArgumentException("Invalid initializater worker thread number " + maxWorkerThreads);
        }
        return maxWorkerThreads;
    }

    public void setSleepInterval(long interval) {
        this.rmConf.setLong("mapred.capacity-scheduler.init-poll-interval", interval);
    }

    public void setMaxWorkerThreads(int poolSize) {
        this.rmConf.setInt("mapred.capacity-scheduler.init-worker-threads", poolSize);
    }

    public int getMaxTasksPerHeartbeat() {
        return this.rmConf.getInt("mapred.capacity-scheduler.maximum-tasks-per-heartbeat", Short.MAX_VALUE);
    }

    public void setMaxTasksPerHeartbeat(int maxTasksPerHeartbeat) {
        this.rmConf.setInt("mapred.capacity-scheduler.maximum-tasks-per-heartbeat", maxTasksPerHeartbeat);
    }

    public int getMaxTasksToAssignAfterOffSwitch() {
        return this.rmConf.getInt("mapred.capacity-scheduler.maximum-tasks-after-offswitch", 0);
    }

    public void setMaxTasksToAssignAfterOffSwitch(int maxTasksToAssignAfterOffSwitch) {
        this.rmConf.setInt("mapred.capacity-scheduler.maximum-tasks-after-offswitch", maxTasksToAssignAfterOffSwitch);
    }
}

