/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldclient.provider.youtube;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.marmotta.ldclient.api.endpoint.Endpoint;
import org.apache.marmotta.ldclient.api.provider.DataProvider;
import org.apache.marmotta.ldclient.provider.xml.AbstractXMLDataProvider;
import org.apache.marmotta.ldclient.provider.xml.mapping.XPathLiteralMapper;
import org.apache.marmotta.ldclient.provider.xml.mapping.XPathURIMapper;
import org.apache.marmotta.ldclient.provider.xml.mapping.XPathValueMapper;
import org.apache.marmotta.ldclient.provider.youtube.mapping.YoutubeUriMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YoutubeChannelProvider
extends AbstractXMLDataProvider
implements DataProvider {
    private static final String NS_MEDIA = "http://www.w3.org/ns/ma-ont#";
    private static Map<String, String> youtubeNamespaces = new HashMap<String, String>();
    private static Map<String, XPathValueMapper> mediaOntMappings;
    private static Logger log;

    public String getName() {
        return "YouTube Channel";
    }

    public String[] listMimeTypes() {
        return new String[]{"application/atom+xml"};
    }

    public List<String> buildRequestUrl(String resource, Endpoint endpoint) {
        if (resource.startsWith("http://www.youtube.com/user/")) {
            try {
                URI uri = new URI(resource);
                String[] p_components = uri.getPath().split("/");
                String user_id = p_components[p_components.length - 1];
                return Collections.singletonList("http://gdata.youtube.com/feeds/api/users/" + user_id + "/uploads");
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("URI '" + resource + "'could not be parsed, it is not a valid URI");
            }
        }
        if (resource.startsWith("http://gdata.youtube.com/feeds/api/users/")) {
            if (!resource.endsWith("/uploads")) {
                return Collections.singletonList(resource + "/uploads");
            }
            return Collections.singletonList(resource);
        }
        throw new RuntimeException("URI '" + resource + "' not supported by this data provider");
    }

    protected Map<String, XPathValueMapper> getXPathMappings(String requestUrl) {
        return mediaOntMappings;
    }

    protected List<String> getTypes(org.openrdf.model.URI resource) {
        return ImmutableList.of((Object)"http://www.w3.org/ns/ma-ont#Collection", (Object)"http://www.newmedialab.at/lmf/types/1.0/YoutubePlaylist");
    }

    protected Map<String, String> getNamespaceMappings() {
        return youtubeNamespaces;
    }

    static {
        youtubeNamespaces.put("atom", "http://www.w3.org/2005/Atom");
        youtubeNamespaces.put("media", "http://search.yahoo.com/mrss/");
        youtubeNamespaces.put("yt", "http://gdata.youtube.com/schemas/2007");
        youtubeNamespaces.put("gd", "http://schemas.google.com/g/2005");
        youtubeNamespaces.put("georss", "http://www.georss.org/georss");
        youtubeNamespaces.put("gml", "http://www.opengis.net/gml");
        mediaOntMappings = new HashMap<String, XPathValueMapper>();
        mediaOntMappings.put("http://www.w3.org/ns/ma-ont#collectionName", (XPathValueMapper)new XPathLiteralMapper("/atom:feed/atom:title", youtubeNamespaces));
        mediaOntMappings.put("http://www.w3.org/ns/ma-ont#hasMember", new YoutubeUriMapper("/atom:feed/atom:entry/atom:id", youtubeNamespaces));
        mediaOntMappings.put("http://www.w3.org/ns/ma-ont#hasCreator", (XPathValueMapper)new XPathURIMapper("/atom:feed/atom:author/@uri", youtubeNamespaces));
        mediaOntMappings.put("http://www.w3.org/ns/ma-ont#hasPublisher", (XPathValueMapper)new XPathURIMapper("/atom:feed/atom:author/@uri", youtubeNamespaces));
        log = LoggerFactory.getLogger(YoutubeChannelProvider.class);
    }
}

