/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldclient.provider.youtube;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.marmotta.ldclient.api.endpoint.Endpoint;
import org.apache.marmotta.ldclient.api.provider.DataProvider;
import org.apache.marmotta.ldclient.provider.xml.AbstractXMLDataProvider;
import org.apache.marmotta.ldclient.provider.xml.mapping.CommaSeparatedMapper;
import org.apache.marmotta.ldclient.provider.xml.mapping.XPathLiteralMapper;
import org.apache.marmotta.ldclient.provider.xml.mapping.XPathURIMapper;
import org.apache.marmotta.ldclient.provider.xml.mapping.XPathValueMapper;
import org.apache.marmotta.ldclient.provider.youtube.mapping.YoutubeCategoryMapper;
import org.apache.marmotta.ldclient.provider.youtube.mapping.YoutubeLatitudeMapper;
import org.apache.marmotta.ldclient.provider.youtube.mapping.YoutubeLongitudeMapper;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YoutubeVideoProvider
extends AbstractXMLDataProvider
implements DataProvider {
    public static final String YOUTUBE_BASE_URI = "http://youtu.be/";
    private static final String GDATA_VIDEO_FEED = "http://gdata.youtube.com/feeds/api/videos/";
    private static final String NS_MEDIA = "http://www.w3.org/ns/ma-ont#";
    private static Logger log = LoggerFactory.getLogger(YoutubeVideoProvider.class);
    private static Map<String, String> youtubeNamespaces = new HashMap<String, String>();
    private static Map<String, XPathValueMapper> mediaOntMappings;

    public String getName() {
        return "YouTube Video";
    }

    public String[] listMimeTypes() {
        return new String[]{"application/atom+xml"};
    }

    public List<String> buildRequestUrl(String resource, Endpoint endpoint) {
        String video_id;
        String uri = resource;
        if (uri.startsWith(YOUTUBE_BASE_URI) && StringUtils.isNotBlank((CharSequence)(video_id = StringUtils.removeStart((String)uri, (String)YOUTUBE_BASE_URI)))) {
            return Collections.singletonList(GDATA_VIDEO_FEED + video_id);
        }
        return Collections.singletonList(uri);
    }

    protected Map<String, XPathValueMapper> getXPathMappings(String requestUrl) {
        return mediaOntMappings;
    }

    protected List<String> getTypes(URI resource) {
        return ImmutableList.of((Object)"http://www.w3.org/ns/ma-ont#MediaResource", (Object)"http://www.w3.org/ns/ma-ont#VideoTrack", (Object)"http://www.newmedialab.at/lmf/types/1.0/YoutubeVideo");
    }

    protected Map<String, String> getNamespaceMappings() {
        return youtubeNamespaces;
    }

    static {
        youtubeNamespaces.put("atom", "http://www.w3.org/2005/Atom");
        youtubeNamespaces.put("media", "http://search.yahoo.com/mrss/");
        youtubeNamespaces.put("yt", "http://gdata.youtube.com/schemas/2007");
        youtubeNamespaces.put("gd", "http://schemas.google.com/g/2005");
        youtubeNamespaces.put("georss", "http://www.georss.org/georss");
        youtubeNamespaces.put("gml", "http://www.opengis.net/gml");
        mediaOntMappings = new HashMap<String, XPathValueMapper>();
        mediaOntMappings.put("http://www.w3.org/ns/ma-ont#title", (XPathValueMapper)new XPathLiteralMapper("/atom:entry/atom:title", youtubeNamespaces));
        mediaOntMappings.put("http://www.w3.org/ns/ma-ont#locator", (XPathValueMapper)new XPathLiteralMapper("/atom:entry/media:group/media:content/@url", youtubeNamespaces, "anyURI"));
        mediaOntMappings.put("http://www.w3.org/ns/ma-ont#hasCreator", (XPathValueMapper)new XPathURIMapper("/atom:entry/atom:author/@uri", youtubeNamespaces));
        mediaOntMappings.put("http://www.w3.org/ns/ma-ont#hasPublisher", (XPathValueMapper)new XPathURIMapper("/atom:entry/atom:author/@uri", youtubeNamespaces));
        mediaOntMappings.put("http://www.w3.org/ns/ma-ont#date", (XPathValueMapper)new XPathLiteralMapper("/atom:entry/atom:published", youtubeNamespaces, "dateTime"));
        mediaOntMappings.put("http://www.w3.org/ns/ma-ont#locationLatitude", (XPathValueMapper)new YoutubeLatitudeMapper("/atom:entry/georss:where/gml:Point/gml:pos", youtubeNamespaces));
        mediaOntMappings.put("http://www.w3.org/ns/ma-ont#locationLongitude", (XPathValueMapper)new YoutubeLongitudeMapper("/atom:entry/georss:where/gml:Point/gml:pos", youtubeNamespaces));
        mediaOntMappings.put("http://www.w3.org/ns/ma-ont#description", (XPathValueMapper)new XPathLiteralMapper("/atom:entry/media:group/media:description", youtubeNamespaces));
        mediaOntMappings.put("http://www.w3.org/ns/ma-ont#hasKeyword", (XPathValueMapper)new XPathLiteralMapper("/atom:entry/atom:category[@scheme='http://gdata.youtube.com/schemas/2007/keywords.cat']/@term", youtubeNamespaces));
        mediaOntMappings.put("http://www.w3.org/ns/ma-ont#hasGenre", new YoutubeCategoryMapper("/atom:entry/media:group/media:category", youtubeNamespaces));
        mediaOntMappings.put("http://www.w3.org/ns/ma-ont#hasRating", (XPathValueMapper)new XPathLiteralMapper("/atom:entry/gd:rating/@average", youtubeNamespaces, "float"));
        mediaOntMappings.put("http://www.w3.org/ns/ma-ont#copyright", (XPathValueMapper)new XPathURIMapper("/atom:entry/media:group/media:license/@href", youtubeNamespaces));
        mediaOntMappings.put("http://www.w3.org/ns/ma-ont#hasCompression", (XPathValueMapper)new XPathLiteralMapper("/atom:entry/media:group/media:content/@type", youtubeNamespaces));
        mediaOntMappings.put("http://www.w3.org/ns/ma-ont#duration", (XPathValueMapper)new XPathLiteralMapper("/atom:entry/media:group/media:content/@duration", youtubeNamespaces, "integer"));
        mediaOntMappings.put("http://www.w3.org/ns/ma-ont#format", (XPathValueMapper)new XPathLiteralMapper("/atom:entry/media:group/media:content/@type", youtubeNamespaces));
        mediaOntMappings.put("http://xmlns.com/foaf/0.1/thumbnail", (XPathValueMapper)new CommaSeparatedMapper("/atom:entry/media:group/media:thumbnail/@url", youtubeNamespaces, "anyURI"));
        mediaOntMappings.put("http://rdfs.org/sioc/ns#num_views", (XPathValueMapper)new XPathLiteralMapper("/atom:entry/yt:statistics/@viewCount", youtubeNamespaces, "integer"));
    }
}

